/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util.cache;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.XMPPServerListener;
import org.jivesoftware.openfire.cluster.ClusterEventListener;
import org.jivesoftware.openfire.cluster.ClusterManager;
import org.jivesoftware.openfire.cluster.ClusterNodeInfo;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginClassLoader;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.util.InitializationException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactoryStrategy;
import org.jivesoftware.util.cache.CacheWrapper;
import org.jivesoftware.util.cache.ClusterTask;
import org.jivesoftware.util.cache.ComponentCacheWrapper;
import org.jivesoftware.util.cache.DefaultLocalCacheStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheFactory {
    private static final Logger log = LoggerFactory.getLogger(CacheFactory.class);
    public static String LOCAL_CACHE_PROPERTY_NAME = "cache.clustering.local.class";
    public static String CLUSTERED_CACHE_PROPERTY_NAME = "cache.clustering.clustered.class";
    private static boolean clusteringStarted = false;
    private static boolean clusteringStarting = false;
    private static Map<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private static List<String> localOnly = Collections.synchronizedList(new ArrayList());
    private static String localCacheFactoryClass;
    private static String clusteredCacheFactoryClass;
    private static CacheFactoryStrategy cacheFactoryStrategy;
    private static CacheFactoryStrategy localCacheFactoryStrategy;
    private static CacheFactoryStrategy clusteredCacheFactoryStrategy;
    private static Thread statsThread;
    public static final int DEFAULT_MAX_CACHE_SIZE = 262144;
    public static final long DEFAULT_MAX_CACHE_LIFETIME = 21600000L;
    private static final Map<String, String> cacheNames;
    private static final Map<String, Long> cacheProps;

    private CacheFactory() {
    }

    public static long getMaxCacheSize(String cacheName) {
        return CacheFactory.getCacheProperty(cacheName, ".size", 262144L);
    }

    public static void setMaxSizeProperty(String cacheName, long size) {
        cacheName = cacheName.replaceAll(" ", "");
        if (!Long.toString(size).equals(JiveGlobals.getProperty("cache." + cacheName + ".size"))) {
            JiveGlobals.setProperty("cache." + cacheName + ".size", Long.toString(size));
        }
    }

    public static boolean hasMaxSizeFromProperty(String cacheName) {
        return CacheFactory.hasCacheProperty(cacheName, ".size");
    }

    public static long getMaxCacheLifetime(String cacheName) {
        return CacheFactory.getCacheProperty(cacheName, ".maxLifetime", 21600000L);
    }

    public static void setMaxLifetimeProperty(String cacheName, long lifetime) {
        cacheName = cacheName.replaceAll(" ", "");
        if (!Long.toString(lifetime).equals(JiveGlobals.getProperty("cache." + cacheName + ".maxLifetime"))) {
            JiveGlobals.setProperty("cache." + cacheName + ".maxLifetime", Long.toString(lifetime));
        }
    }

    public static boolean hasMaxLifetimeFromProperty(String cacheName) {
        return CacheFactory.hasCacheProperty(cacheName, ".maxLifetime");
    }

    public static void setCacheTypeProperty(String cacheName, String type) {
        cacheName = cacheName.replaceAll(" ", "");
        if (!type.equals(JiveGlobals.getProperty("cache." + cacheName + ".type"))) {
            JiveGlobals.setProperty("cache." + cacheName + ".type", type);
        }
    }

    public static String getCacheTypeProperty(String cacheName) {
        cacheName = cacheName.replaceAll(" ", "");
        return JiveGlobals.getProperty("cache." + cacheName + ".type");
    }

    public static void setMinCacheSize(String cacheName, long size) {
        cacheName = cacheName.replaceAll(" ", "");
        if (!Long.toString(size).equals(JiveGlobals.getProperty("cache." + cacheName + ".min"))) {
            JiveGlobals.setProperty("cache." + cacheName + ".min", Long.toString(size));
        }
    }

    public static long getMinCacheSize(String cacheName) {
        return CacheFactory.getCacheProperty(cacheName, ".min", 0L);
    }

    private static Cache getCacheByProperty(String property) {
        if (!property.startsWith("cache.")) {
            return null;
        }
        String name = property.substring("cache.".length(), property.lastIndexOf("."));
        for (Map.Entry<String, String> entry : cacheNames.entrySet()) {
            if (!name.equals(entry.getValue())) continue;
            return caches.get(entry.getKey());
        }
        for (Map.Entry<String, Object> entry : caches.entrySet()) {
            if (!entry.getKey().replaceAll(" ", "").equals(name)) continue;
            return (Cache)entry.getValue();
        }
        return null;
    }

    private static long getCacheProperty(String cacheName, String suffix, long defaultValue) {
        Long defaultSize;
        String propName = "cache." + cacheName.replaceAll(" ", "") + suffix;
        String sizeProp = JiveGlobals.getProperty(propName);
        if (sizeProp == null && cacheNames.containsKey(cacheName)) {
            propName = "cache." + cacheNames.get(cacheName) + suffix;
            sizeProp = JiveGlobals.getProperty(propName);
        }
        if (sizeProp != null) {
            try {
                return Long.parseLong(sizeProp);
            }
            catch (NumberFormatException nfe) {
                log.warn("Unable to parse " + propName + " using default value.");
            }
        }
        return (defaultSize = cacheProps.get(propName)) == null ? defaultValue : defaultSize;
    }

    private static boolean hasCacheProperty(String cacheName, String suffix) {
        String propName = "cache." + cacheName.replaceAll(" ", "") + suffix;
        String sizeProp = JiveGlobals.getProperty(propName);
        if (sizeProp == null && cacheNames.containsKey(cacheName)) {
            propName = "cache." + cacheNames.get(cacheName) + suffix;
            sizeProp = JiveGlobals.getProperty(propName);
        }
        if (sizeProp != null) {
            try {
                Long.parseLong(sizeProp);
                return true;
            }
            catch (NumberFormatException nfe) {
                log.warn("Unable to parse " + propName + " using default value.");
            }
        }
        return false;
    }

    public static Cache[] getAllCaches() {
        ArrayList<Cache> values = new ArrayList<Cache>();
        for (Cache cache : caches.values()) {
            values.add(cache);
        }
        return values.toArray(new Cache[values.size()]);
    }

    public static synchronized <T extends Cache> T createCache(String name) {
        Cache cache = caches.get(name);
        if (cache != null) {
            return (T)cache;
        }
        cache = cacheFactoryStrategy.createCache(name);
        log.info("Created cache [" + cacheFactoryStrategy.getClass().getName() + "] for " + name);
        return (T)CacheFactory.wrapCache(cache, name);
    }

    public static synchronized <T extends Cache> T createLocalCache(String name) {
        Cache cache = caches.get(name);
        if (cache != null) {
            return (T)cache;
        }
        cache = localCacheFactoryStrategy.createCache(name);
        localOnly.add(name);
        log.info("Created local-only cache [" + localCacheFactoryClass + "] for " + name);
        return (T)CacheFactory.wrapCache(cache, name);
    }

    public static synchronized void destroyCache(String name) {
        Cache cache = caches.remove(name);
        if (cache != null) {
            if (localOnly.contains(name)) {
                localOnly.remove(name);
                localCacheFactoryStrategy.destroyCache(cache);
            } else {
                cacheFactoryStrategy.destroyCache(cache);
            }
        }
    }

    public static synchronized Lock getLock(Object key, Cache cache) {
        if (localOnly.contains(cache.getName())) {
            return localCacheFactoryStrategy.getLock(key, cache);
        }
        return cacheFactoryStrategy.getLock(key, cache);
    }

    private static <T extends Cache> T wrapCache(T cache, String name) {
        cache = "Routing Components Cache".equals(name) ? new ComponentCacheWrapper(cache) : new CacheWrapper(cache);
        cache.setName(name);
        caches.put(name, (Cache)cache);
        return (T)cache;
    }

    public static boolean isClusteringAvailable() {
        if (clusteredCacheFactoryStrategy == null) {
            try {
                clusteredCacheFactoryStrategy = (CacheFactoryStrategy)Class.forName(clusteredCacheFactoryClass, true, CacheFactory.getClusteredCacheStrategyClassLoader()).newInstance();
            }
            catch (Exception | NoClassDefFoundError e) {
                log.warn("Clustered cache factory strategy " + clusteredCacheFactoryClass + " not found");
            }
        }
        return clusteredCacheFactoryStrategy != null;
    }

    public static boolean isClusteringStarting() {
        return clusteringStarting;
    }

    public static boolean isClusteringStarted() {
        return clusteringStarted;
    }

    public static byte[] getClusterMemberID() {
        return cacheFactoryStrategy.getClusterMemberID();
    }

    public static synchronized void clearCaches() {
        for (String cacheName : caches.keySet()) {
            Cache cache = caches.get(cacheName);
            cache.clear();
        }
    }

    public static byte[] getSeniorClusterMemberID() {
        return cacheFactoryStrategy.getSeniorClusterMemberID();
    }

    public static boolean isSeniorClusterMember() {
        return cacheFactoryStrategy.isSeniorClusterMember();
    }

    public static Collection<ClusterNodeInfo> getClusterNodesInfo() {
        return cacheFactoryStrategy.getClusterNodesInfo();
    }

    public static int getMaxClusterNodes() {
        return cacheFactoryStrategy.getMaxClusterNodes();
    }

    public static long getClusterTime() {
        try {
            return cacheFactoryStrategy.getClusterTime();
        }
        catch (AbstractMethodError ame) {
            log.warn("Cluster time not available; check for update to hazelcast/clustering plugin");
            return localCacheFactoryStrategy.getClusterTime();
        }
    }

    public static void doClusterTask(ClusterTask<?> task) {
        cacheFactoryStrategy.doClusterTask(task);
    }

    public static void doClusterTask(ClusterTask<?> task, byte[] nodeID) {
        cacheFactoryStrategy.doClusterTask(task, nodeID);
    }

    public static Collection<Object> doSynchronousClusterTask(ClusterTask<?> task, boolean includeLocalMember) {
        return cacheFactoryStrategy.doSynchronousClusterTask(task, includeLocalMember);
    }

    public static Object doSynchronousClusterTask(ClusterTask<?> task, byte[] nodeID) {
        return cacheFactoryStrategy.doSynchronousClusterTask(task, nodeID);
    }

    public static ClusterNodeInfo getClusterNodeInfo(byte[] nodeID) {
        return cacheFactoryStrategy.getClusterNodeInfo(nodeID);
    }

    public static String getPluginName() {
        return cacheFactoryStrategy.getPluginName();
    }

    public static synchronized void initialize() throws InitializationException {
        try {
            cacheFactoryStrategy = localCacheFactoryStrategy = (CacheFactoryStrategy)Class.forName(localCacheFactoryClass).newInstance();
        }
        catch (Exception e) {
            log.error("Failed to instantiate local cache factory strategy: " + localCacheFactoryClass, (Throwable)e);
            throw new InitializationException(e);
        }
    }

    private static ClassLoader getClusteredCacheStrategyClassLoader() {
        PluginClassLoader pluginLoader;
        PluginManager pluginManager = XMPPServer.getInstance().getPluginManager();
        Plugin plugin = pluginManager.getPlugin("hazelcast");
        if (plugin == null && (plugin = pluginManager.getPlugin("clustering")) == null) {
            plugin = pluginManager.getPlugin("enterprise");
        }
        if ((pluginLoader = pluginManager.getPluginClassloader(plugin)) != null) {
            if (log.isDebugEnabled()) {
                StringBuffer pluginLoaderDetails = new StringBuffer("Clustering plugin class loader: ");
                pluginLoaderDetails.append(pluginLoader.getClass().getName());
                for (URL url : pluginLoader.getURLs()) {
                    pluginLoaderDetails.append("\n\t").append(url.toExternalForm());
                }
                log.debug(pluginLoaderDetails.toString());
            }
            return pluginLoader;
        }
        log.warn("CacheFactory - Unable to find a Plugin that provides clustering support.");
        return Thread.currentThread().getContextClassLoader();
    }

    public static void startClustering() {
        if (CacheFactory.isClusteringAvailable()) {
            clusteringStarting = clusteredCacheFactoryStrategy.startCluster();
        }
        if (clusteringStarting && statsThread == null) {
            statsThread = new Thread("Cache Stats"){
                private volatile boolean destroyed = false;

                @Override
                public void run() {
                    XMPPServer.getInstance().addServerListener(new XMPPServerListener(){

                        @Override
                        public void serverStarted() {
                        }

                        @Override
                        public void serverStopping() {
                            destroyed = true;
                        }
                    });
                    ClusterManager.addListener(new ClusterEventListener(){

                        @Override
                        public void joinedCluster() {
                        }

                        @Override
                        public void joinedCluster(byte[] nodeID) {
                        }

                        @Override
                        public void leftCluster() {
                            destroyed = true;
                            ClusterManager.removeListener(this);
                        }

                        @Override
                        public void leftCluster(byte[] nodeID) {
                        }

                        @Override
                        public void markedAsSeniorClusterMember() {
                        }
                    });
                    while (!this.destroyed && ClusterManager.isClusteringEnabled()) {
                        try {
                            cacheFactoryStrategy.updateCacheStats(caches);
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                        try {
                            2.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    statsThread = null;
                    log.debug("Cache stats thread terminated.");
                }
            };
            statsThread.setDaemon(true);
            statsThread.start();
        }
    }

    public static void stopClustering() {
        clusteredCacheFactoryStrategy.stopCluster();
        clusteredCacheFactoryStrategy = null;
        cacheFactoryStrategy = localCacheFactoryStrategy;
    }

    public static synchronized void joinedCluster() {
        cacheFactoryStrategy = clusteredCacheFactoryStrategy;
        for (Cache cache : CacheFactory.getAllCaches()) {
            if (localOnly.contains(cache.getName())) continue;
            CacheWrapper cacheWrapper = (CacheWrapper)cache;
            Cache clusteredCache = cacheFactoryStrategy.createCache(cacheWrapper.getName());
            clusteredCache.putAll(cache);
            cacheWrapper.setWrappedCache(clusteredCache);
        }
        clusteringStarting = false;
        clusteringStarted = true;
        log.info("Clustering started; cache migration complete");
    }

    public static synchronized void leftCluster() {
        clusteringStarted = false;
        cacheFactoryStrategy = localCacheFactoryStrategy;
        for (Cache cache : CacheFactory.getAllCaches()) {
            if (localOnly.contains(cache.getName())) continue;
            CacheWrapper cacheWrapper = (CacheWrapper)cache;
            Cache standaloneCache = cacheFactoryStrategy.createCache(cacheWrapper.getName());
            standaloneCache.putAll(cache);
            cacheWrapper.setWrappedCache(standaloneCache);
        }
        log.info("Clustering stopped; cache migration complete");
    }

    static {
        cacheFactoryStrategy = new DefaultLocalCacheStrategy();
        cacheNames = new HashMap<String, String>();
        cacheProps = new HashMap<String, Long>();
        localCacheFactoryClass = JiveGlobals.getProperty(LOCAL_CACHE_PROPERTY_NAME, "org.jivesoftware.util.cache.DefaultLocalCacheStrategy");
        clusteredCacheFactoryClass = JiveGlobals.getProperty(CLUSTERED_CACHE_PROPERTY_NAME, "org.jivesoftware.openfire.plugin.util.cache.ClusteredCacheFactory");
        cacheNames.put("Favicon Hits", "faviconHits");
        cacheNames.put("Favicon Misses", "faviconMisses");
        cacheNames.put("Group", "group");
        cacheNames.put("Group Metadata Cache", "groupMeta");
        cacheNames.put("Javascript Cache", "javascript");
        cacheNames.put("Last Activity Cache", "lastActivity");
        cacheNames.put("Multicast Service", "multicast");
        cacheNames.put("Offline Message Size", "offlinemessage");
        cacheNames.put("Offline Presence Cache", "offlinePresence");
        cacheNames.put("Privacy Lists", "listsCache");
        cacheNames.put("Remote Users Existence", "remoteUsersCache");
        cacheNames.put("Roster", "username2roster");
        cacheNames.put("User", "userCache");
        cacheNames.put("Locked Out Accounts", "lockOutCache");
        cacheNames.put("VCard", "vcardCache");
        cacheNames.put("File Transfer Cache", "fileTransfer");
        cacheNames.put("File Transfer", "transferProxy");
        cacheNames.put("POP3 Authentication", "pop3");
        cacheNames.put("LDAP Authentication", "ldap");
        cacheNames.put("Routing Servers Cache", "routeServer");
        cacheNames.put("Routing Components Cache", "routeComponent");
        cacheNames.put("Routing Users Cache", "routeUser");
        cacheNames.put("Routing AnonymousUsers Cache", "routeAnonymousUser");
        cacheNames.put("Routing User Sessions", "routeUserSessions");
        cacheNames.put("Components Sessions", "componentsSessions");
        cacheNames.put("Connection Managers Sessions", "connManagerSessions");
        cacheNames.put("Incoming Server Sessions", "incServerSessions");
        cacheNames.put("Sessions by Hostname", "sessionsHostname");
        cacheNames.put("Secret Keys Cache", "secretKeys");
        cacheNames.put("Validated Domains", "validatedDomains");
        cacheNames.put("Directed Presences", "directedPresences");
        cacheNames.put("Disco Server Features", "serverFeatures");
        cacheNames.put("Disco Server Items", "serverItems");
        cacheNames.put("Remote Server Configurations", "serversConfigurations");
        cacheNames.put("Entity Capabilities", "entityCapabilities");
        cacheNames.put("Entity Capabilities Users", "entityCapabilitiesUsers");
        cacheNames.put("PEPServiceManager", "pepServiceManager");
        cacheNames.put("Published Items", "publishedItems");
        cacheProps.put("cache.fileTransfer.size", 131072L);
        cacheProps.put("cache.fileTransfer.maxLifetime", 600000L);
        cacheProps.put("cache.multicast.size", 131072L);
        cacheProps.put("cache.multicast.maxLifetime", 86400000L);
        cacheProps.put("cache.offlinemessage.size", 102400L);
        cacheProps.put("cache.offlinemessage.maxLifetime", 43200000L);
        cacheProps.put("cache.pop3.size", 524288L);
        cacheProps.put("cache.pop3.maxLifetime", 3600000L);
        cacheProps.put("cache.transferProxy.size", -1L);
        cacheProps.put("cache.transferProxy.maxLifetime", 600000L);
        cacheProps.put("cache.group.size", 0x100000L);
        cacheProps.put("cache.group.maxLifetime", 900000L);
        cacheProps.put("cache.lockOutCache.size", 0x100000L);
        cacheProps.put("cache.lockOutCache.maxLifetime", 900000L);
        cacheProps.put("cache.groupMeta.size", 524288L);
        cacheProps.put("cache.groupMeta.maxLifetime", 900000L);
        cacheProps.put("cache.username2roster.size", 0x100000L);
        cacheProps.put("cache.username2roster.maxLifetime", 1800000L);
        cacheProps.put("cache.javascript.size", 131072L);
        cacheProps.put("cache.javascript.maxLifetime", 864000L);
        cacheProps.put("cache.ldap.size", 524288L);
        cacheProps.put("cache.ldap.maxLifetime", 0x6DDD00L);
        cacheProps.put("cache.listsCache.size", 524288L);
        cacheProps.put("cache.offlinePresence.size", 524288L);
        cacheProps.put("cache.lastActivity.size", 131072L);
        cacheProps.put("cache.userCache.size", 524288L);
        cacheProps.put("cache.userCache.maxLifetime", 1800000L);
        cacheProps.put("cache.remoteUsersCache.size", 524288L);
        cacheProps.put("cache.remoteUsersCache.maxLifetime", 1800000L);
        cacheProps.put("cache.vcardCache.size", 524288L);
        cacheProps.put("cache.faviconHits.size", 131072L);
        cacheProps.put("cache.faviconMisses.size", 131072L);
        cacheProps.put("cache.routeServer.size", -1L);
        cacheProps.put("cache.routeServer.maxLifetime", -1L);
        cacheProps.put("cache.routeComponent.size", -1L);
        cacheProps.put("cache.routeComponent.maxLifetime", -1L);
        cacheProps.put("cache.routeUser.size", -1L);
        cacheProps.put("cache.routeUser.maxLifetime", -1L);
        cacheProps.put("cache.routeAnonymousUser.size", -1L);
        cacheProps.put("cache.routeAnonymousUser.maxLifetime", -1L);
        cacheProps.put("cache.routeUserSessions.size", -1L);
        cacheProps.put("cache.routeUserSessions.maxLifetime", -1L);
        cacheProps.put("cache.componentsSessions.size", -1L);
        cacheProps.put("cache.componentsSessions.maxLifetime", -1L);
        cacheProps.put("cache.connManagerSessions.size", -1L);
        cacheProps.put("cache.connManagerSessions.maxLifetime", -1L);
        cacheProps.put("cache.incServerSessions.size", -1L);
        cacheProps.put("cache.incServerSessions.maxLifetime", -1L);
        cacheProps.put("cache.sessionsHostname.size", -1L);
        cacheProps.put("cache.sessionsHostname.maxLifetime", -1L);
        cacheProps.put("cache.secretKeys.size", -1L);
        cacheProps.put("cache.secretKeys.maxLifetime", -1L);
        cacheProps.put("cache.validatedDomains.size", -1L);
        cacheProps.put("cache.validatedDomains.maxLifetime", -1L);
        cacheProps.put("cache.directedPresences.size", -1L);
        cacheProps.put("cache.directedPresences.maxLifetime", -1L);
        cacheProps.put("cache.serverFeatures.size", -1L);
        cacheProps.put("cache.serverFeatures.maxLifetime", -1L);
        cacheProps.put("cache.serverItems.size", -1L);
        cacheProps.put("cache.serverItems.maxLifetime", -1L);
        cacheProps.put("cache.serversConfigurations.size", 131072L);
        cacheProps.put("cache.serversConfigurations.maxLifetime", 1800000L);
        cacheProps.put("cache.entityCapabilities.size", -1L);
        cacheProps.put("cache.entityCapabilities.maxLifetime", 172800000L);
        cacheProps.put("cache.entityCapabilitiesUsers.size", -1L);
        cacheProps.put("cache.entityCapabilitiesUsers.maxLifetime", 172800000L);
        cacheProps.put("cache.pluginCacheInfo.size", -1L);
        cacheProps.put("cache.pluginCacheInfo.maxLifetime", -1L);
        cacheProps.put("cache.pepServiceManager.size", 0xA00000L);
        cacheProps.put("cache.pepServiceManager.maxLifetime", 1800000L);
        cacheProps.put("cache.publishedItems.size", 0xA00000L);
        cacheProps.put("cache.publishedItems.maxLifetime", 900000L);
        PropertyEventDispatcher.addListener(new PropertyEventListener(){

            @Override
            public void propertySet(String property, Map<String, Object> params) {
                Cache cache = CacheFactory.getCacheByProperty(property);
                if (cache == null) {
                    return;
                }
                if (property.endsWith(".size")) {
                    Long size = CacheFactory.getMaxCacheSize(cache.getName());
                    cache.setMaxCacheSize(size < Integer.MAX_VALUE ? size.intValue() : Integer.MAX_VALUE);
                }
                if (property.endsWith(".maxLifeTime")) {
                    Long lifetime = CacheFactory.getMaxCacheLifetime(cache.getName());
                    cache.setMaxLifetime(lifetime);
                }
            }

            @Override
            public void propertyDeleted(String property, Map<String, Object> params) {
                this.propertySet(property, params);
            }

            @Override
            public void xmlPropertySet(String property, Map<String, Object> params) {
                this.propertySet(property, params);
            }

            @Override
            public void xmlPropertyDeleted(String property, Map<String, Object> params) {
                this.propertySet(property, params);
            }
        });
    }
}

