/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLProperties {
    private static final Logger Log = LoggerFactory.getLogger(XMLProperties.class);
    private static final String ENCRYPTED_ATTRIBUTE = "encrypted";
    private Path file;
    private Document document;
    private Map<String, String> propertyCache = new HashMap<String, String>();

    public XMLProperties() throws IOException {
        this.buildDoc(new StringReader("<root />"));
    }

    public XMLProperties(String fileName) throws IOException {
        this(Paths.get(fileName, new String[0]));
    }

    public XMLProperties(InputStream in) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            this.buildDoc(reader);
        }
    }

    @Deprecated
    public XMLProperties(File file) throws IOException {
        this(file.toPath());
    }

    public XMLProperties(Path file) throws IOException {
        this.file = file;
        if (Files.notExists(file, new LinkOption[0])) {
            Path tempFile = file.getParent().resolve(file.getFileName() + ".tmp");
            if (Files.exists(tempFile, new LinkOption[0])) {
                Log.error("WARNING: " + file.getFileName() + " was not found, but temp file from previous write operation was. Attempting automatic recovery. Please check file for data consistency.");
                Files.move(tempFile, file, StandardCopyOption.REPLACE_EXISTING);
            } else {
                throw new NoSuchFileException("XML properties file does not exist: " + file.getFileName());
            }
        }
        if (!Files.isReadable(file)) {
            throw new IOException("XML properties file must be readable: " + file.getFileName());
        }
        if (!Files.isWritable(file)) {
            throw new IOException("XML properties file must be writable: " + file.getFileName());
        }
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            this.buildDoc(reader);
        }
    }

    public synchronized String getProperty(String name) {
        return this.getProperty(name, true);
    }

    public synchronized String getProperty(String name, boolean ignoreEmpty) {
        String value = this.propertyCache.get(name);
        if (value != null) {
            return value;
        }
        String[] propName = this.parsePropertyName(name);
        Element element = this.document.getRootElement();
        for (String aPropName : propName) {
            if ((element = element.element(aPropName)) != null) continue;
            return null;
        }
        value = element.getTextTrim();
        if (ignoreEmpty && "".equals(value)) {
            return null;
        }
        if (JiveGlobals.isXMLPropertyEncrypted(name)) {
            Attribute encrypted = element.attribute(ENCRYPTED_ATTRIBUTE);
            if (encrypted != null) {
                value = JiveGlobals.getPropertyEncryptor().decrypt(value);
            } else {
                Log.info("Rewriting XML property " + name + " as an encrypted value");
                this.setProperty(name, value);
            }
        }
        this.propertyCache.put(name, value);
        return value;
    }

    public List<String> getProperties(String name, boolean asList) {
        ArrayList<String> result = new ArrayList<String>();
        String[] propName = this.parsePropertyName(name);
        Element element = this.document.getRootElement();
        for (int i = 0; i < propName.length - 1; ++i) {
            if ((element = element.element(propName[i])) != null) continue;
            return result;
        }
        Iterator iter = element.elementIterator(propName[propName.length - 1]);
        boolean updateEncryption = false;
        while (iter.hasNext()) {
            Element prop = (Element)iter.next();
            String value = prop.getTextTrim();
            if ("".equals(value)) continue;
            if (JiveGlobals.isXMLPropertyEncrypted(name)) {
                Attribute encrypted = prop.attribute(ENCRYPTED_ATTRIBUTE);
                if (encrypted != null) {
                    value = JiveGlobals.getPropertyEncryptor().decrypt(value);
                } else {
                    prop.addAttribute(ENCRYPTED_ATTRIBUTE, "true");
                    updateEncryption = true;
                }
            }
            result.add(value);
        }
        if (updateEncryption) {
            Log.info("Rewriting values for XML property " + name + " using encryption");
            this.saveProperties();
        }
        return result;
    }

    public String[] getProperties(String name) {
        return (String[])this.getProperties(name, false).toArray();
    }

    public Iterator getChildProperties(String name) {
        String[] propName = this.parsePropertyName(name);
        Element element = this.document.getRootElement();
        for (int i = 0; i < propName.length - 1; ++i) {
            if ((element = element.element(propName[i])) != null) continue;
            return Collections.EMPTY_LIST.iterator();
        }
        Iterator iter = element.elementIterator(propName[propName.length - 1]);
        ArrayList<String> props = new ArrayList<String>();
        while (iter.hasNext()) {
            Element prop = (Element)iter.next();
            String value = prop.getText();
            if (JiveGlobals.isPropertyEncrypted(name) && Boolean.parseBoolean(prop.attribute(ENCRYPTED_ATTRIBUTE).getText())) {
                value = JiveGlobals.getPropertyEncryptor().decrypt(value);
            }
            props.add(value);
        }
        return props.iterator();
    }

    public String getAttribute(String name, String attribute) {
        String child;
        if (name == null || attribute == null) {
            return null;
        }
        String[] propName = this.parsePropertyName(name);
        Element element = this.document.getRootElement();
        String[] stringArray = propName;
        int n = stringArray.length;
        for (int i = 0; i < n && (element = element.element(child = stringArray[i])) != null; ++i) {
        }
        if (element != null) {
            return element.attributeValue(attribute);
        }
        return null;
    }

    public String removeAttribute(String name, String attribute) {
        String child;
        if (name == null || attribute == null) {
            return null;
        }
        String[] propName = this.parsePropertyName(name);
        Element element = this.document.getRootElement();
        String[] stringArray = propName;
        int n = stringArray.length;
        for (int i = 0; i < n && (element = element.element(child = stringArray[i])) != null; ++i) {
        }
        String result = null;
        if (element != null) {
            Attribute attr = element.attribute(attribute);
            result = attr.getValue();
            element.remove(attr);
        }
        return result;
    }

    public void setProperties(String name, List<String> values) {
        String[] propName = this.parsePropertyName(name);
        Element element = this.document.getRootElement();
        for (int i = 0; i < propName.length - 1; ++i) {
            if (element.element(propName[i]) == null) {
                element.addElement(propName[i]);
            }
            element = element.element(propName[i]);
        }
        String childName = propName[propName.length - 1];
        ArrayList toRemove = new ArrayList();
        Iterator iter = element.elementIterator(childName);
        while (iter.hasNext()) {
            toRemove.add(iter.next());
        }
        iter = toRemove.iterator();
        while (iter.hasNext()) {
            element.remove((Element)iter.next());
        }
        for (String value : values) {
            Element childElement = element.addElement(childName);
            if (value.startsWith("<![CDATA[")) {
                Iterator it = childElement.nodeIterator();
                while (it.hasNext()) {
                    Node node = (Node)it.next();
                    if (!(node instanceof CDATA)) continue;
                    childElement.remove(node);
                    break;
                }
                childElement.addCDATA(value.substring(9, value.length() - 3));
                continue;
            }
            String propValue = StringEscapeUtils.escapeXml((String)value);
            if (JiveGlobals.isPropertyEncrypted(name)) {
                propValue = JiveGlobals.getPropertyEncryptor().encrypt(value);
                childElement.addAttribute(ENCRYPTED_ATTRIBUTE, "true");
            }
            childElement.setText(propValue);
        }
        this.saveProperties();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("value", values);
        PropertyEventDispatcher.dispatchEvent(name, PropertyEventDispatcher.EventType.xml_property_set, params);
    }

    public boolean addToList(String propertyName, String value) {
        List<String> properties = this.getProperties(propertyName, true);
        boolean propertyWasAdded = properties.add(value);
        if (propertyWasAdded) {
            this.setProperties(propertyName, properties);
        }
        return propertyWasAdded;
    }

    public boolean removeFromList(String propertyName, String value) {
        List<String> properties = this.getProperties(propertyName, true);
        boolean propertyWasRemoved = properties.remove(value);
        if (propertyWasRemoved) {
            this.setProperties(propertyName, properties);
        }
        return propertyWasRemoved;
    }

    public List<String> getAllPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (String propertyName : this.getChildPropertyNamesFor(this.document.getRootElement(), "")) {
            if (this.getProperty(propertyName) == null) continue;
            result.add(propertyName);
        }
        return result;
    }

    private List<String> getChildPropertyNamesFor(Element parent, String parentName) {
        ArrayList<String> result = new ArrayList<String>();
        for (Element child : parent.elements()) {
            String childName = parentName + (parentName.isEmpty() ? "" : ".") + child.getName();
            if (result.contains(childName)) continue;
            result.add(childName);
            result.addAll(this.getChildPropertyNamesFor(child, childName));
        }
        return result;
    }

    public String[] getChildrenProperties(String parent) {
        String[] propName = this.parsePropertyName(parent);
        Element element = this.document.getRootElement();
        for (String aPropName : propName) {
            if ((element = element.element(aPropName)) != null) continue;
            return new String[0];
        }
        List children = element.elements();
        int childCount = children.size();
        String[] childrenNames = new String[childCount];
        for (int i = 0; i < childCount; ++i) {
            childrenNames[i] = ((Element)children.get(i)).getName();
        }
        return childrenNames;
    }

    public synchronized void setProperty(String name, String value) {
        if (!StringEscapeUtils.escapeXml((String)name).equals(name)) {
            throw new IllegalArgumentException("Property name cannot contain XML entities.");
        }
        if (name == null) {
            return;
        }
        if (value == null) {
            value = "";
        }
        this.propertyCache.put(name, value);
        String[] propName = this.parsePropertyName(name);
        Element element = this.document.getRootElement();
        for (String aPropName : propName) {
            if (element.element(aPropName) == null) {
                element.addElement(aPropName);
            }
            element = element.element(aPropName);
        }
        if (value.startsWith("<![CDATA[")) {
            Iterator it = element.nodeIterator();
            while (it.hasNext()) {
                Node node = (Node)it.next();
                if (!(node instanceof CDATA)) continue;
                element.remove(node);
                break;
            }
            element.addCDATA(value.substring(9, value.length() - 3));
        } else {
            String propValue = StringEscapeUtils.escapeXml((String)value);
            if (JiveGlobals.isXMLPropertyEncrypted(name)) {
                propValue = JiveGlobals.getPropertyEncryptor().encrypt(value);
                element.addAttribute(ENCRYPTED_ATTRIBUTE, "true");
            }
            element.setText(propValue);
        }
        this.saveProperties();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("value", value);
        PropertyEventDispatcher.dispatchEvent(name, PropertyEventDispatcher.EventType.xml_property_set, params);
    }

    public synchronized void deleteProperty(String name) {
        this.propertyCache.remove(name);
        String[] propName = this.parsePropertyName(name);
        Element element = this.document.getRootElement();
        for (int i = 0; i < propName.length - 1; ++i) {
            if ((element = element.element(propName[i])) != null) continue;
            return;
        }
        element.remove(element.element(propName[propName.length - 1]));
        if (element.elements().size() == 0) {
            element.getParent().remove(element);
        }
        this.saveProperties();
        JiveGlobals.setPropertyEncrypted(name, false);
        Map<String, Object> params = Collections.emptyMap();
        PropertyEventDispatcher.dispatchEvent(name, PropertyEventDispatcher.EventType.xml_property_deleted, params);
    }

    public void migrateProperty(String name) {
        if (this.getProperty(name) != null) {
            if (JiveGlobals.getProperty(name) == null) {
                Log.debug("JiveGlobals: Migrating XML property '" + name + "' into database.");
                JiveGlobals.setProperty(name, this.getProperty(name));
                this.deleteProperty(name);
            } else if (JiveGlobals.getProperty(name).equals(this.getProperty(name))) {
                Log.debug("JiveGlobals: Deleting duplicate XML property '" + name + "' that is already in database.");
                this.deleteProperty(name);
            } else if (!JiveGlobals.getProperty(name).equals(this.getProperty(name))) {
                Log.warn("XML Property '" + name + "' differs from what is stored in the database.  Please make property changes in the database instead of the configuration file.");
            }
        }
    }

    private void buildDoc(Reader in) throws IOException {
        try {
            SAXReader xmlReader = new SAXReader();
            xmlReader.setEncoding("UTF-8");
            this.document = xmlReader.read(in);
        }
        catch (Exception e) {
            Log.error("Error reading XML properties", (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    private synchronized void saveProperties() {
        if (this.file == null) {
            Log.error("Unable to save XML properties; no file specified");
            return;
        }
        boolean error = false;
        Path tempFile = this.file.getParent().resolve(this.file.getFileName() + ".tmp");
        try (BufferedWriter writer = Files.newBufferedWriter(tempFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            OutputFormat prettyPrinter = OutputFormat.createPrettyPrint();
            XMLWriter xmlWriter = new XMLWriter(writer, prettyPrinter);
            xmlWriter.write(this.document);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
            error = true;
        }
        if (!error) {
            try {
                Files.deleteIfExists(this.file);
            }
            catch (IOException e) {
                Log.error("Error deleting property file: " + this.file);
                return;
            }
            try {
                Files.copy(tempFile, this.file, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
                error = true;
            }
            if (!error) {
                try {
                    Files.deleteIfExists(tempFile);
                }
                catch (IOException e) {
                    Log.error("Error deleting temp file: " + tempFile);
                }
            }
        }
    }

    private String[] parsePropertyName(String name) {
        ArrayList<String> propName = new ArrayList<String>(5);
        StringTokenizer tokenizer = new StringTokenizer(name, ".");
        while (tokenizer.hasMoreTokens()) {
            propName.add(tokenizer.nextToken());
        }
        return propName.toArray(new String[propName.size()]);
    }

    public void setProperties(Map<String, String> propertyMap) {
        for (String propertyName : propertyMap.keySet()) {
            String propertyValue = propertyMap.get(propertyName);
            this.setProperty(propertyName, propertyValue);
        }
    }
}

