/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version> {
    private static final Pattern PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(?:\\s+(\\w+))?(?:\\s+(\\d+))?");
    private final int major;
    private final int minor;
    private final int micro;
    private final int statusVersion;
    private final ReleaseStatus status;
    private String versionString;

    public Version(int major, int minor, int micro, ReleaseStatus status, int statusVersion) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.status = status == null ? ReleaseStatus.Release : status;
        this.statusVersion = statusVersion;
    }

    public Version(CharSequence source) {
        if (source != null) {
            Matcher matcher = PATTERN.matcher(source);
            if (matcher.matches()) {
                String statusVersion;
                this.major = Integer.parseInt(matcher.group(1));
                this.minor = Integer.parseInt(matcher.group(2));
                this.micro = Integer.parseInt(matcher.group(3));
                String status = matcher.group(4);
                if (status != null) {
                    switch (status.toLowerCase()) {
                        case "rc": {
                            this.status = ReleaseStatus.Release_Candidate;
                            break;
                        }
                        case "beta": {
                            this.status = ReleaseStatus.Beta;
                            break;
                        }
                        case "alpha": {
                            this.status = ReleaseStatus.Alpha;
                            break;
                        }
                        default: {
                            this.status = ReleaseStatus.Release;
                            break;
                        }
                    }
                } else {
                    this.status = ReleaseStatus.Release;
                }
                this.statusVersion = (statusVersion = matcher.group(5)) != null ? Integer.parseInt(statusVersion) : -1;
            } else {
                this.micro = 0;
                this.minor = 0;
                this.major = 0;
                this.statusVersion = -1;
                this.status = ReleaseStatus.Release;
            }
        } else {
            this.micro = 0;
            this.minor = 0;
            this.major = 0;
            this.statusVersion = -1;
            this.status = ReleaseStatus.Release;
        }
    }

    public String getVersionString() {
        if (this.versionString == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.major).append('.').append(this.minor).append('.').append(this.micro);
            if (this.status != ReleaseStatus.Release || this.statusVersion != -1) {
                sb.append(' ').append((Object)this.status);
                if (this.statusVersion >= 0) {
                    sb.append(' ').append(this.statusVersion);
                }
            }
            this.versionString = sb.toString();
        }
        return this.versionString;
    }

    public ReleaseStatus getStatus() {
        return this.status;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public int getStatusVersion() {
        return this.statusVersion;
    }

    public boolean isNewerThan(Version otherVersion) {
        return this.compareTo(otherVersion) > 0;
    }

    @Override
    public int compareTo(Version that) {
        if (that == null) {
            return 1;
        }
        int result = Integer.compare(this.getMajor(), that.getMajor());
        if (result == 0 && (result = Integer.compare(this.getMinor(), that.getMinor())) == 0 && (result = Integer.compare(this.getMicro(), that.getMicro())) == 0 && (result = that.getStatus().compareTo(this.getStatus())) == 0) {
            result = Integer.compare(this.getStatusVersion(), that.getStatusVersion());
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version other = (Version)o;
        return Objects.equals(this.major, other.major) && Objects.equals(this.minor, other.minor) && Objects.equals(this.micro, other.micro) && Objects.equals(this.statusVersion, other.statusVersion) && Objects.equals((Object)this.status, (Object)other.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.major, this.minor, this.micro, this.statusVersion, this.status});
    }

    public String toString() {
        return this.getVersionString();
    }

    public static enum ReleaseStatus {
        Release("Release"),
        Release_Candidate("RC"),
        Beta("Beta"),
        Alpha("Alpha");

        private String status;

        private ReleaseStatus(String status) {
            this.status = status;
        }

        public String toString() {
            return this.status;
        }
    }
}

