/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import com.sun.mail.smtp.SMTPTransport;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.StringUtils;
import org.jivesoftware.util.TaskEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailService {
    private static final Logger Log = LoggerFactory.getLogger(EmailService.class);
    private static final String SSL_FACTORY = "org.jivesoftware.util.SimpleSSLSocketFactory";
    private static EmailService instance = new EmailService();
    private String host = JiveGlobals.getProperty("mail.smtp.host", "localhost");
    private int port = JiveGlobals.getIntProperty("mail.smtp.port", 25);
    private String username = JiveGlobals.getProperty("mail.smtp.username");
    private String password = JiveGlobals.getProperty("mail.smtp.password");
    private boolean sslEnabled = JiveGlobals.getBooleanProperty("mail.smtp.ssl");
    private boolean debugEnabled = JiveGlobals.getBooleanProperty("mail.debug");
    private Session session = null;

    public static EmailService getInstance() {
        return instance;
    }

    private EmailService() {
    }

    public MimeMessage createMimeMessage() {
        if (this.session == null) {
            this.createSession();
        }
        return new MimeMessage(this.session);
    }

    public void sendMessage(MimeMessage message) {
        if (message != null) {
            this.sendMessages(Collections.singletonList(message));
        } else {
            Log.error("Cannot add null email message to queue.");
        }
    }

    public void sendMessages(Collection<MimeMessage> messages) {
        if (messages.size() == 0) {
            return;
        }
        TaskEngine.getInstance().submit(new EmailTask(messages));
    }

    public void sendMessage(String toName, String toEmail, String fromName, String fromEmail, String subject, String textBody, String htmlBody) {
        if (toEmail == null || fromEmail == null || subject == null || textBody == null && htmlBody == null) {
            Log.error("Error sending email: Invalid fields: " + (toEmail == null ? "toEmail " : "") + (fromEmail == null ? "fromEmail " : "") + (subject == null ? "subject " : "") + (textBody == null && htmlBody == null ? "textBody or htmlBody " : ""));
        } else {
            try {
                String encoding = MimeUtility.mimeCharset((String)"UTF-8");
                MimeMessage message = this.createMimeMessage();
                InternetAddress to = toName != null ? new InternetAddress(toEmail, toName, encoding) : new InternetAddress(toEmail, "", encoding);
                InternetAddress from = fromName != null ? new InternetAddress(fromEmail, fromName, encoding) : new InternetAddress(fromEmail, "", encoding);
                SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
                format.setTimeZone(JiveGlobals.getTimeZone());
                message.setHeader("Date", format.format(new Date()));
                message.setHeader("Content-Transfer-Encoding", "8bit");
                message.setRecipient(Message.RecipientType.TO, (Address)to);
                message.setFrom((Address)from);
                message.setSubject(StringUtils.replace(subject, "\n", ""), encoding);
                if (textBody != null && htmlBody != null) {
                    MimeMultipart content = new MimeMultipart("alternative");
                    MimeBodyPart text = new MimeBodyPart();
                    text.setText(textBody, encoding);
                    text.setDisposition("inline");
                    content.addBodyPart((BodyPart)text);
                    MimeBodyPart html = new MimeBodyPart();
                    html.setContent((Object)htmlBody, "text/html; charset=UTF-8");
                    html.setDisposition("inline");
                    html.setHeader("Content-Transfer-Encoding", "8bit");
                    content.addBodyPart((BodyPart)html);
                    message.setContent((Multipart)content);
                    message.setDisposition("inline");
                    this.sendMessage(message);
                } else if (textBody != null) {
                    MimeBodyPart bPart = new MimeBodyPart();
                    bPart.setText(textBody, encoding);
                    bPart.setDisposition("inline");
                    bPart.setHeader("Content-Transfer-Encoding", "8bit");
                    MimeMultipart mPart = new MimeMultipart();
                    mPart.addBodyPart((BodyPart)bPart);
                    message.setContent((Multipart)mPart);
                    message.setDisposition("inline");
                    this.sendMessage(message);
                } else if (htmlBody != null) {
                    MimeBodyPart bPart = new MimeBodyPart();
                    bPart.setContent((Object)htmlBody, "text/html; charset=UTF-8");
                    bPart.setDisposition("inline");
                    bPart.setHeader("Content-Transfer-Encoding", "8bit");
                    MimeMultipart mPart = new MimeMultipart();
                    mPart.addBodyPart((BodyPart)bPart);
                    message.setContent((Multipart)mPart);
                    message.setDisposition("inline");
                    this.sendMessage(message);
                }
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void sendMessagesImmediately(Collection<MimeMessage> messages) throws MessagingException {
        EmailTask task = new EmailTask(messages);
        task.sendMessages();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        JiveGlobals.setProperty("mail.smtp.host", host);
        this.session = null;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (port < 0) {
            throw new IllegalArgumentException("Invalid port value: " + port);
        }
        this.port = port;
        JiveGlobals.setProperty("mail.smtp.port", Integer.toString(port));
        this.session = null;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        if (username == null) {
            JiveGlobals.deleteProperty("mail.smtp.username");
        } else {
            JiveGlobals.setProperty("mail.smtp.username", username);
        }
        this.session = null;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        if (password == null) {
            JiveGlobals.deleteProperty("mail.smtp.password");
        } else {
            JiveGlobals.setProperty("mail.smtp.password", password);
        }
        this.session = null;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
        JiveGlobals.setProperty("mail.debug", Boolean.toString(debugEnabled));
        this.session = null;
    }

    public boolean isSSLEnabled() {
        return this.sslEnabled;
    }

    public void setSSLEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        JiveGlobals.setProperty("mail.smtp.ssl", Boolean.toString(sslEnabled));
        this.session = null;
    }

    private synchronized void createSession() {
        if (this.host == null) {
            throw new IllegalArgumentException("Host cannot be null.");
        }
        Properties mailProps = new Properties();
        mailProps.setProperty("mail.smtp.host", this.host);
        mailProps.setProperty("mail.smtp.port", String.valueOf(this.port));
        mailProps.setProperty("mail.smtp.sendpartial", "true");
        mailProps.setProperty("mail.debug", String.valueOf(this.debugEnabled));
        if (this.sslEnabled) {
            Security.setProperty("ssl.SocketFactory.provider", SSL_FACTORY);
            mailProps.setProperty("mail.smtp.socketFactory.class", SSL_FACTORY);
            mailProps.setProperty("mail.smtp.socketFactory.fallback", "true");
        }
        if (this.username != null) {
            mailProps.put("mail.smtp.auth", "true");
        }
        this.session = Session.getInstance((Properties)mailProps, null);
    }

    private class EmailTask
    implements Runnable {
        private Collection<MimeMessage> messages;

        public EmailTask(Collection<MimeMessage> messages) {
            this.messages = messages;
        }

        @Override
        public void run() {
            try {
                this.sendMessages();
            }
            catch (MessagingException me) {
                Log.error(me.getMessage(), (Throwable)me);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendMessages() throws MessagingException {
            SMTPTransport transport = null;
            try {
                URLName url = new URLName("smtp", EmailService.this.host, EmailService.this.port, "", EmailService.this.username, EmailService.this.password);
                if (EmailService.this.session == null) {
                    EmailService.this.createSession();
                }
                transport = new SMTPTransport(EmailService.this.session, url);
                transport.connect(EmailService.this.host, EmailService.this.port, EmailService.this.username, EmailService.this.password);
                for (MimeMessage message : this.messages) {
                    try {
                        transport.sendMessage((Message)message, message.getRecipients(MimeMessage.RecipientType.TO));
                    }
                    catch (SendFailedException | AddressException ae) {
                        Log.error(ae.getMessage(), ae);
                    }
                }
            }
            finally {
                if (transport != null) {
                    try {
                        transport.close();
                    }
                    catch (MessagingException messagingException) {}
                }
            }
        }
    }
}

