/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.awt.Color;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.jivesoftware.util.ClassUtils;
import org.jivesoftware.util.JiveBeanInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanUtils {
    private static final Logger Log = LoggerFactory.getLogger(BeanUtils.class);
    public static final String DATE_FORMAT = "MM/dd/yyyy";
    private static DateFormat dateFormatter = new SimpleDateFormat("MM/dd/yyyy");

    public static void setProperties(Object bean, Map<String, String> properties) {
        try {
            for (String propName : properties.keySet()) {
                try {
                    PropertyDescriptor descriptor = new PropertyDescriptor(propName, bean.getClass());
                    Class<?> propertyType = descriptor.getPropertyType();
                    Object value = BeanUtils.decode(propertyType, properties.get(propName));
                    descriptor.getWriteMethod().invoke(bean, value);
                }
                catch (IntrospectionException introspectionException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void setProperties(Object bean, HttpServletRequest request) {
        Enumeration propNames = request.getParameterNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            try {
                PropertyDescriptor descriptor = new PropertyDescriptor(propName, bean.getClass());
                Class<?> propertyType = descriptor.getPropertyType();
                Object value = BeanUtils.decode(propertyType, request.getParameter(propName));
                descriptor.getWriteMethod().invoke(bean, value);
            }
            catch (IntrospectionException descriptor) {
            }
            catch (InvocationTargetException descriptor) {
            }
            catch (IllegalAccessException e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static Map<String, String> getProperties(Object bean) {
        HashMap<String, String> properties = new HashMap<String, String>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
            String[] names = new String[descriptors.length];
            for (int i = 0; i < names.length; ++i) {
                String name = descriptors[i].getName();
                Object value = descriptors[i].getReadMethod().invoke(bean, (Object[])null);
                properties.put(name, BeanUtils.encode(value));
            }
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        return properties;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class beanClass) throws IntrospectionException {
        try {
            JiveBeanInfo beanInfo = (JiveBeanInfo)ClassUtils.forName(beanClass.getName() + "BeanInfo").newInstance();
            return beanInfo.getPropertyDescriptors();
        }
        catch (Exception exception) {
            return Introspector.getBeanInfo(beanClass).getPropertyDescriptors();
        }
    }

    private static String encode(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Boolean || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            return value.toString();
        }
        if (value instanceof Date) {
            try {
                return dateFormatter.format((Date)value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value instanceof Color) {
            Color color = (Color)value;
            return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
        }
        if (value instanceof Class) {
            return ((Class)value).getName();
        }
        return null;
    }

    private static Object decode(Class type, String value) throws Exception {
        if (type.getName().equals("java.lang.String")) {
            return value;
        }
        if (type.getName().equals("boolean")) {
            return Boolean.valueOf(value);
        }
        if (type.getName().equals("int")) {
            return Integer.valueOf(value);
        }
        if (type.getName().equals("long")) {
            return Long.valueOf(value);
        }
        if (type.getName().equals("float")) {
            return Float.valueOf(value);
        }
        if (type.getName().equals("double")) {
            return Double.valueOf(value);
        }
        if (type.getName().equals("java.util.Date")) {
            try {
                return dateFormatter.parse(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (type.getName().equals("java.awt.Color")) {
            StringTokenizer tokens = new StringTokenizer(value, ",");
            int red = Integer.parseInt(tokens.nextToken());
            int green = Integer.parseInt(tokens.nextToken());
            int blue = Integer.parseInt(tokens.nextToken());
            return new Color(red, green, blue);
        }
        if (type.getName().equals("java.lang.Class")) {
            return ClassUtils.forName(value);
        }
        return null;
    }

    private BeanUtils() {
    }
}

