/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.websocket;

import java.net.InetSocketAddress;
import org.dom4j.Namespace;
import org.jivesoftware.openfire.PacketDeliverer;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.net.VirtualConnection;
import org.jivesoftware.openfire.nio.OfflinePacketDeliverer;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.openfire.session.LocalSession;
import org.jivesoftware.openfire.spi.ConnectionConfiguration;
import org.jivesoftware.openfire.spi.ConnectionManagerImpl;
import org.jivesoftware.openfire.spi.ConnectionType;
import org.jivesoftware.openfire.websocket.XmppWebSocket;
import org.xmpp.packet.Packet;
import org.xmpp.packet.StreamError;

public class WebSocketConnection
extends VirtualConnection {
    private InetSocketAddress remotePeer;
    private XmppWebSocket socket;
    private PacketDeliverer backupDeliverer;
    private ConnectionConfiguration configuration;
    private ConnectionType connectionType;

    public WebSocketConnection(XmppWebSocket socket, InetSocketAddress remotePeer) {
        this.socket = socket;
        this.remotePeer = remotePeer;
        this.connectionType = ConnectionType.SOCKET_C2S;
    }

    @Override
    public void closeVirtualConnection() {
        this.socket.closeSession();
    }

    @Override
    public byte[] getAddress() {
        return this.remotePeer.getAddress().getAddress();
    }

    @Override
    public String getHostAddress() {
        return this.remotePeer.getAddress().getHostAddress();
    }

    @Override
    public String getHostName() {
        return this.remotePeer.getHostName();
    }

    @Override
    public void systemShutdown() {
        this.deliverRawText(new StreamError(StreamError.Condition.system_shutdown).toXML());
        this.close();
    }

    @Override
    public void deliver(Packet packet) throws UnauthorizedException {
        String xml;
        if (Namespace.NO_NAMESPACE.equals((Object)packet.getElement().getNamespace())) {
            StringBuilder packetXml = new StringBuilder(packet.toXML());
            packetXml.insert(packetXml.indexOf(" "), " xmlns=\"jabber:client\"");
            xml = packetXml.toString();
        } else {
            xml = packet.toXML();
        }
        if (this.validate()) {
            this.deliverRawText(xml);
        } else {
            this.getPacketDeliverer().deliver(packet);
        }
    }

    @Override
    public void deliverRawText(String text) {
        this.socket.deliver(text);
    }

    @Override
    public boolean validate() {
        return this.socket.isWebSocketOpen();
    }

    @Override
    public boolean isSecure() {
        return this.socket.isWebSocketSecure();
    }

    @Override
    public PacketDeliverer getPacketDeliverer() {
        if (this.backupDeliverer == null) {
            this.backupDeliverer = new OfflinePacketDeliverer();
        }
        return this.backupDeliverer;
    }

    @Override
    public ConnectionConfiguration getConfiguration() {
        if (this.configuration == null) {
            ConnectionManagerImpl connectionManager = (ConnectionManagerImpl)XMPPServer.getInstance().getConnectionManager();
            this.configuration = connectionManager.getListener(this.connectionType, true).generateConnectionConfiguration();
        }
        return this.configuration;
    }

    @Override
    public boolean isCompressed() {
        return XmppWebSocket.isCompressionEnabled();
    }

    @Override
    public void reinit(LocalSession session) {
        this.socket.setXmppSession((LocalClientSession)session);
        super.reinit(session);
    }
}

