/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.vcard;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.dom4j.Element;
import org.jivesoftware.openfire.vcard.VCardListener;

public class VCardEventDispatcher {
    private static List<VCardListener> listeners = new CopyOnWriteArrayList<VCardListener>();

    public static void addListener(VCardListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        listeners.add(listener);
    }

    public static void removeListener(VCardListener listener) {
        listeners.remove(listener);
    }

    public static void dispatchVCardUpdated(String user, Element vCard) {
        for (VCardListener listener : listeners) {
            listener.vCardUpdated(user, vCard);
        }
    }

    public static void dispatchVCardCreated(String user, Element vCard) {
        for (VCardListener listener : listeners) {
            listener.vCardCreated(user, vCard);
        }
    }

    public static void dispatchVCardDeleted(String user, Element vCard) {
        for (VCardListener listener : listeners) {
            listener.vCardDeleted(user, vCard);
        }
    }
}

