/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.vcard;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.vcard.PhotoResizer;
import org.jivesoftware.openfire.vcard.VCardProvider;
import org.jivesoftware.util.AlreadyExistsException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultVCardProvider
implements VCardProvider {
    private static final Logger Log = LoggerFactory.getLogger(DefaultVCardProvider.class);
    private static final String LOAD_PROPERTIES = "SELECT vcard FROM ofVCard WHERE username=?";
    private static final String DELETE_PROPERTIES = "DELETE FROM ofVCard WHERE username=?";
    private static final String UPDATE_PROPERTIES = "UPDATE ofVCard SET vcard=? WHERE username=?";
    private static final String INSERT_PROPERTY = "INSERT INTO ofVCard (username, vcard) VALUES (?, ?)";
    private static final int POOL_SIZE = 10;
    private BlockingQueue<SAXReader> xmlReaders = new LinkedBlockingQueue<SAXReader>(10);

    public DefaultVCardProvider() {
        for (int i = 0; i < 10; ++i) {
            SAXReader xmlReader = new SAXReader();
            xmlReader.setEncoding("UTF-8");
            this.xmlReaders.add(xmlReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element loadVCard(String username) {
        String string = username.intern();
        synchronized (string) {
            Element vCardElement;
            ResultSet rs;
            PreparedStatement pstmt;
            Connection con;
            block10: {
                con = null;
                pstmt = null;
                rs = null;
                vCardElement = null;
                SAXReader xmlReader = null;
                try {
                    xmlReader = this.xmlReaders.take();
                    con = DbConnectionManager.getConnection();
                    pstmt = con.prepareStatement(LOAD_PROPERTIES);
                    pstmt.setString(1, username);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        vCardElement = xmlReader.read((Reader)new StringReader(rs.getString(1))).getRootElement();
                    }
                    if (xmlReader == null) break block10;
                    this.xmlReaders.add(xmlReader);
                }
                catch (Exception e) {
                    block11: {
                        try {
                            Log.error("Error loading vCard of username: " + username, (Throwable)e);
                            if (xmlReader == null) break block11;
                            this.xmlReaders.add(xmlReader);
                        }
                        catch (Throwable throwable) {
                            if (xmlReader != null) {
                                this.xmlReaders.add(xmlReader);
                            }
                            DbConnectionManager.closeConnection(rs, pstmt, con);
                            throw throwable;
                        }
                    }
                    DbConnectionManager.closeConnection(rs, pstmt, con);
                }
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
            if (JiveGlobals.getBooleanProperty("avatar.resize.enable-on-load", true)) {
                PhotoResizer.resizeAvatar(vCardElement);
            }
            return vCardElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element createVCard(String username, Element vCardElement) throws AlreadyExistsException {
        if (this.loadVCard(username) != null) {
            throw new AlreadyExistsException("Username " + username + " already has a vCard");
        }
        if (JiveGlobals.getBooleanProperty("avatar.resize.enable-on-create", false)) {
            PhotoResizer.resizeAvatar(vCardElement);
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(INSERT_PROPERTY);
            pstmt.setString(1, username);
            pstmt.setString(2, vCardElement.asXML());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("Error creating vCard for username: " + username, (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
        return vCardElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element updateVCard(String username, Element vCardElement) throws NotFoundException {
        if (this.loadVCard(username) == null) {
            throw new NotFoundException("Username " + username + " does not have a vCard");
        }
        if (JiveGlobals.getBooleanProperty("avatar.resize.enable-on-create", false)) {
            PhotoResizer.resizeAvatar(vCardElement);
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(UPDATE_PROPERTIES);
            pstmt.setString(1, vCardElement.asXML());
            pstmt.setString(2, username);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("Error updating vCard of username: " + username, (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
        return vCardElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteVCard(String username) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_PROPERTIES);
            pstmt.setString(1, username);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("Error deleting vCard of username: " + username, (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }
}

