/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.user.property;

import java.util.Map;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.openfire.user.property.UserPropertyProvider;
import org.jivesoftware.openfire.user.property.UserPropertyProviderMapper;
import org.jivesoftware.util.ClassUtils;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedUserPropertyProvider
implements UserPropertyProvider {
    public static final String PROPERTY_MAPPER_CLASSNAME = "mappedUserPropertyProvider.mapper.className";
    private static final Logger Log = LoggerFactory.getLogger(MappedUserPropertyProvider.class);
    protected final UserPropertyProviderMapper mapper;

    public MappedUserPropertyProvider() {
        JiveGlobals.migrateProperty(PROPERTY_MAPPER_CLASSNAME);
        String mapperClass = JiveGlobals.getProperty(PROPERTY_MAPPER_CLASSNAME);
        if (mapperClass == null) {
            throw new IllegalStateException("A mapper must be specified via openfire.xml or the system properties.");
        }
        try {
            Class c = ClassUtils.forName(mapperClass);
            this.mapper = (UserPropertyProviderMapper)c.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create new instance of UserPropertyProviderMapper class: " + mapperClass, e);
        }
    }

    public static UserPropertyProvider instantiate(String propertyName) {
        String className = JiveGlobals.getProperty(propertyName);
        if (className == null) {
            Log.debug("Property '{}' is undefined. Skipping.", (Object)propertyName);
            return null;
        }
        Log.debug("About to to instantiate an UserPropertyProvider '{}' based on the value of property '{}'.", (Object)className, (Object)propertyName);
        try {
            Class c = ClassUtils.forName(className);
            UserPropertyProvider provider = (UserPropertyProvider)c.newInstance();
            Log.debug("Instantiated UserPropertyProvider '{}'", (Object)className);
            return provider;
        }
        catch (Exception e) {
            Log.error("Unable to load UserPropertyProvider '{}'. Users in this provider will be disabled.", (Object)className, (Object)e);
            return null;
        }
    }

    @Override
    public Map<String, String> loadProperties(String username) throws UserNotFoundException {
        return this.mapper.getUserPropertyProvider(username).loadProperties(username);
    }

    @Override
    public String loadProperty(String username, String propName) throws UserNotFoundException {
        return this.mapper.getUserPropertyProvider(username).loadProperty(username, propName);
    }

    @Override
    public void insertProperty(String username, String propName, String propValue) throws UserNotFoundException {
        this.mapper.getUserPropertyProvider(username).insertProperty(username, propName, propValue);
    }

    @Override
    public void updateProperty(String username, String propName, String propValue) throws UserNotFoundException {
        this.mapper.getUserPropertyProvider(username).updateProperty(username, propName, propValue);
    }

    @Override
    public void deleteProperty(String username, String propName) throws UserNotFoundException {
        this.mapper.getUserPropertyProvider(username).deleteProperty(username, propName);
    }

    @Override
    public boolean isReadOnly() {
        for (UserPropertyProvider provider : this.mapper.getUserPropertyProviders()) {
            if (provider.isReadOnly()) continue;
            return false;
        }
        return true;
    }
}

