/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.user.property;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.openfire.user.property.MappedUserPropertyProvider;
import org.jivesoftware.openfire.user.property.UserPropertyProvider;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HybridUserPropertyProvider
implements UserPropertyProvider {
    private static final Logger Log = LoggerFactory.getLogger(HybridUserPropertyProvider.class);
    private final List<UserPropertyProvider> providers = new ArrayList<UserPropertyProvider>();

    public HybridUserPropertyProvider() {
        UserPropertyProvider tertiary;
        UserPropertyProvider secondary;
        JiveGlobals.migrateProperty("hybridUserPropertyProvider.primaryProvider.className");
        JiveGlobals.migrateProperty("hybridUserPropertyProvider.secondaryProvider.className");
        JiveGlobals.migrateProperty("hybridUserPropertyProvider.tertiaryProvider.className");
        UserPropertyProvider primary = MappedUserPropertyProvider.instantiate("hybridUserPropertyProvider.primaryProvider.className");
        if (primary != null) {
            this.providers.add(primary);
        }
        if ((secondary = MappedUserPropertyProvider.instantiate("hybridUserPropertyProvider.secondaryProvider.className")) != null) {
            this.providers.add(secondary);
        }
        if ((tertiary = MappedUserPropertyProvider.instantiate("hybridUserPropertyProvider.tertiaryProvider.className")) != null) {
            this.providers.add(tertiary);
        }
        if (this.providers.isEmpty()) {
            Log.error("At least one UserPropertyProvider must be specified via openfire.xml or the system properties!");
        }
    }

    @Override
    public Map<String, String> loadProperties(String username) {
        for (UserPropertyProvider provider : this.providers) {
            try {
                Map<String, String> properties = provider.loadProperties(username);
                if (properties.isEmpty()) continue;
                return properties;
            }
            catch (UserNotFoundException userNotFoundException) {
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public String loadProperty(String username, String propName) {
        for (UserPropertyProvider provider : this.providers) {
            try {
                String property = provider.loadProperty(username, propName);
                if (property == null) continue;
                return property;
            }
            catch (UserNotFoundException userNotFoundException) {
            }
        }
        return null;
    }

    @Override
    public void insertProperty(String username, String propName, String propValue) throws UnsupportedOperationException {
        this.updateProperty(username, propName, propValue);
    }

    @Override
    public void updateProperty(String username, String propName, String propValue) throws UnsupportedOperationException {
        for (UserPropertyProvider provider : this.providers) {
            try {
                if (provider.loadProperty(username, propName) == null) continue;
                provider.updateProperty(username, propName, propValue);
                return;
            }
            catch (UserNotFoundException userNotFoundException) {
            }
        }
        for (UserPropertyProvider provider : this.providers) {
            try {
                if (provider.isReadOnly()) continue;
                provider.insertProperty(username, propName, propValue);
                return;
            }
            catch (UserNotFoundException userNotFoundException) {
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteProperty(String username, String propName) throws UnsupportedOperationException {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException();
        }
        for (UserPropertyProvider provider : this.providers) {
            if (provider.isReadOnly()) continue;
            try {
                provider.deleteProperty(username, propName);
            }
            catch (UserNotFoundException userNotFoundException) {}
        }
    }

    @Override
    public boolean isReadOnly() {
        for (UserPropertyProvider provider : this.providers) {
            if (provider.isReadOnly()) continue;
            return false;
        }
        return true;
    }
}

