/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.user;

import gnu.inet.encoding.Stringprep;
import gnu.inet.encoding.StringprepException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.event.UserEventDispatcher;
import org.jivesoftware.openfire.event.UserEventListener;
import org.jivesoftware.openfire.user.DefaultUserProvider;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.openfire.user.UserProvider;
import org.jivesoftware.openfire.user.property.DefaultUserPropertyProvider;
import org.jivesoftware.openfire.user.property.UserPropertyProvider;
import org.jivesoftware.util.ClassUtils;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.jivesoftware.util.StringUtils;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.component.IQResultListener;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

public class UserManager
implements IQResultListener {
    private static final Logger Log = LoggerFactory.getLogger(UserManager.class);
    private Cache<String, User> userCache = CacheFactory.createCache("User");
    private Cache<String, Boolean> remoteUsersCache = CacheFactory.createCache("Remote Users Existence");
    private UserProvider provider;
    private UserPropertyProvider propertyProvider;

    public static UserProvider getUserProvider() {
        return UserManagerContainer.instance.provider;
    }

    public static UserPropertyProvider getUserPropertyProvider() {
        return UserManagerContainer.instance.propertyProvider;
    }

    public static UserManager getInstance() {
        return UserManagerContainer.instance;
    }

    private UserManager() {
        this.initProvider();
        this.initPropertyProvider();
        PropertyEventListener propListener = new PropertyEventListener(){

            public void propertySet(String property, Map params) {
                if ("provider.user.className".equals(property)) {
                    UserManager.this.initProvider();
                }
                if ("provider.userproperty.className".equals(property)) {
                    UserManager.this.initPropertyProvider();
                }
            }

            public void propertyDeleted(String property, Map params) {
                if ("provider.user.className".equals(property)) {
                    UserManager.this.initProvider();
                }
                if ("provider.userproperty.className".equals(property)) {
                    UserManager.this.initPropertyProvider();
                }
            }

            public void xmlPropertySet(String property, Map params) {
            }

            public void xmlPropertyDeleted(String property, Map params) {
            }
        };
        PropertyEventDispatcher.addListener(propListener);
        UserEventListener userListener = new UserEventListener(){

            @Override
            public void userCreated(User user, Map<String, Object> params) {
                UserManager.this.userCache.put(user.getUsername(), user);
            }

            @Override
            public void userDeleting(User user, Map<String, Object> params) {
                UserManager.this.userCache.remove(user.getUsername());
            }

            @Override
            public void userModified(User user, Map<String, Object> params) {
                UserManager.this.userCache.put(user.getUsername(), user);
            }
        };
        UserEventDispatcher.addListener(userListener);
    }

    public User createUser(String username, String password, String name, String email) throws UserAlreadyExistsException {
        if (this.provider.isReadOnly()) {
            throw new UnsupportedOperationException("User provider is read-only.");
        }
        if (username == null || username.isEmpty()) {
            throw new IllegalArgumentException("Null or empty username.");
        }
        if (password == null || password.isEmpty()) {
            throw new IllegalArgumentException("Null or empty password.");
        }
        try {
            username = Stringprep.nodeprep((String)username);
        }
        catch (StringprepException se) {
            throw new IllegalArgumentException("Invalid username: " + username, se);
        }
        if (this.provider.isNameRequired() && (name == null || name.matches("\\s*"))) {
            throw new IllegalArgumentException("Invalid or empty name specified with provider that requires name. User: " + username + " Name: " + name);
        }
        if (this.provider.isEmailRequired() && !StringUtils.isValidEmailAddress(email)) {
            throw new IllegalArgumentException("Invalid or empty email address specified with provider that requires email address. User: " + username + " Email: " + email);
        }
        User user = this.provider.createUser(username, password, name, email);
        this.userCache.put(username, user);
        Map<String, Object> params = Collections.emptyMap();
        UserEventDispatcher.dispatchEvent(user, UserEventDispatcher.EventType.user_created, params);
        return user;
    }

    public void deleteUser(User user) {
        if (this.provider.isReadOnly()) {
            throw new UnsupportedOperationException("User provider is read-only.");
        }
        String username = user.getUsername();
        try {
            Stringprep.nodeprep((String)username);
        }
        catch (StringprepException se) {
            throw new IllegalArgumentException("Invalid username: " + username, se);
        }
        Map<String, Object> params = Collections.emptyMap();
        UserEventDispatcher.dispatchEvent(user, UserEventDispatcher.EventType.user_deleting, params);
        this.provider.deleteUser(user.getUsername());
        this.userCache.remove(user.getUsername());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUser(String username) throws UserNotFoundException {
        if (username == null) {
            throw new UserNotFoundException("Username cannot be null");
        }
        User user = (User)this.userCache.get(username = username.trim().toLowerCase());
        if (user == null) {
            String string = username.intern();
            synchronized (string) {
                user = (User)this.userCache.get(username);
                if (user == null) {
                    user = this.provider.loadUser(username);
                    this.userCache.put(username, user);
                }
            }
        }
        return user;
    }

    public int getUserCount() {
        return this.provider.getUserCount();
    }

    public Collection<User> getUsers() {
        return this.provider.getUsers();
    }

    public Collection<String> getUsernames() {
        return this.provider.getUsernames();
    }

    public Collection<User> getUsers(int startIndex, int numResults) {
        return this.provider.getUsers(startIndex, numResults);
    }

    public Set<String> getSearchFields() throws UnsupportedOperationException {
        return this.provider.getSearchFields();
    }

    public Collection<User> findUsers(Set<String> fields, String query) throws UnsupportedOperationException {
        return this.provider.findUsers(fields, query);
    }

    public Collection<User> findUsers(Set<String> fields, String query, int startIndex, int numResults) throws UnsupportedOperationException {
        return this.provider.findUsers(fields, query, startIndex, numResults);
    }

    public boolean isRegisteredUser(String username) {
        if (username == null || "".equals(username)) {
            return false;
        }
        try {
            this.getUser(username);
            return true;
        }
        catch (UserNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegisteredUser(JID user) {
        XMPPServer server = XMPPServer.getInstance();
        if (server.isLocal(user)) {
            try {
                this.getUser(user.getNode());
                return true;
            }
            catch (UserNotFoundException e) {
                return false;
            }
        }
        Boolean isRegistered = (Boolean)this.remoteUsersCache.get(user.toString());
        if (isRegistered == null && (isRegistered = (Boolean)this.remoteUsersCache.get(user.toBareJID())) == null) {
            IQ iq = new IQ(IQ.Type.get);
            iq.setFrom(server.getServerInfo().getXMPPDomain());
            iq.setTo(user.toBareJID());
            iq.setChildElement("query", "http://jabber.org/protocol/disco#info");
            server.getIQRouter().addIQResultListener(iq.getID(), this);
            String string = user.toBareJID().intern();
            synchronized (string) {
                server.getIQRouter().route(iq);
                try {
                    user.toBareJID().intern().wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            isRegistered = (Boolean)this.remoteUsersCache.get(user.toBareJID());
            if (isRegistered == null) {
                isRegistered = Boolean.FALSE;
                this.remoteUsersCache.put(user.toString(), isRegistered);
            }
        }
        return isRegistered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedAnswer(IQ packet) {
        Element child;
        JID from = packet.getFrom();
        Boolean isRegistered = Boolean.FALSE;
        if (IQ.Type.result == packet.getType() && (child = packet.getChildElement()) != null) {
            Iterator it = child.elementIterator("identity");
            while (it.hasNext()) {
                Element identity = (Element)it.next();
                String accountType = identity.attributeValue("type");
                if (!"registered".equals(accountType) && !"admin".equals(accountType)) continue;
                isRegistered = Boolean.TRUE;
                break;
            }
        }
        this.remoteUsersCache.put(from.toBareJID(), isRegistered);
        String string = from.toBareJID().intern();
        synchronized (string) {
            from.toBareJID().intern().notifyAll();
        }
    }

    public void answerTimeout(String packetId) {
        Log.warn("An answer to a previously sent IQ stanza was never received. Packet id: " + packetId);
    }

    private void initProvider() {
        JiveGlobals.migrateProperty("provider.user.className");
        String className = JiveGlobals.getProperty("provider.user.className", "org.jivesoftware.openfire.user.DefaultUserProvider");
        if (this.provider == null || !className.equals(this.provider.getClass().getName())) {
            try {
                Class c = ClassUtils.forName(className);
                this.provider = (UserProvider)c.newInstance();
            }
            catch (Exception e) {
                Log.error("Error loading user provider: " + className, (Throwable)e);
                this.provider = new DefaultUserProvider();
            }
        }
    }

    private void initPropertyProvider() {
        JiveGlobals.migrateProperty("provider.userproperty.className");
        String className = JiveGlobals.getProperty("provider.userproperty.className", "org.jivesoftware.openfire.user.property.DefaultUserPropertyProvider");
        if (this.propertyProvider == null || !className.equals(this.propertyProvider.getClass().getName())) {
            try {
                Class c = ClassUtils.forName(className);
                this.propertyProvider = (UserPropertyProvider)c.newInstance();
            }
            catch (Exception e) {
                Log.error("Error loading user property provider: " + className, (Throwable)e);
                this.propertyProvider = new DefaultUserPropertyProvider();
            }
        }
    }

    private static class UserManagerContainer {
        private static UserManager instance = new UserManager();

        private UserManagerContainer() {
        }
    }
}

