/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.user;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.AuthFactory;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserCollection;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.openfire.user.UserProvider;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class DefaultUserProvider
implements UserProvider {
    private static final Logger Log = LoggerFactory.getLogger(DefaultUserProvider.class);
    private static final String LOAD_USER = "SELECT salt, serverKey, storedKey, iterations, name, email, creationDate, modificationDate FROM ofUser WHERE username=?";
    private static final String USER_COUNT = "SELECT count(*) FROM ofUser";
    private static final String ALL_USERS = "SELECT username FROM ofUser ORDER BY username";
    private static final String INSERT_USER = "INSERT INTO ofUser (username,name,email,creationDate,modificationDate) VALUES (?,?,?,?,?)";
    private static final String DELETE_USER_FLAGS = "DELETE FROM ofUserFlag WHERE username=?";
    private static final String DELETE_USER_PROPS = "DELETE FROM ofUserProp WHERE username=?";
    private static final String DELETE_USER = "DELETE FROM ofUser WHERE username=?";
    private static final String UPDATE_NAME = "UPDATE ofUser SET name=? WHERE username=?";
    private static final String UPDATE_EMAIL = "UPDATE ofUser SET email=? WHERE username=?";
    private static final String UPDATE_CREATION_DATE = "UPDATE ofUser SET creationDate=? WHERE username=?";
    private static final String UPDATE_MODIFICATION_DATE = "UPDATE ofUser SET modificationDate=? WHERE username=?";
    private static final boolean IS_READ_ONLY = false;

    @Override
    public User loadUser(String username) throws UserNotFoundException {
        User user;
        if (username.contains("@")) {
            if (!XMPPServer.getInstance().isLocal(new JID(username))) {
                throw new UserNotFoundException("Cannot load user of remote server: " + username);
            }
            username = username.substring(0, username.lastIndexOf("@"));
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(LOAD_USER);
            pstmt.setString(1, username);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new UserNotFoundException();
            }
            String salt = rs.getString(1);
            String serverKey = rs.getString(2);
            String storedKey = rs.getString(3);
            int iterations = rs.getInt(4);
            String name = rs.getString(5);
            String email = rs.getString(6);
            Date creationDate = new Date(Long.parseLong(rs.getString(7).trim()));
            Date modificationDate = new Date(Long.parseLong(rs.getString(8).trim()));
            User user2 = new User(username, name, email, creationDate, modificationDate);
            user2.setSalt(salt);
            user2.setServerKey(serverKey);
            user2.setStoredKey(storedKey);
            user2.setIterations(iterations);
            user = user2;
        }
        catch (Exception e) {
            try {
                throw new UserNotFoundException(e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, con);
                throw throwable;
            }
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return user;
    }

    @Override
    public User createUser(String username, String password, String name, String email) throws UserAlreadyExistsException {
        try {
            this.loadUser(username);
            throw new UserAlreadyExistsException("Username " + username + " already exists");
        }
        catch (UserNotFoundException unfe) {
            Date now = new Date();
            Connection con = null;
            PreparedStatement pstmt = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(INSERT_USER);
                pstmt.setString(1, username);
                if (name == null || name.matches("\\s*")) {
                    pstmt.setNull(2, 12);
                } else {
                    pstmt.setString(2, name);
                }
                if (email == null || email.matches("\\s*")) {
                    pstmt.setNull(3, 12);
                } else {
                    pstmt.setString(3, email);
                }
                pstmt.setString(4, StringUtils.dateToMillis(now));
                pstmt.setString(5, StringUtils.dateToMillis(now));
                pstmt.execute();
            }
            catch (SQLException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(pstmt, con);
                    throw throwable;
                }
            }
            DbConnectionManager.closeConnection(pstmt, con);
            try {
                AuthFactory.setPassword(username, password);
            }
            catch (Exception e) {
                Log.error("User pasword not set", (Throwable)e);
            }
            return new User(username, name, email, now, now);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteUser(String username) {
        Connection con = null;
        PreparedStatement pstmt = null;
        boolean abortTransaction = false;
        try {
            con = DbConnectionManager.getTransactionConnection();
            pstmt = con.prepareStatement(DELETE_USER_PROPS);
            pstmt.setString(1, username);
            pstmt.execute();
            DbConnectionManager.fastcloseStmt(pstmt);
            pstmt = con.prepareStatement(DELETE_USER_FLAGS);
            pstmt.setString(1, username);
            pstmt.execute();
            DbConnectionManager.fastcloseStmt(pstmt);
            pstmt = con.prepareStatement(DELETE_USER);
            pstmt.setString(1, username);
            pstmt.execute();
        }
        catch (Exception e) {
            try {
                Log.error(e.getMessage(), (Throwable)e);
                abortTransaction = true;
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeStatement(pstmt);
                DbConnectionManager.closeTransactionConnection(pstmt, con, abortTransaction);
                throw throwable;
            }
            DbConnectionManager.closeStatement(pstmt);
            DbConnectionManager.closeTransactionConnection(pstmt, con, abortTransaction);
        }
        DbConnectionManager.closeStatement(pstmt);
        DbConnectionManager.closeTransactionConnection(pstmt, con, abortTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUserCount() {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        int count;
        block4: {
            count = 0;
            con = null;
            pstmt = null;
            rs = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(USER_COUNT);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                count = rs.getInt(1);
            }
            catch (SQLException e) {
                try {
                    Log.error(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, pstmt, con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection(rs, pstmt, con);
            }
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return count;
    }

    @Override
    public Collection<User> getUsers() {
        Collection<String> usernames = this.getUsernames(0, Integer.MAX_VALUE);
        return new UserCollection(usernames.toArray(new String[usernames.size()]));
    }

    @Override
    public Collection<String> getUsernames() {
        return this.getUsernames(0, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> getUsernames(int startIndex, int numResults) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        ArrayList<String> usernames;
        block8: {
            usernames = new ArrayList<String>(500);
            con = null;
            pstmt = null;
            rs = null;
            try {
                con = DbConnectionManager.getConnection();
                if (startIndex == 0 && numResults == Integer.MAX_VALUE) {
                    pstmt = con.prepareStatement(ALL_USERS);
                    DbConnectionManager.setFetchSize(pstmt, 500);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        usernames.add(rs.getString(1));
                    }
                } else {
                    pstmt = DbConnectionManager.createScrollablePreparedStatement(con, ALL_USERS);
                    DbConnectionManager.limitRowsAndFetchSize(pstmt, startIndex, numResults);
                    rs = pstmt.executeQuery();
                    DbConnectionManager.scrollResultSet(rs, startIndex);
                    for (int count = 0; rs.next() && count < numResults; ++count) {
                        usernames.add(rs.getString(1));
                    }
                }
                if (!Log.isDebugEnabled()) break block8;
                Log.debug("Results: " + usernames.size());
                this.LogResults(usernames);
            }
            catch (SQLException e) {
                try {
                    Log.error(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, pstmt, con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection(rs, pstmt, con);
            }
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return usernames;
    }

    @Override
    public Collection<User> getUsers(int startIndex, int numResults) {
        Collection<String> usernames = this.getUsernames(startIndex, numResults);
        return new UserCollection(usernames.toArray(new String[usernames.size()]));
    }

    @Override
    public void setName(String username, String name) throws UserNotFoundException {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(UPDATE_NAME);
            if (name == null || name.matches("\\s*")) {
                pstmt.setNull(1, 12);
            } else {
                pstmt.setString(1, name);
            }
            pstmt.setString(2, username);
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                throw new UserNotFoundException(sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    @Override
    public void setEmail(String username, String email) throws UserNotFoundException {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(UPDATE_EMAIL);
            if (email == null || email.matches("\\s*")) {
                pstmt.setNull(1, 12);
            } else {
                pstmt.setString(1, email);
            }
            pstmt.setString(2, username);
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                throw new UserNotFoundException(sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    @Override
    public void setCreationDate(String username, Date creationDate) throws UserNotFoundException {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(UPDATE_CREATION_DATE);
            pstmt.setString(1, StringUtils.dateToMillis(creationDate));
            pstmt.setString(2, username);
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                throw new UserNotFoundException(sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    @Override
    public void setModificationDate(String username, Date modificationDate) throws UserNotFoundException {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(UPDATE_MODIFICATION_DATE);
            pstmt.setString(1, StringUtils.dateToMillis(modificationDate));
            pstmt.setString(2, username);
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                throw new UserNotFoundException(sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    @Override
    public Set<String> getSearchFields() throws UnsupportedOperationException {
        return new LinkedHashSet<String>(Arrays.asList("Username", "Name", "Email"));
    }

    @Override
    public Collection<User> findUsers(Set<String> fields, String query) throws UnsupportedOperationException {
        return this.findUsers(fields, query, 0, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<User> findUsers(Set<String> fields, String query, int startIndex, int numResults) throws UnsupportedOperationException {
        if (fields.isEmpty()) {
            return Collections.emptyList();
        }
        if (!this.getSearchFields().containsAll(fields)) {
            throw new IllegalArgumentException("Search fields " + fields + " are not valid.");
        }
        if (query == null || "".equals(query)) {
            return Collections.emptyList();
        }
        query = "%" + query.replace('*', '%') + "%";
        if (query.endsWith("%%")) {
            query = query.substring(0, query.length() - 1);
        }
        ArrayList<String> usernames = new ArrayList<String>(50);
        Connection con = null;
        PreparedStatement pstmt = null;
        int queries = 0;
        ResultSet rs = null;
        try {
            StringBuilder sql = new StringBuilder(90);
            sql.append("SELECT username FROM ofUser WHERE");
            boolean first = true;
            if (fields.contains("Username")) {
                sql.append(" username LIKE ?");
                ++queries;
                first = false;
            }
            if (fields.contains("Name")) {
                if (!first) {
                    sql.append(" AND");
                }
                sql.append(" name LIKE ?");
                ++queries;
                first = false;
            }
            if (fields.contains("Email")) {
                if (!first) {
                    sql.append(" AND");
                }
                sql.append(" email LIKE ?");
                ++queries;
            }
            con = DbConnectionManager.getConnection();
            if (startIndex == 0 && numResults == Integer.MAX_VALUE) {
                pstmt = con.prepareStatement(sql.toString());
                for (int i = 1; i <= queries; ++i) {
                    pstmt.setString(i, query);
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    usernames.add(rs.getString(1));
                }
            } else {
                pstmt = DbConnectionManager.createScrollablePreparedStatement(con, sql.toString());
                DbConnectionManager.limitRowsAndFetchSize(pstmt, startIndex, numResults);
                for (int i = 1; i <= queries; ++i) {
                    pstmt.setString(i, query);
                }
                rs = pstmt.executeQuery();
                DbConnectionManager.scrollResultSet(rs, startIndex);
                for (int count = 0; rs.next() && count < numResults; ++count) {
                    usernames.add(rs.getString(1));
                }
            }
            if (Log.isDebugEnabled()) {
                Log.debug("Results: " + usernames.size());
                this.LogResults(usernames);
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        catch (SQLException e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        return new UserCollection(usernames.toArray(new String[usernames.size()]));
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isNameRequired() {
        return false;
    }

    @Override
    public boolean isEmailRequired() {
        return false;
    }

    private void LogResults(List<String> listElements) {
        String callingMethod = Thread.currentThread().getStackTrace()[3].getMethodName();
        StringBuilder sb = new StringBuilder(256);
        int count = 0;
        for (String element : listElements) {
            if (count > 20) {
                Log.debug(callingMethod + " results: " + sb.toString());
                sb.delete(0, sb.length());
                count = 0;
            }
            sb.append(element).append(',');
            ++count;
        }
        sb.append('.');
        Log.debug(callingMethod + " results: " + sb.toString());
    }
}

