/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.user;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.admin.AdminManager;
import org.jivesoftware.openfire.user.UserMultiProvider;
import org.jivesoftware.openfire.user.UserProvider;
import org.jivesoftware.openfire.user.UserProviderMapper;
import org.jivesoftware.util.JiveGlobals;
import org.xmpp.packet.JID;

public class AuthorizationBasedUserProviderMapper
implements UserProviderMapper {
    public static final String PROPERTY_ADMINPROVIDER_CLASSNAME = "authorizationBasedUserMapper.adminProvider.className";
    public static final String PROPERTY_USERPROVIDER_CLASSNAME = "authorizationBasedUserMapper.userProvider.className";
    protected final UserProvider adminProvider;
    protected final UserProvider userProvider;

    public AuthorizationBasedUserProviderMapper() {
        JiveGlobals.migrateProperty(PROPERTY_ADMINPROVIDER_CLASSNAME);
        JiveGlobals.migrateProperty(PROPERTY_USERPROVIDER_CLASSNAME);
        this.adminProvider = UserMultiProvider.instantiate(PROPERTY_ADMINPROVIDER_CLASSNAME);
        if (this.adminProvider == null) {
            throw new IllegalStateException("A class name for the admin provider must be specified via openfire.xml or the system properties using property: authorizationBasedUserMapper.adminProvider.className");
        }
        this.userProvider = UserMultiProvider.instantiate(PROPERTY_USERPROVIDER_CLASSNAME);
        if (this.userProvider == null) {
            throw new IllegalStateException("A class name for the user provider must be specified via openfire.xml or the system properties using property: authorizationBasedUserMapper.userProvider.className");
        }
    }

    @Override
    public UserProvider getUserProvider(String username) {
        JID jid = XMPPServer.getInstance().createJID(username, null);
        boolean isAdmin = AdminManager.getAdminProvider().getAdmins().contains(jid);
        if (isAdmin) {
            return this.adminProvider;
        }
        return this.userProvider;
    }

    @Override
    public Set<UserProvider> getUserProviders() {
        LinkedHashSet<UserProvider> result = new LinkedHashSet<UserProvider>();
        result.add(this.adminProvider);
        result.add(this.userProvider);
        return result;
    }
}

