/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.update;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.jivesoftware.openfire.MessageRouter;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.openfire.container.PluginMetadata;
import org.jivesoftware.openfire.update.AvailablePlugin;
import org.jivesoftware.openfire.update.Update;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.Version;
import org.jivesoftware.util.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class UpdateManager
extends BasicModule {
    private static final Logger Log = LoggerFactory.getLogger(UpdateManager.class);
    protected static DocumentFactory docFactory = DocumentFactory.getInstance();
    private static String updateServiceURL = "http://www.igniterealtime.org/projects/openfire/versions.jsp";
    private Update serverUpdate;
    private Collection<Update> pluginUpdates = new ArrayList<Update>();
    private Map<String, AvailablePlugin> availablePlugins = new HashMap<String, AvailablePlugin>();
    private Thread thread;
    private MessageRouter router;
    private String serverName;

    public UpdateManager() {
        super("Update manager");
    }

    @Override
    public void start() throws IllegalStateException {
        super.start();
        this.startService();
    }

    private void startService() {
        this.thread = new Thread("Update Manager"){

            @Override
            public void run() {
                try {
                    Thread.sleep(5000L);
                    UpdateManager.this.loadSavedInfo();
                    while (UpdateManager.this.isServiceEnabled()) {
                        this.waitForNextCheck();
                        if (!UpdateManager.this.isServiceEnabled()) continue;
                        try {
                            UpdateManager.this.checkForServerUpdate(true);
                            UpdateManager.this.checkForPluginsUpdates(true);
                        }
                        catch (Exception e) {
                            Log.error("Error checking for updates", (Throwable)e);
                        }
                        long now = System.currentTimeMillis();
                        JiveGlobals.setProperty("update.lastCheck", String.valueOf(now));
                        if (now == JiveGlobals.getLongProperty("update.lastCheck", 0L)) continue;
                        Log.error("Error: update service check did not save correctly. Stopping update service.");
                        return;
                    }
                }
                catch (InterruptedException e) {
                    Log.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    UpdateManager.this.thread = null;
                }
            }

            private void waitForNextCheck() throws InterruptedException {
                long lastCheck = JiveGlobals.getLongProperty("update.lastCheck", 0L);
                if (lastCheck == 0L) {
                    Thread.sleep(30000L);
                } else {
                    long elapsed = System.currentTimeMillis() - lastCheck;
                    long frequency = (long)UpdateManager.this.getCheckFrequency() * 3600000L;
                    while (elapsed < frequency) {
                        Thread.sleep(frequency - elapsed);
                        elapsed = System.currentTimeMillis() - lastCheck;
                    }
                }
            }
        };
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.router = server.getMessageRouter();
        this.serverName = server.getServerInfo().getXMPPDomain();
        JiveGlobals.migrateProperty("update.service-enabled");
        JiveGlobals.migrateProperty("update.notify-admins");
    }

    public synchronized void checkForServerUpdate(boolean notificationsEnabled) throws Exception {
        String requestXML = this.getServerUpdateRequest();
        HttpClient httpClient = new HttpClient();
        if (this.isUsingProxy()) {
            HostConfiguration hc = new HostConfiguration();
            hc.setProxy(this.getProxyHost(), this.getProxyPort());
            httpClient.setHostConfiguration(hc);
        }
        PostMethod postMethod = new PostMethod(updateServiceURL);
        NameValuePair[] data = new NameValuePair[]{new NameValuePair("type", "update"), new NameValuePair("query", requestXML)};
        postMethod.setRequestBody(data);
        if (httpClient.executeMethod((HttpMethod)postMethod) == 200) {
            String responseBody = postMethod.getResponseBodyAsString();
            this.processServerUpdateResponse(responseBody, notificationsEnabled);
        }
    }

    public synchronized void checkForPluginsUpdates(boolean notificationsEnabled) throws Exception {
        String requestXML = this.getAvailablePluginsUpdateRequest();
        HttpClient httpClient = new HttpClient();
        if (this.isUsingProxy()) {
            HostConfiguration hc = new HostConfiguration();
            hc.setProxy(this.getProxyHost(), this.getProxyPort());
            httpClient.setHostConfiguration(hc);
        }
        PostMethod postMethod = new PostMethod(updateServiceURL);
        NameValuePair[] data = new NameValuePair[]{new NameValuePair("type", "available"), new NameValuePair("query", requestXML)};
        postMethod.setRequestBody(data);
        if (httpClient.executeMethod((HttpMethod)postMethod) == 200) {
            String responseBody = postMethod.getResponseBodyAsString();
            this.processAvailablePluginsResponse(responseBody, notificationsEnabled);
        }
    }

    public boolean downloadPlugin(String url) {
        boolean installed;
        block19: {
            installed = false;
            HttpClient httpClient = new HttpClient();
            if (this.isUsingProxy()) {
                HostConfiguration hc = new HostConfiguration();
                hc.setProxy(this.getProxyHost(), this.getProxyPort());
                httpClient.setHostConfiguration(hc);
            }
            if (this.isKnownPlugin(url)) {
                GetMethod getMethod = new GetMethod(url);
                try {
                    int statusCode = httpClient.executeMethod((HttpMethod)getMethod);
                    if (statusCode != 200) break block19;
                    try (InputStream in = getMethod.getResponseBodyAsStream();){
                        String pluginFilename = url.substring(url.lastIndexOf("/") + 1);
                        installed = XMPPServer.getInstance().getPluginManager().installPlugin(in, pluginFilename);
                    }
                    if (installed) {
                        for (Update update : this.pluginUpdates) {
                            if (!update.getURL().equals(url)) continue;
                            update.setDownloaded(true);
                        }
                        this.saveLatestServerInfo();
                    }
                }
                catch (IOException e) {
                    Log.warn("Error downloading new plugin version", (Throwable)e);
                }
            } else {
                Log.error("Invalid plugin download URL: " + url);
            }
        }
        return installed;
    }

    private boolean isKnownPlugin(String url) {
        for (String pluginName : this.availablePlugins.keySet()) {
            if (!this.availablePlugins.get(pluginName).getDownloadURL().toString().equals(url)) continue;
            return true;
        }
        return false;
    }

    public boolean isPluginDownloaded(String url) {
        String pluginFilename = url.substring(url.lastIndexOf("/") + 1);
        return XMPPServer.getInstance().getPluginManager().isInstalled(pluginFilename);
    }

    public List<AvailablePlugin> getNotInstalledPlugins() {
        ArrayList<AvailablePlugin> result = new ArrayList<AvailablePlugin>(this.availablePlugins.values());
        PluginManager pluginManager = XMPPServer.getInstance().getPluginManager();
        Version currentServerVersion = XMPPServer.getInstance().getServerInfo().getVersion();
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            AvailablePlugin availablePlugin = (AvailablePlugin)iterator.next();
            if (pluginManager.isInstalled(availablePlugin.getCanonicalName())) {
                iterator.remove();
                continue;
            }
            if (availablePlugin.getMinServerVersion() != null && availablePlugin.getMinServerVersion().isNewerThan(currentServerVersion)) {
                iterator.remove();
            }
            if (availablePlugin.getPriorToServerVersion() == null || availablePlugin.getPriorToServerVersion().isNewerThan(currentServerVersion)) continue;
            iterator.remove();
        }
        Collections.sort(result, new Comparator<AvailablePlugin>(){

            @Override
            public int compare(AvailablePlugin o1, AvailablePlugin o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        return result;
    }

    public String getNotificationMessage() {
        return LocaleUtils.getLocalizedString("update.notification-message");
    }

    public boolean isServiceEnabled() {
        return JiveGlobals.getBooleanProperty("update.service-enabled", true);
    }

    public void setServiceEnabled(boolean enabled) {
        JiveGlobals.setProperty("update.service-enabled", enabled ? "true" : "false");
        if (enabled && this.thread == null) {
            this.startService();
        }
    }

    public boolean isNotificationEnabled() {
        return JiveGlobals.getBooleanProperty("update.notify-admins", true);
    }

    public void setNotificationEnabled(boolean enabled) {
        JiveGlobals.setProperty("update.notify-admins", enabled ? "true" : "false");
    }

    public int getCheckFrequency() {
        int frequency = JiveGlobals.getIntProperty("update.frequency", 48);
        if (frequency < 12) {
            return 12;
        }
        return frequency;
    }

    public void setCheckFrequency(int checkFrequency) {
        JiveGlobals.setProperty("update.frequency", Integer.toString(checkFrequency));
    }

    public boolean isUsingProxy() {
        return this.getProxyHost() != null;
    }

    public String getProxyHost() {
        return JiveGlobals.getProperty("update.proxy.host");
    }

    public void setProxyHost(String host) {
        if (host == null) {
            JiveGlobals.deleteProperty("update.proxy.host");
        } else {
            JiveGlobals.setProperty("update.proxy.host", host);
        }
    }

    public int getProxyPort() {
        return JiveGlobals.getIntProperty("update.proxy.port", -1);
    }

    public void setProxyPort(int port) {
        JiveGlobals.setProperty("update.proxy.port", Integer.toString(port));
    }

    public Update getServerUpdate() {
        return this.serverUpdate;
    }

    public Update getPluginUpdate(String pluginName, Version currentVersion) {
        for (Update update : this.pluginUpdates) {
            if (!update.getComponentName().equals(pluginName) || !new Version(update.getLatestVersion()).isNewerThan(currentVersion)) continue;
            return update;
        }
        return null;
    }

    private String getServerUpdateRequest() {
        XMPPServer server = XMPPServer.getInstance();
        Element xmlRequest = docFactory.createDocument().addElement("version");
        Element openfire = xmlRequest.addElement("openfire");
        openfire.addAttribute("current", server.getServerInfo().getVersion().getVersionString());
        return xmlRequest.asXML();
    }

    private String getAvailablePluginsUpdateRequest() {
        Element xmlRequest = docFactory.createDocument().addElement("available");
        Element locale = xmlRequest.addElement("locale");
        locale.addText(JiveGlobals.getLocale().toString());
        return xmlRequest.asXML();
    }

    private void processServerUpdateResponse(String response, boolean notificationsEnabled) throws DocumentException {
        Version latestVersion;
        this.serverUpdate = null;
        SAXReader xmlReader = new SAXReader();
        xmlReader.setEncoding("UTF-8");
        Element xmlResponse = xmlReader.read((Reader)new StringReader(response)).getRootElement();
        Element openfire = xmlResponse.element("openfire");
        if (openfire != null && (latestVersion = new Version(openfire.attributeValue("latest"))).isNewerThan(XMPPServer.getInstance().getServerInfo().getVersion())) {
            URL changelog = null;
            try {
                changelog = new URL(openfire.attributeValue("changelog"));
            }
            catch (MalformedURLException e) {
                Log.warn("Unable to parse URL from openfire changelog value '{}'.", (Object)openfire.attributeValue("changelog"), (Object)e);
            }
            URL url = null;
            try {
                url = new URL(openfire.attributeValue("url"));
            }
            catch (MalformedURLException e) {
                Log.warn("Unable to parse URL from openfire download url value '{}'.", (Object)openfire.attributeValue("url"), (Object)e);
            }
            this.serverUpdate = new Update("Openfire", latestVersion.getVersionString(), changelog.toExternalForm(), url.toExternalForm());
        }
        if (notificationsEnabled && this.isNotificationEnabled() && this.serverUpdate != null) {
            Collection<JID> admins = XMPPServer.getInstance().getAdmins();
            Message notification = new Message();
            notification.setFrom(this.serverName);
            notification.setBody(this.getNotificationMessage() + " " + this.serverUpdate.getComponentName() + " " + this.serverUpdate.getLatestVersion());
            for (JID jid : admins) {
                notification.setTo(jid);
                this.router.route(notification);
            }
        }
        this.saveLatestServerInfo();
    }

    private void processAvailablePluginsResponse(String response, boolean notificationsEnabled) throws DocumentException {
        this.availablePlugins = new HashMap<String, AvailablePlugin>();
        SAXReader xmlReader = new SAXReader();
        xmlReader.setEncoding("UTF-8");
        Element xmlResponse = xmlReader.read((Reader)new StringReader(response)).getRootElement();
        Iterator plugins = xmlResponse.elementIterator("plugin");
        while (plugins.hasNext()) {
            Element plugin = (Element)plugins.next();
            AvailablePlugin available = AvailablePlugin.getInstance(plugin);
            this.availablePlugins.put(available.getName(), available);
        }
        this.buildPluginsUpdateList();
        if (notificationsEnabled && this.isNotificationEnabled() && !this.pluginUpdates.isEmpty()) {
            Collection<JID> admins = XMPPServer.getInstance().getAdmins();
            for (Update update : this.pluginUpdates) {
                Message notification = new Message();
                notification.setFrom(this.serverName);
                notification.setBody(this.getNotificationMessage() + " " + update.getComponentName() + " " + update.getLatestVersion());
                for (JID jid : admins) {
                    notification.setTo(jid);
                    this.router.route(notification);
                }
            }
        }
        this.saveAvailablePluginsInfo();
    }

    private void buildPluginsUpdateList() {
        this.pluginUpdates = new ArrayList<Update>();
        XMPPServer server = XMPPServer.getInstance();
        Version currentServerVersion = XMPPServer.getInstance().getServerInfo().getVersion();
        for (PluginMetadata plugin : server.getPluginManager().getMetadataExtractedPlugins().values()) {
            Version pluginPriorToServerVersion;
            Version pluginMinServerVersion;
            Version latestPluginVersion;
            AvailablePlugin latestPlugin = this.availablePlugins.get(plugin.getName());
            if (latestPlugin == null || !(latestPluginVersion = latestPlugin.getVersion()).isNewerThan(plugin.getVersion()) || (pluginMinServerVersion = latestPlugin.getMinServerVersion()) != null && pluginMinServerVersion.isNewerThan(currentServerVersion) || (pluginPriorToServerVersion = latestPlugin.getPriorToServerVersion()) != null && !pluginPriorToServerVersion.isNewerThan(currentServerVersion)) continue;
            Update update = new Update(plugin.getName(), latestPlugin.getVersion().getVersionString(), latestPlugin.getChangelog().toExternalForm(), latestPlugin.getDownloadURL().toExternalForm());
            this.pluginUpdates.add(update);
        }
    }

    private void saveLatestServerInfo() {
        Element xmlResponse = docFactory.createDocument().addElement("version");
        if (this.serverUpdate != null) {
            Element component = xmlResponse.addElement("openfire");
            component.addAttribute("latest", this.serverUpdate.getLatestVersion());
            component.addAttribute("changelog", this.serverUpdate.getChangelog());
            component.addAttribute("url", this.serverUpdate.getURL());
        }
        try {
            File file = new File(JiveGlobals.getHomeDirectory(), "conf");
            if (!file.exists()) {
                file.mkdir();
            }
            if ((file = new File(JiveGlobals.getHomeDirectory() + File.separator + "conf", "server-update.xml")).exists()) {
                file.delete();
            }
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
                OutputFormat prettyPrinter = OutputFormat.createPrettyPrint();
                XMLWriter xmlWriter = new XMLWriter(writer, prettyPrinter);
                xmlWriter.write(xmlResponse);
            }
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAvailablePluginsInfo() {
        Element xml = docFactory.createDocument().addElement("available");
        for (AvailablePlugin plugin : this.availablePlugins.values()) {
            Element component = xml.addElement("plugin");
            component.addAttribute("name", plugin.getName());
            component.addAttribute("latest", plugin.getVersion() != null ? plugin.getVersion().getVersionString() : null);
            component.addAttribute("changelog", plugin.getChangelog() != null ? plugin.getChangelog().toExternalForm() : null);
            component.addAttribute("url", plugin.getDownloadURL() != null ? plugin.getDownloadURL().toExternalForm() : null);
            component.addAttribute("author", plugin.getAuthor());
            component.addAttribute("description", plugin.getDescription());
            component.addAttribute("icon", plugin.getIcon() != null ? plugin.getIcon().toExternalForm() : null);
            component.addAttribute("minServerVersion", plugin.getMinServerVersion() != null ? plugin.getMinServerVersion().getVersionString() : null);
            component.addAttribute("priorToServerVersion", plugin.getPriorToServerVersion() != null ? plugin.getPriorToServerVersion().getVersionString() : null);
            component.addAttribute("readme", plugin.getReadme() != null ? plugin.getReadme().toExternalForm() : null);
            component.addAttribute("licenseType", plugin.getLicense());
            component.addAttribute("fileSize", Long.toString(plugin.getFileSize()));
        }
        Writer writer = null;
        try {
            File file = new File(JiveGlobals.getHomeDirectory(), "conf");
            if (!file.exists()) {
                file.mkdir();
            }
            if ((file = new File(JiveGlobals.getHomeDirectory() + File.separator + "conf", "available-plugins.xml")).exists()) {
                file.delete();
            }
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
            OutputFormat prettyPrinter = OutputFormat.createPrettyPrint();
            XMLWriter xmlWriter = new XMLWriter(writer, prettyPrinter);
            xmlWriter.write(xml);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e1) {
                    Log.error(e1.getMessage(), (Throwable)e1);
                }
            }
        }
    }

    private void loadSavedInfo() {
        this.loadLatestServerInfo();
        this.loadAvailablePluginsInfo();
        this.buildPluginsUpdateList();
    }

    private void loadLatestServerInfo() {
        Document xmlResponse;
        File file = new File(JiveGlobals.getHomeDirectory() + File.separator + "conf", "server-update.xml");
        if (!file.exists()) {
            return;
        }
        if (!file.canRead()) {
            Log.warn("Cannot retrieve server updates. File must be readable: " + file.getName());
            return;
        }
        try (FileReader reader = new FileReader(file);){
            SAXReader xmlReader = new SAXReader();
            xmlReader.setEncoding("UTF-8");
            xmlResponse = xmlReader.read((Reader)reader);
        }
        catch (Exception e) {
            Log.error("Error reading server-update.xml", (Throwable)e);
            return;
        }
        Element openfire = xmlResponse.getRootElement().element("openfire");
        if (openfire != null) {
            Version latestVersion = new Version(openfire.attributeValue("latest"));
            URL changelog = null;
            try {
                changelog = new URL(openfire.attributeValue("changelog"));
            }
            catch (MalformedURLException e) {
                Log.warn("Unable to parse URL from openfire changelog value '{}'.", (Object)openfire.attributeValue("changelog"), (Object)e);
            }
            URL url = null;
            try {
                url = new URL(openfire.attributeValue("url"));
            }
            catch (MalformedURLException e) {
                Log.warn("Unable to parse URL from openfire download url value '{}'.", (Object)openfire.attributeValue("url"), (Object)e);
            }
            Version currentServerVersion = XMPPServer.getInstance().getServerInfo().getVersion();
            if (latestVersion.isNewerThan(currentServerVersion)) {
                this.serverUpdate = new Update("Openfire", latestVersion.getVersionString(), changelog.toExternalForm(), url.toExternalForm());
            }
        }
    }

    private void loadAvailablePluginsInfo() {
        Document xmlResponse;
        File file = new File(JiveGlobals.getHomeDirectory() + File.separator + "conf", "available-plugins.xml");
        if (!file.exists()) {
            return;
        }
        if (!file.canRead()) {
            Log.warn("Cannot retrieve available plugins. File must be readable: " + file.getName());
            return;
        }
        try (FileReader reader = new FileReader(file);){
            SAXReader xmlReader = new SAXReader();
            xmlReader.setEncoding("UTF-8");
            xmlResponse = xmlReader.read((Reader)reader);
        }
        catch (Exception e) {
            Log.error("Error reading available-plugins.xml", (Throwable)e);
            return;
        }
        Iterator it = xmlResponse.getRootElement().elementIterator("plugin");
        while (it.hasNext()) {
            Element plugin = (Element)it.next();
            AvailablePlugin instance = AvailablePlugin.getInstance(plugin);
            this.availablePlugins.put(instance.getName(), instance);
        }
    }

    public Collection<Update> getPluginUpdates() {
        return this.pluginUpdates;
    }
}

