/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.openfire.IQRouter;
import org.jivesoftware.openfire.MessageRouter;
import org.jivesoftware.openfire.PacketException;
import org.jivesoftware.openfire.PresenceRouter;
import org.jivesoftware.openfire.RemotePacketRouter;
import org.jivesoftware.openfire.RoutableChannelHandler;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.carbons.Received;
import org.jivesoftware.openfire.cluster.ClusterEventListener;
import org.jivesoftware.openfire.cluster.ClusterManager;
import org.jivesoftware.openfire.cluster.NodeID;
import org.jivesoftware.openfire.component.ExternalComponentManager;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.forward.Forwarded;
import org.jivesoftware.openfire.handler.PresenceUpdateHandler;
import org.jivesoftware.openfire.server.OutgoingSessionPromise;
import org.jivesoftware.openfire.server.RemoteServerManager;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.session.DomainPair;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.openfire.session.LocalOutgoingServerSession;
import org.jivesoftware.openfire.session.OutgoingServerSession;
import org.jivesoftware.openfire.session.RemoteSessionLocator;
import org.jivesoftware.openfire.spi.ClientRoute;
import org.jivesoftware.openfire.spi.LocalRoutingTable;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketExtension;
import org.xmpp.packet.Presence;

public class RoutingTableImpl
extends BasicModule
implements RoutingTable,
ClusterEventListener {
    private static final Logger Log = LoggerFactory.getLogger(RoutingTableImpl.class);
    public static final String C2S_CACHE_NAME = "Routing Users Cache";
    public static final String ANONYMOUS_C2S_CACHE_NAME = "Routing AnonymousUsers Cache";
    public static final String S2S_CACHE_NAME = "Routing Servers Cache";
    public static final String COMPONENT_CACHE_NAME = "Routing Components Cache";
    public static final String C2S_SESSION_NAME = "Routing User Sessions";
    private Cache<DomainPair, byte[]> serversCache = CacheFactory.createCache("Routing Servers Cache");
    private Cache<String, Set<NodeID>> componentsCache = CacheFactory.createCache("Routing Components Cache");
    private Cache<String, ClientRoute> usersCache = CacheFactory.createCache("Routing Users Cache");
    private Cache<String, ClientRoute> anonymousUsersCache = CacheFactory.createCache("Routing AnonymousUsers Cache");
    private Cache<String, Collection<String>> usersSessions = CacheFactory.createCache("Routing User Sessions");
    private String serverName;
    private XMPPServer server;
    private LocalRoutingTable localRoutingTable = new LocalRoutingTable();
    private RemotePacketRouter remotePacketRouter;
    private IQRouter iqRouter;
    private MessageRouter messageRouter;
    private PresenceRouter presenceRouter;
    private PresenceUpdateHandler presenceUpdateHandler;

    public RoutingTableImpl() {
        super("Routing table");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServerRoute(DomainPair address, LocalOutgoingServerSession destination) {
        this.localRoutingTable.addRoute(address, destination);
        Lock lock = CacheFactory.getLock(address, this.serversCache);
        try {
            lock.lock();
            this.serversCache.put(address, this.server.getNodeID().toByteArray());
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addComponentRoute(JID route, RoutableChannelHandler destination) {
        DomainPair pair = new DomainPair("", route.getDomain());
        String address = route.getDomain();
        this.localRoutingTable.addRoute(pair, destination);
        Lock lock = CacheFactory.getLock(address, this.componentsCache);
        try {
            lock.lock();
            HashSet<NodeID> nodes = (HashSet<NodeID>)this.componentsCache.get(address);
            if (nodes == null) {
                nodes = new HashSet<NodeID>();
            }
            nodes.add(this.server.getNodeID());
            this.componentsCache.put(address, nodes);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addClientRoute(JID route, LocalClientSession destination) {
        boolean added;
        boolean available = destination.getPresence().isAvailable();
        Log.debug("Adding client route {}", (Object)route);
        this.localRoutingTable.addRoute(new DomainPair("", route.toString()), destination);
        if (destination.getAuthToken().isAnonymous()) {
            Lock lockAn = CacheFactory.getLock(route.toString(), this.anonymousUsersCache);
            try {
                lockAn.lock();
                added = this.anonymousUsersCache.put(route.toString(), new ClientRoute(this.server.getNodeID(), available)) == null;
            }
            finally {
                lockAn.unlock();
            }
            if (route.getResource() != null && (!available || added)) {
                Lock lock = CacheFactory.getLock(route.toBareJID(), this.usersSessions);
                try {
                    lock.lock();
                    this.usersSessions.put(route.toBareJID(), Arrays.asList(route.toString()));
                }
                finally {
                    lock.unlock();
                }
            }
        } else {
            Lock lockU = CacheFactory.getLock(route.toString(), this.usersCache);
            try {
                lockU.lock();
                added = this.usersCache.put(route.toString(), new ClientRoute(this.server.getNodeID(), available)) == null;
            }
            finally {
                lockU.unlock();
            }
            if (route.getResource() != null && (!available || added)) {
                Lock lock = CacheFactory.getLock(route.toBareJID(), this.usersSessions);
                try {
                    lock.lock();
                    Set<String> jids = (HashSet<String>)this.usersSessions.get(route.toBareJID());
                    if (jids == null) {
                        jids = ClusterManager.isClusteringStarted() ? new HashSet<String>() : Collections.newSetFromMap(new ConcurrentHashMap());
                    }
                    jids.add(route.toString());
                    this.usersSessions.put(route.toBareJID(), jids);
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return added;
    }

    @Override
    public void broadcastPacket(Message packet, boolean onlyLocal) {
        for (ClientSession clientSession : this.localRoutingTable.getClientRoutes()) {
            clientSession.process((Packet)packet);
        }
        if (!onlyLocal && this.remotePacketRouter != null) {
            this.remotePacketRouter.broadcastPacket(packet);
        }
    }

    @Override
    public void routePacket(JID jid, Packet packet, boolean fromServer) throws PacketException {
        boolean routed = false;
        try {
            routed = this.serverName.equals(jid.getDomain()) ? this.routeToLocalDomain(jid, packet, fromServer) : (jid.getDomain().endsWith(this.serverName) && this.hasComponentRoute(jid) ? this.routeToComponent(jid, packet, routed) : this.routeToRemoteDomain(jid, packet, routed));
        }
        catch (Exception ex) {
            Log.error("Primary packet routing failed", (Throwable)ex);
        }
        if (!routed) {
            if (Log.isDebugEnabled()) {
                Log.debug("Failed to route packet to JID: {} packet: {}", (Object)jid, (Object)packet.toXML());
            }
            if (packet instanceof IQ) {
                this.iqRouter.routingFailed(jid, packet);
            } else if (packet instanceof Message) {
                this.messageRouter.routingFailed(jid, packet);
            } else if (packet instanceof Presence) {
                this.presenceRouter.routingFailed(jid, packet);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean routeToLocalDomain(JID jid, Packet packet, boolean fromServer) {
        boolean routed = false;
        Element privateElement = packet.getElement().element(QName.get((String)"private", (String)"urn:xmpp:carbons:2"));
        boolean isPrivate = privateElement != null;
        packet.getElement().remove(privateElement);
        if (jid.getResource() == null) {
            if (!(packet instanceof Message)) throw new PacketException("Cannot route packet of type IQ or Presence to bare JID: " + packet.toXML());
            return this.routeToBareJID(jid, (Message)packet, isPrivate);
        }
        ClientRoute clientRoute = (ClientRoute)this.usersCache.get(jid.toString());
        if (clientRoute == null) {
            clientRoute = (ClientRoute)this.anonymousUsersCache.get(jid.toString());
        }
        if (clientRoute == null) return routed;
        if (!clientRoute.isAvailable() && this.routeOnlyAvailable(packet, fromServer) && !this.presenceUpdateHandler.hasDirectPresence(packet.getTo(), packet.getFrom())) {
            Log.debug("Unable to route packet. Packet should only be sent to available sessions and the route is not available. {} ", (Object)packet.toXML());
            return false;
        }
        if (this.localRoutingTable.isLocalRoute(jid)) {
            Message message;
            if (packet instanceof Message && (message = (Message)packet).getType() == Message.Type.chat && !isPrivate) {
                List<JID> routes = this.getRoutes(jid.asBareJID(), null);
                for (JID route : routes) {
                    ClientSession clientSession;
                    if (route.equals((Object)jid) || !(clientSession = this.getClientRoute(route)).isMessageCarbonsEnabled()) continue;
                    Message carbon = new Message();
                    carbon.setType(message.getType());
                    carbon.setFrom(route.asBareJID());
                    carbon.setTo(route);
                    carbon.addExtension((PacketExtension)new Received(new Forwarded(message)));
                    try {
                        this.localRoutingTable.getRoute(route).process(carbon);
                    }
                    catch (UnauthorizedException e) {
                        Log.error("Unable to route packet " + packet.toXML(), (Throwable)e);
                    }
                }
            }
            try {
                this.localRoutingTable.getRoute(jid).process(packet);
                return true;
            }
            catch (UnauthorizedException e) {
                Log.error("Unable to route packet " + packet.toXML(), (Throwable)e);
            }
            return routed;
        } else {
            if (this.remotePacketRouter == null) return routed;
            routed = this.remotePacketRouter.routePacket(clientRoute.getNodeID().toByteArray(), jid, packet);
            if (routed) return routed;
            this.removeClientRoute(jid);
        }
        return routed;
    }

    private boolean routeToComponent(JID jid, Packet packet, boolean routed) {
        if (!this.hasComponentRoute(jid) && !ExternalComponentManager.hasConfiguration(jid.getDomain())) {
            return false;
        }
        RoutableChannelHandler route = this.localRoutingTable.getRoute(new JID(null, jid.getDomain(), null, true));
        if (route != null) {
            try {
                route.process(packet);
                routed = true;
            }
            catch (UnauthorizedException e) {
                Log.error("Unable to route packet " + packet.toXML(), (Throwable)e);
            }
        } else {
            Set nodes = (Set)this.componentsCache.get(jid.getDomain());
            if (nodes != null) {
                for (NodeID nodeID : nodes) {
                    if (this.server.getNodeID().equals(nodeID)) {
                        try {
                            RoutableChannelHandler localRoute = this.localRoutingTable.getRoute(new JID(null, jid.getDomain(), null, true));
                            if (localRoute == null) continue;
                            localRoute.process(packet);
                            routed = true;
                            break;
                        }
                        catch (UnauthorizedException e) {
                            Log.error("Unable to route packet " + packet.toXML(), (Throwable)e);
                            continue;
                        }
                    }
                    if (this.remotePacketRouter == null || !(routed = this.remotePacketRouter.routePacket(nodeID.toByteArray(), jid, packet))) continue;
                    break;
                }
            }
        }
        return routed;
    }

    private boolean routeToRemoteDomain(JID jid, Packet packet, boolean routed) {
        if (!JiveGlobals.getBooleanProperty("xmpp.server.allow-anonymous-outbound-data", false) && this.isAnonymousRoute(packet.getFrom())) {
            Log.info("The anonymous user '{}' attempted to send data to '{}', which is on a remote domain. Openfire is configured to not allow anonymous users to send data to remote domains.", (Object)packet.getFrom(), (Object)jid);
            routed = false;
            return routed;
        }
        DomainPair pair = new DomainPair(packet.getFrom().getDomain(), jid.getDomain());
        byte[] nodeID = (byte[])this.serversCache.get(pair);
        if (nodeID != null) {
            if (this.server.getNodeID().equals(nodeID)) {
                try {
                    this.localRoutingTable.getRoute(pair).process(packet);
                    routed = true;
                }
                catch (UnauthorizedException e) {
                    Log.error("Unable to route packet " + packet.toXML(), (Throwable)e);
                }
            } else if (this.remotePacketRouter != null) {
                routed = this.remotePacketRouter.routePacket(nodeID, jid, packet);
            }
        } else if (!RemoteServerManager.canAccess(jid.getDomain())) {
            Log.info("Will not route: Remote domain {} is not accessible according to our configuration (typical causes: server federation is disabled, or domain is blacklisted).", (Object)jid.getDomain());
            routed = false;
        } else {
            OutgoingSessionPromise.getInstance().process(packet);
            routed = true;
        }
        return routed;
    }

    private boolean routeOnlyAvailable(Packet packet, boolean fromServer) {
        boolean hasSender;
        if (fromServer) {
            return false;
        }
        boolean onlyAvailable = true;
        JID from = packet.getFrom();
        boolean bl = hasSender = from != null;
        if (packet instanceof IQ) {
            onlyAvailable = hasSender && (!this.serverName.equals(from.getDomain()) || from.getResource() != null) && !this.componentsCache.containsKey(from.getDomain());
        } else if (packet instanceof Message || packet instanceof Presence) {
            onlyAvailable = !hasSender || !this.serverName.equals(from.toString()) && !this.componentsCache.containsKey(from.getDomain());
        }
        return onlyAvailable;
    }

    private boolean routeToBareJID(JID recipientJID, Message packet, boolean isPrivate) {
        ArrayList<ClientSession> sessions = new ArrayList<ClientSession>();
        for (JID jID : this.getRoutes(recipientJID, packet.getFrom())) {
            ClientSession session = this.getClientRoute(jID);
            if (session == null || !session.isInitialized()) continue;
            sessions.add(session);
        }
        List<ClientSession> nonNegativePrioritySessions = this.getNonNegativeSessions(sessions, 0);
        if (packet.getType() == Message.Type.error) {
            Log.debug("Error stanza to bare JID discarded: {}", (Object)packet.toXML());
            return true;
        }
        if (packet.getType() == Message.Type.groupchat) {
            Log.debug("Groupchat stanza to bare JID discarded: {}", (Object)packet.toXML());
            return false;
        }
        if (nonNegativePrioritySessions.isEmpty()) {
            Log.debug("Unable to route packet. No session is available so store offline. {} ", (Object)packet.toXML());
            return false;
        }
        for (ClientSession session : nonNegativePrioritySessions) {
            if (packet.getType() == Message.Type.headline) {
                session.process((Packet)packet);
                continue;
            }
            if (this.shouldCarbonCopyToResource(session, packet, isPrivate)) {
                session.process((Packet)packet);
                continue;
            }
            if (!JiveGlobals.getBooleanProperty("route.really-all-resources", false)) continue;
            session.process((Packet)packet);
        }
        if (packet.getType() == Message.Type.headline) {
            return true;
        }
        if (JiveGlobals.getBooleanProperty("route.really-all-resources", false)) {
            return true;
        }
        List<ClientSession> list = this.getHighestPrioritySessions(nonNegativePrioritySessions);
        if (list.size() == 1) {
            if (!this.shouldCarbonCopyToResource(list.get(0), packet, isPrivate)) {
                list.get(0).process((Packet)packet);
            }
        } else if (!JiveGlobals.getBooleanProperty("route.all-resources", false)) {
            Collections.sort(list, new Comparator<ClientSession>(){

                @Override
                public int compare(ClientSession o1, ClientSession o2) {
                    int anotherVal;
                    int thisVal = this.getShowValue(o1);
                    return thisVal < (anotherVal = this.getShowValue(o2)) ? -1 : (thisVal == anotherVal ? 0 : 1);
                }

                private int getShowValue(ClientSession session) {
                    Presence.Show show = session.getPresence().getShow();
                    if (show == Presence.Show.chat) {
                        return 1;
                    }
                    if (show == null) {
                        return 2;
                    }
                    if (show == Presence.Show.away) {
                        return 3;
                    }
                    if (show == Presence.Show.xa) {
                        return 4;
                    }
                    return 5;
                }
            });
            ArrayList<ClientSession> targets = new ArrayList<ClientSession>();
            Presence.Show showFilter = list.get(0).getPresence().getShow();
            for (ClientSession session : list) {
                if (session.getPresence().getShow() != showFilter) break;
                targets.add(session);
            }
            Collections.sort(targets, new Comparator<ClientSession>(){

                @Override
                public int compare(ClientSession o1, ClientSession o2) {
                    return o2.getLastActiveDate().compareTo(o1.getLastActiveDate());
                }
            });
            ClientSession session = (ClientSession)targets.get(0);
            if (!this.shouldCarbonCopyToResource(session, packet, isPrivate)) {
                session.process((Packet)packet);
            }
        } else {
            for (ClientSession session : list) {
                if (this.shouldCarbonCopyToResource(session, packet, isPrivate)) continue;
                session.process((Packet)packet);
            }
        }
        return true;
    }

    private boolean shouldCarbonCopyToResource(ClientSession session, Message message, boolean isPrivate) {
        return !isPrivate && session.isMessageCarbonsEnabled() && message.getType() == Message.Type.chat;
    }

    private List<ClientSession> getHighestPrioritySessions(List<ClientSession> sessions) {
        int highest = Integer.MIN_VALUE;
        for (ClientSession session : sessions) {
            int priority = session.getPresence().getPriority();
            if (priority < 0 || priority <= highest) continue;
            highest = priority;
        }
        return this.getNonNegativeSessions(sessions, highest);
    }

    private List<ClientSession> getNonNegativeSessions(List<ClientSession> sessions, int min) {
        if (min < 0) {
            return Collections.emptyList();
        }
        ArrayList<ClientSession> answer = new ArrayList<ClientSession>(sessions.size());
        for (ClientSession session : sessions) {
            if (session.getPresence().getPriority() < min) continue;
            answer.add(session);
        }
        return answer;
    }

    @Override
    public ClientSession getClientRoute(JID jid) {
        RemoteSessionLocator locator;
        ClientSession session = (ClientSession)this.localRoutingTable.getRoute(jid);
        if (session == null && (locator = this.server.getRemoteSessionLocator()) != null) {
            ClientRoute route = (ClientRoute)this.usersCache.get(jid.toString());
            if (route == null) {
                route = (ClientRoute)this.anonymousUsersCache.get(jid.toString());
            }
            if (route != null) {
                session = locator.getClientSession(route.getNodeID().toByteArray(), jid);
            }
        }
        return session;
    }

    @Override
    public Collection<ClientSession> getClientsRoutes(boolean onlyLocal) {
        RemoteSessionLocator locator;
        ArrayList<ClientSession> sessions = new ArrayList<ClientSession>(this.localRoutingTable.getClientRoutes());
        if (!onlyLocal && (locator = this.server.getRemoteSessionLocator()) != null) {
            ClientRoute route;
            for (Map.Entry entry : this.usersCache.entrySet()) {
                route = (ClientRoute)entry.getValue();
                if (this.server.getNodeID().equals(route.getNodeID())) continue;
                sessions.add(locator.getClientSession(route.getNodeID().toByteArray(), new JID((String)entry.getKey())));
            }
            for (Map.Entry entry : this.anonymousUsersCache.entrySet()) {
                route = (ClientRoute)entry.getValue();
                if (this.server.getNodeID().equals(route.getNodeID())) continue;
                sessions.add(locator.getClientSession(route.getNodeID().toByteArray(), new JID((String)entry.getKey())));
            }
        }
        return sessions;
    }

    @Override
    public OutgoingServerSession getServerRoute(DomainPair jids) {
        byte[] nodeID;
        RemoteSessionLocator locator;
        OutgoingServerSession session = (OutgoingServerSession)this.localRoutingTable.getRoute(jids);
        if (session == null && (locator = this.server.getRemoteSessionLocator()) != null && (nodeID = (byte[])this.serversCache.get(jids)) != null) {
            session = locator.getOutgoingServerSession(nodeID, jids);
        }
        return session;
    }

    @Override
    public Collection<String> getServerHostnames() {
        HashSet<String> domains = new HashSet<String>();
        for (DomainPair pair : this.serversCache.keySet()) {
            domains.add(pair.getRemote());
        }
        return domains;
    }

    @Override
    public Collection<DomainPair> getServerRoutes() {
        return this.serversCache.keySet();
    }

    @Override
    public int getServerSessionsCount() {
        return this.localRoutingTable.getServerRoutes().size();
    }

    @Override
    public Collection<String> getComponentsDomains() {
        return this.componentsCache.keySet();
    }

    @Override
    public boolean hasClientRoute(JID jid) {
        return this.usersCache.containsKey(jid.toString()) || this.isAnonymousRoute(jid);
    }

    @Override
    public boolean isAnonymousRoute(JID jid) {
        return this.anonymousUsersCache.containsKey(jid.toString());
    }

    @Override
    public boolean isLocalRoute(JID jid) {
        return this.localRoutingTable.isLocalRoute(jid);
    }

    @Override
    public boolean hasServerRoute(DomainPair pair) {
        return this.serversCache.containsKey(pair);
    }

    @Override
    public boolean hasComponentRoute(JID jid) {
        return this.componentsCache.containsKey(jid.getDomain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<JID> getRoutes(JID route, JID requester) {
        ArrayList<JID> jids = new ArrayList<JID>();
        if (this.serverName.equals(route.getDomain())) {
            if (route.getResource() != null) {
                ClientRoute clientRoute = (ClientRoute)this.usersCache.get(route.toString());
                if (clientRoute == null) {
                    clientRoute = (ClientRoute)this.anonymousUsersCache.get(route.toString());
                }
                if (clientRoute == null || !clientRoute.isAvailable() && !this.presenceUpdateHandler.hasDirectPresence(route, requester)) return jids;
                jids.add(route);
                return jids;
            } else {
                Lock lock = CacheFactory.getLock(route.toBareJID(), this.usersSessions);
                try {
                    lock.lock();
                    Collection sessions = (Collection)this.usersSessions.get(route.toBareJID());
                    if (sessions == null) return jids;
                    for (String jid : sessions) {
                        ClientRoute clientRoute = (ClientRoute)this.usersCache.get(jid);
                        if (clientRoute == null) {
                            clientRoute = (ClientRoute)this.anonymousUsersCache.get(jid);
                        }
                        if (clientRoute == null || !clientRoute.isAvailable() && !this.presenceUpdateHandler.hasDirectPresence(new JID(jid), requester)) continue;
                        jids.add(new JID(jid));
                    }
                    return jids;
                }
                finally {
                    lock.unlock();
                }
            }
        } else if (route.getDomain().contains(this.serverName)) {
            if (!this.componentsCache.containsKey(route.getDomain())) return jids;
            jids.add(new JID(route.getDomain()));
            return jids;
        } else {
            jids.add(route);
        }
        return jids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeClientRoute(JID route) {
        boolean anonymous = false;
        String address = route.toString();
        ClientRoute clientRoute = null;
        Lock lockU = CacheFactory.getLock(address, this.usersCache);
        try {
            lockU.lock();
            clientRoute = (ClientRoute)this.usersCache.remove(address);
        }
        finally {
            lockU.unlock();
        }
        if (clientRoute == null) {
            Lock lockA = CacheFactory.getLock(address, this.anonymousUsersCache);
            try {
                lockA.lock();
                clientRoute = (ClientRoute)this.anonymousUsersCache.remove(address);
                anonymous = true;
            }
            finally {
                lockA.unlock();
            }
        }
        if (clientRoute != null && route.getResource() != null) {
            Lock lock = CacheFactory.getLock(route.toBareJID(), this.usersSessions);
            try {
                lock.lock();
                if (anonymous) {
                    this.usersSessions.remove(route.toBareJID());
                } else {
                    Collection jids = (Collection)this.usersSessions.get(route.toBareJID());
                    if (jids != null) {
                        jids.remove(route.toString());
                        if (!jids.isEmpty()) {
                            this.usersSessions.put(route.toBareJID(), jids);
                        } else {
                            this.usersSessions.remove(route.toBareJID());
                        }
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
        Log.debug("Removing client route {}", (Object)route);
        this.localRoutingTable.removeRoute(new DomainPair("", route.toString()));
        return clientRoute != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeServerRoute(DomainPair route) {
        String address = route.toString();
        boolean removed = false;
        Lock lock = CacheFactory.getLock(route, this.serversCache);
        try {
            lock.lock();
            removed = this.serversCache.remove(route) != null;
        }
        finally {
            lock.unlock();
        }
        this.localRoutingTable.removeRoute(route);
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeComponentRoute(JID route) {
        String address = route.getDomain();
        boolean removed = false;
        Lock lock = CacheFactory.getLock(address, this.componentsCache);
        try {
            lock.lock();
            Set nodes = (Set)this.componentsCache.get(address);
            if (nodes != null) {
                removed = nodes.remove(this.server.getNodeID());
                if (nodes.isEmpty()) {
                    this.componentsCache.remove(address);
                } else {
                    this.componentsCache.put(address, nodes);
                }
            }
        }
        finally {
            lock.unlock();
        }
        this.localRoutingTable.removeRoute(new DomainPair("", address));
        return removed;
    }

    @Override
    public void setRemotePacketRouter(RemotePacketRouter remotePacketRouter) {
        this.remotePacketRouter = remotePacketRouter;
    }

    @Override
    public RemotePacketRouter getRemotePacketRouter() {
        return this.remotePacketRouter;
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.server = server;
        this.serverName = server.getServerInfo().getXMPPDomain();
        this.iqRouter = server.getIQRouter();
        this.messageRouter = server.getMessageRouter();
        this.presenceRouter = server.getPresenceRouter();
        this.presenceUpdateHandler = server.getPresenceUpdateHandler();
        ClusterManager.addListener(this);
    }

    @Override
    public void start() throws IllegalStateException {
        super.start();
        this.localRoutingTable.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.localRoutingTable.stop();
    }

    @Override
    public void joinedCluster() {
        this.restoreCacheContent();
        PresenceUpdateHandler presenceUpdateHandler = XMPPServer.getInstance().getPresenceUpdateHandler();
        for (LocalClientSession session : this.localRoutingTable.getClientRoutes()) {
            session.setInitialized(false);
            presenceUpdateHandler.process(session.getPresence());
        }
    }

    @Override
    public void joinedCluster(byte[] nodeID) {
    }

    @Override
    public void leftCluster() {
        if (!XMPPServer.getInstance().isShuttingDown()) {
            this.restoreCacheContent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leftCluster(byte[] nodeID) {
        Lock clientLock = CacheFactory.getLock(nodeID, this.usersCache);
        try {
            clientLock.lock();
            ArrayList remoteClientRoutes = new ArrayList();
            for (Map.Entry entry : this.usersCache.entrySet()) {
                if (!((ClientRoute)entry.getValue()).getNodeID().equals(nodeID)) continue;
                remoteClientRoutes.add(entry.getKey());
            }
            for (Map.Entry entry : this.anonymousUsersCache.entrySet()) {
                if (!((ClientRoute)entry.getValue()).getNodeID().equals(nodeID)) continue;
                remoteClientRoutes.add(entry.getKey());
            }
            for (Iterator route : remoteClientRoutes) {
                this.removeClientRoute(new JID((String)((Object)route)));
            }
        }
        finally {
            clientLock.unlock();
        }
        Lock serverLock = CacheFactory.getLock(nodeID, this.serversCache);
        try {
            serverLock.lock();
            ArrayList remoteServerDomains = new ArrayList();
            for (Map.Entry entry : this.serversCache.entrySet()) {
                if (!Arrays.equals((byte[])entry.getValue(), nodeID)) continue;
                remoteServerDomains.add(entry.getKey());
            }
            for (DomainPair domainPair : remoteServerDomains) {
                this.removeServerRoute(domainPair);
            }
        }
        finally {
            serverLock.unlock();
        }
        Lock componentLock = CacheFactory.getLock(nodeID, this.componentsCache);
        try {
            componentLock.lock();
            ArrayList remoteComponents = new ArrayList();
            NodeID nodeID2 = NodeID.getInstance(nodeID);
            for (Map.Entry entry : this.componentsCache.entrySet()) {
                if (!((Set)entry.getValue()).remove(nodeID2) || ((Set)entry.getValue()).size() != 0) continue;
                remoteComponents.add(entry.getKey());
            }
            for (String jid : remoteComponents) {
                this.removeComponentRoute(new JID(jid));
            }
        }
        finally {
            componentLock.unlock();
        }
    }

    @Override
    public void markedAsSeniorClusterMember() {
    }

    private void restoreCacheContent() {
        for (LocalOutgoingServerSession localOutgoingServerSession : this.localRoutingTable.getServerRoutes()) {
            for (DomainPair pair : localOutgoingServerSession.getOutgoingDomainPairs()) {
                this.addServerRoute(pair, localOutgoingServerSession);
            }
        }
        for (RoutableChannelHandler routableChannelHandler : this.localRoutingTable.getComponentRoute()) {
            this.addComponentRoute(routableChannelHandler.getAddress(), routableChannelHandler);
        }
        for (LocalClientSession localClientSession : this.localRoutingTable.getClientRoutes()) {
            this.addClientRoute(localClientSession.getAddress(), localClientSession);
        }
    }
}

