/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.spi;

import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.service.IoServiceListener;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.integration.jmx.IoServiceMBean;
import org.apache.mina.integration.jmx.IoSessionMBean;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.JMXManager;
import org.jivesoftware.openfire.net.StalledSessionsFilter;
import org.jivesoftware.openfire.nio.ClientConnectionHandler;
import org.jivesoftware.openfire.nio.ComponentConnectionHandler;
import org.jivesoftware.openfire.nio.ConnectionHandler;
import org.jivesoftware.openfire.nio.MultiplexerConnectionHandler;
import org.jivesoftware.openfire.nio.ServerConnectionHandler;
import org.jivesoftware.openfire.nio.XMPPCodecFactory;
import org.jivesoftware.openfire.spi.ConnectionAcceptor;
import org.jivesoftware.openfire.spi.ConnectionConfiguration;
import org.jivesoftware.openfire.spi.EncryptionArtifactFactory;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MINAConnectionAcceptor
extends ConnectionAcceptor {
    private final Logger Log;
    private final String name;
    private final ConnectionHandler connectionHandler;
    private final EncryptionArtifactFactory encryptionArtifactFactory;
    private NioSocketAcceptor socketAcceptor;

    public MINAConnectionAcceptor(ConnectionConfiguration configuration) {
        super(configuration);
        this.name = configuration.getType().toString().toLowerCase() + (configuration.getTlsPolicy() == Connection.TLSPolicy.legacyMode ? "_ssl" : "");
        this.Log = LoggerFactory.getLogger((String)(MINAConnectionAcceptor.class.getName() + "[" + this.name + "]"));
        switch (configuration.getType()) {
            case SOCKET_S2S: {
                this.connectionHandler = new ServerConnectionHandler(configuration);
                break;
            }
            case SOCKET_C2S: {
                this.connectionHandler = new ClientConnectionHandler(configuration);
                break;
            }
            case COMPONENT: {
                this.connectionHandler = new ComponentConnectionHandler(configuration);
                break;
            }
            case CONNECTION_MANAGER: {
                this.connectionHandler = new MultiplexerConnectionHandler(configuration);
                break;
            }
            default: {
                throw new IllegalStateException("This implementation does not support the connection type as defined in the provided configuration: " + (Object)((Object)configuration.getType()));
            }
        }
        this.encryptionArtifactFactory = new EncryptionArtifactFactory(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() {
        block9: {
            if (this.socketAcceptor != null) {
                this.Log.warn("Unable to start acceptor (it is already started!)");
                return;
            }
            try {
                int initialSize = this.configuration.getMaxThreadPoolSize() / 4 + 1;
                ExecutorFilter executorFilter = new ExecutorFilter(initialSize, this.configuration.getMaxThreadPoolSize(), 60L, TimeUnit.SECONDS);
                ThreadPoolExecutor eventExecutor = (ThreadPoolExecutor)executorFilter.getExecutor();
                NamedThreadFactory threadFactory = new NamedThreadFactory(this.name + "-thread-", eventExecutor.getThreadFactory(), true, null);
                eventExecutor.setThreadFactory(threadFactory);
                this.socketAcceptor = MINAConnectionAcceptor.buildSocketAcceptor();
                if (JMXManager.isEnabled()) {
                    this.configureJMX(this.socketAcceptor, this.name);
                }
                DefaultIoFilterChainBuilder filterChain = this.socketAcceptor.getFilterChain();
                filterChain.addFirst("threadModel", (IoFilter)executorFilter);
                filterChain.addAfter("threadModel", "xmpp", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new XMPPCodecFactory()));
                filterChain.addAfter("xmpp", "outCap", (IoFilter)new StalledSessionsFilter());
                if (this.configuration.getTlsPolicy() == Connection.TLSPolicy.legacyMode) {
                    SslFilter sslFilter = this.encryptionArtifactFactory.createServerModeSslFilter();
                    filterChain.addAfter("threadModel", "tls", (IoFilter)sslFilter);
                }
                if (this.configuration.getMaxBufferSize() > 0) {
                    this.socketAcceptor.getSessionConfig().setMaxReadBufferSize(this.configuration.getMaxBufferSize());
                    this.Log.debug("Throttling read buffer for connections to max={} bytes", (Object)this.configuration.getMaxBufferSize());
                }
                this.socketAcceptor.setHandler((IoHandler)this.connectionHandler);
                this.socketAcceptor.bind((SocketAddress)new InetSocketAddress(this.configuration.getBindAddress(), this.configuration.getPort()));
            }
            catch (Exception e) {
                System.err.println("Error starting " + this.configuration.getPort() + ": " + e.getMessage());
                this.Log.error("Error starting: " + this.configuration.getPort(), (Throwable)e);
                if (this.socketAcceptor == null) break block9;
                try {
                    this.socketAcceptor.unbind();
                }
                finally {
                    this.socketAcceptor = null;
                }
            }
        }
    }

    @Override
    public synchronized void stop() {
        if (this.socketAcceptor != null) {
            this.socketAcceptor.unbind();
            this.socketAcceptor = null;
        }
    }

    @Override
    public synchronized boolean isIdle() {
        return this.socketAcceptor != null && this.socketAcceptor.getManagedSessionCount() == 0;
    }

    @Override
    public synchronized void reconfigure(ConnectionConfiguration configuration) {
        block9: {
            this.configuration = configuration;
            if (this.socketAcceptor == null) {
                return;
            }
            DefaultIoFilterChainBuilder filterChain = this.socketAcceptor.getFilterChain();
            if (filterChain.contains("threadModel")) {
                ExecutorFilter executorFilter = (ExecutorFilter)filterChain.get("threadModel");
                ((ThreadPoolExecutor)executorFilter.getExecutor()).setCorePoolSize(configuration.getMaxThreadPoolSize() / 4 + 1);
                ((ThreadPoolExecutor)executorFilter.getExecutor()).setMaximumPoolSize(configuration.getMaxThreadPoolSize());
            }
            if (configuration.getTlsPolicy() == Connection.TLSPolicy.legacyMode) {
                try {
                    SslFilter sslFilter = this.encryptionArtifactFactory.createServerModeSslFilter();
                    if (filterChain.contains("tls")) {
                        filterChain.replace("tls", (IoFilter)sslFilter);
                        break block9;
                    }
                    filterChain.addAfter("threadModel", "tls", (IoFilter)sslFilter);
                }
                catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                    this.Log.error("An exception occurred while reloading the TLS configuration.", (Throwable)e);
                }
            } else if (filterChain.contains("tls")) {
                filterChain.remove("tls");
            }
        }
        if (configuration.getMaxBufferSize() > 0) {
            this.socketAcceptor.getSessionConfig().setMaxReadBufferSize(configuration.getMaxBufferSize());
            this.Log.debug("Throttling read buffer for connections to max={} bytes", (Object)configuration.getMaxBufferSize());
        }
    }

    public synchronized int getPort() {
        return this.configuration.getPort();
    }

    public synchronized NioSocketAcceptor getSocketAcceptor() {
        return this.socketAcceptor;
    }

    private static NioSocketAcceptor buildSocketAcceptor() {
        int linger;
        int sendBuffer;
        int processorCount = JiveGlobals.getIntProperty("xmpp.processor.count", Runtime.getRuntime().availableProcessors());
        NioSocketAcceptor socketAcceptor = new NioSocketAcceptor(processorCount);
        socketAcceptor.setReuseAddress(true);
        socketAcceptor.setBacklog(JiveGlobals.getIntProperty("xmpp.socket.backlog", 50));
        SocketSessionConfig socketSessionConfig = socketAcceptor.getSessionConfig();
        int receiveBuffer = JiveGlobals.getIntProperty("xmpp.socket.buffer.receive", -1);
        if (receiveBuffer > 0) {
            socketSessionConfig.setReceiveBufferSize(receiveBuffer);
        }
        if ((sendBuffer = JiveGlobals.getIntProperty("xmpp.socket.buffer.send", -1)) > 0) {
            socketSessionConfig.setSendBufferSize(sendBuffer);
        }
        if ((linger = JiveGlobals.getIntProperty("xmpp.socket.linger", -1)) > 0) {
            socketSessionConfig.setSoLinger(linger);
        }
        socketSessionConfig.setTcpNoDelay(JiveGlobals.getBooleanProperty("xmpp.socket.tcp-nodelay", socketSessionConfig.isTcpNoDelay()));
        return socketAcceptor;
    }

    private void configureJMX(NioSocketAcceptor acceptor, String suffix) {
        final String prefix = IoServiceMBean.class.getPackage().getName();
        try {
            IoServiceMBean mbean = new IoServiceMBean((IoService)acceptor);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = new ObjectName(prefix + ":type=SocketAcceptor,name=" + suffix);
            mbs.registerMBean(mbean, name);
        }
        catch (JMException ex) {
            this.Log.warn("Failed to register MINA acceptor mbean (JMX): " + ex);
        }
        if (JiveGlobals.getBooleanProperty("xmpp.socket.jmx.sessions", false)) {
            acceptor.addListener(new IoServiceListener(){

                private ObjectName getObjectNameForSession(IoSession session) throws MalformedObjectNameException {
                    return new ObjectName(prefix + ":type=IoSession,name=" + session.getRemoteAddress().toString().replace(':', '/'));
                }

                public void sessionCreated(IoSession session) {
                    try {
                        ManagementFactory.getPlatformMBeanServer().registerMBean(new IoSessionMBean(session), this.getObjectNameForSession(session));
                    }
                    catch (JMException ex) {
                        MINAConnectionAcceptor.this.Log.warn("Failed to register MINA session mbean (JMX): " + ex);
                    }
                }

                public void sessionDestroyed(IoSession session) {
                    try {
                        ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.getObjectNameForSession(session));
                    }
                    catch (JMException ex) {
                        MINAConnectionAcceptor.this.Log.warn("Failed to unregister MINA session mbean (JMX): " + ex);
                    }
                }

                public void serviceActivated(IoService service) throws Exception {
                }

                public void serviceDeactivated(IoService service) throws Exception {
                }

                public void serviceIdle(IoService service, IdleStatus idleStatus) throws Exception {
                }
            });
        }
    }
}

