/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.openfire.RoutableChannelHandler;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.session.DomainPair;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.openfire.session.LocalOutgoingServerSession;
import org.jivesoftware.openfire.session.LocalSession;
import org.jivesoftware.openfire.session.OutgoingServerSession;
import org.jivesoftware.openfire.session.Session;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.TaskEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

class LocalRoutingTable {
    private static final Logger Log = LoggerFactory.getLogger(LocalRoutingTable.class);
    Map<DomainPair, RoutableChannelHandler> routes = new ConcurrentHashMap<DomainPair, RoutableChannelHandler>();

    LocalRoutingTable() {
    }

    boolean addRoute(DomainPair pair, RoutableChannelHandler route) {
        return this.routes.put(pair, route) != route;
    }

    RoutableChannelHandler getRoute(DomainPair pair) {
        return this.routes.get(pair);
    }

    RoutableChannelHandler getRoute(JID jid) {
        return this.routes.get(new DomainPair("", jid.toString()));
    }

    Collection<LocalClientSession> getClientRoutes() {
        ArrayList<LocalClientSession> sessions = new ArrayList<LocalClientSession>();
        for (RoutableChannelHandler route : this.routes.values()) {
            if (!(route instanceof LocalClientSession)) continue;
            sessions.add((LocalClientSession)route);
        }
        return sessions;
    }

    Collection<LocalOutgoingServerSession> getServerRoutes() {
        ArrayList<LocalOutgoingServerSession> sessions = new ArrayList<LocalOutgoingServerSession>();
        for (RoutableChannelHandler route : this.routes.values()) {
            if (!(route instanceof LocalOutgoingServerSession)) continue;
            sessions.add((LocalOutgoingServerSession)route);
        }
        return sessions;
    }

    Collection<RoutableChannelHandler> getComponentRoute() {
        ArrayList<RoutableChannelHandler> sessions = new ArrayList<RoutableChannelHandler>();
        for (RoutableChannelHandler route : this.routes.values()) {
            if (route instanceof LocalOutgoingServerSession || route instanceof LocalClientSession) continue;
            sessions.add(route);
        }
        return sessions;
    }

    void removeRoute(DomainPair pair) {
        this.routes.remove(pair);
    }

    public void start() {
        int period = 180000;
        TaskEngine.getInstance().scheduleAtFixedRate((TimerTask)new ServerCleanupTask(), period, (long)period);
    }

    public void stop() {
        try {
            for (RoutableChannelHandler route : this.routes.values()) {
                if (!(route instanceof LocalSession)) continue;
                LocalSession session = (LocalSession)route;
                try {
                    if (session.isDetached()) continue;
                    session.getConnection().systemShutdown();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isLocalRoute(DomainPair pair) {
        return this.routes.containsKey(pair);
    }

    public boolean isLocalRoute(JID jid) {
        return this.routes.containsKey(new DomainPair("", jid.toString()));
    }

    private class ServerCleanupTask
    extends TimerTask {
        private ServerCleanupTask() {
        }

        @Override
        public void run() {
            int idleTime = SessionManager.getInstance().getServerSessionIdleTime();
            if (idleTime == -1) {
                return;
            }
            long deadline = System.currentTimeMillis() - (long)idleTime;
            for (RoutableChannelHandler route : LocalRoutingTable.this.routes.values()) {
                if (!(route instanceof OutgoingServerSession)) continue;
                Session session = (Session)route;
                try {
                    if (session.getLastActiveDate().getTime() >= deadline) continue;
                    session.close();
                }
                catch (Throwable e) {
                    Log.error(LocaleUtils.getLocalizedString("admin.error"), e);
                }
            }
        }
    }
}

