/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.spi;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.cluster.NodeID;
import org.jivesoftware.util.cache.CacheSizes;
import org.jivesoftware.util.cache.Cacheable;
import org.jivesoftware.util.cache.ExternalizableUtil;

public class ClientRoute
implements Cacheable,
Externalizable {
    private NodeID nodeID;
    private boolean available;

    public ClientRoute() {
    }

    public NodeID getNodeID() {
        return this.nodeID;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public ClientRoute(NodeID nodeID, boolean available) {
        this.nodeID = nodeID;
        this.available = available;
    }

    @Override
    public int getCachedSize() {
        int size = 0;
        size += CacheSizes.sizeOfObject();
        size += this.nodeID.toByteArray().length;
        return size += CacheSizes.sizeOfBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeByteArray(out, this.nodeID.toByteArray());
        ExternalizableUtil.getInstance().writeBoolean(out, this.available);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] bytes = ExternalizableUtil.getInstance().readByteArray(in);
        this.nodeID = XMPPServer.getInstance().getNodeID().equals(bytes) ? XMPPServer.getInstance().getNodeID() : NodeID.getInstance(bytes);
        this.available = ExternalizableUtil.getInstance().readBoolean(in);
    }
}

