/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.session;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.net.ssl.SSLHandshakeException;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.XMPPPacketReader;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.StreamID;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.net.MXParser;
import org.jivesoftware.openfire.net.SASLAuthentication;
import org.jivesoftware.openfire.net.SocketConnection;
import org.jivesoftware.openfire.net.SocketUtil;
import org.jivesoftware.openfire.server.OutgoingServerSocketReader;
import org.jivesoftware.openfire.server.RemoteServerManager;
import org.jivesoftware.openfire.server.ServerDialback;
import org.jivesoftware.openfire.session.DomainPair;
import org.jivesoftware.openfire.session.IncomingServerSession;
import org.jivesoftware.openfire.session.LocalServerSession;
import org.jivesoftware.openfire.session.OutgoingServerSession;
import org.jivesoftware.openfire.spi.BasicStreamIDFactory;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;

public class LocalOutgoingServerSession
extends LocalServerSession
implements OutgoingServerSession {
    private static final Logger Log = LoggerFactory.getLogger(LocalOutgoingServerSession.class);
    private static Pattern pattern = Pattern.compile("[a-zA-Z]");
    private OutgoingServerSocketReader socketReader;
    private Collection<DomainPair> outgoingDomainPairs = new HashSet<DomainPair>();

    public static boolean authenticateDomain(String localDomain, String remoteDomain) {
        Logger log = LoggerFactory.getLogger((String)(Log.getName() + "[Authenticate local domain: '" + localDomain + "' to remote domain: '" + remoteDomain + "']"));
        DomainPair domainPair = new DomainPair(localDomain, remoteDomain);
        log.debug("Start domain authentication ...");
        if (remoteDomain == null || remoteDomain.length() == 0 || remoteDomain.trim().indexOf(32) > -1) {
            log.warn("Unable to authenticate: remote domain is invalid.");
            return false;
        }
        try {
            if (!RemoteServerManager.canAccess(remoteDomain)) {
                log.info("Unable to authenticate: Remote domain is not accessible according to our configuration (typical causes: server federation is disabled, or domain is blacklisted).");
                return false;
            }
            log.debug("Searching for pre-existing outgoing sessions to the remote domain (if one exists, it will be re-used) ...");
            SessionManager sessionManager = SessionManager.getInstance();
            if (sessionManager == null) {
                log.warn("Unable to authenticate: a SessionManager instance is not available. This should not occur unless Openfire is starting up or shutting down.");
                return false;
            }
            OutgoingServerSession session = sessionManager.getOutgoingServerSession(domainPair);
            if (session != null && session.checkOutgoingDomainPair(localDomain, remoteDomain)) {
                log.debug("Authentication successful (domain was already authenticated in the pre-existing session).");
                return true;
            }
            if (session != null && !session.isUsingServerDialback()) {
                log.debug("Dialback was not used for '{}'. This session cannot be re-used.", (Object)domainPair);
                session = null;
            }
            if (session == null) {
                log.debug("There are no pre-existing outgoing sessions to the remote domain itself. Searching for pre-existing outgoing sessions to super- or subdomains of the remote domain (if one exists, it might be re-usable) ...");
                block2: for (IncomingServerSession incomingSession : sessionManager.getIncomingServerSessions(remoteDomain)) {
                    for (String otherRemoteDomain : incomingSession.getValidatedDomains()) {
                        session = sessionManager.getOutgoingServerSession(new DomainPair(localDomain, otherRemoteDomain));
                        if (session == null) continue;
                        log.debug("An outgoing session to a different domain ('{}') hosted on the remote domain was found.", (Object)otherRemoteDomain);
                        if (session.isUsingServerDialback()) {
                            log.debug("Dialback was used for '{}'. This session can be re-used.", (Object)otherRemoteDomain);
                            continue block2;
                        }
                        log.debug("Dialback was not used for '{}'. This session cannot be re-used.", (Object)otherRemoteDomain);
                        session = null;
                    }
                }
                if (session == null) {
                    log.debug("There are no pre-existing session to other domains hosted on the remote domain.");
                }
            }
            if (session != null) {
                log.debug("A pre-existing session can be re-used. The session was established using server dialback so it is possible to do piggybacking to authenticate more domains.");
                if (session.checkOutgoingDomainPair(localDomain, remoteDomain)) {
                    log.debug("Authentication successful (domain was already authenticated in the pre-existing session).");
                    return true;
                }
                if (session.authenticateSubdomain(localDomain, remoteDomain)) {
                    log.debug("Authentication successful (domain authentication was added using a pre-existing session).");
                    return true;
                }
                log.warn("Unable to authenticate: Unable to add authentication to pre-exising session.");
                return false;
            }
            log.debug("Unable to re-use an existing session. Creating a new session ...");
            int port = RemoteServerManager.getPortForServer(remoteDomain);
            session = LocalOutgoingServerSession.createOutgoingSession(localDomain, remoteDomain, port);
            if (session != null) {
                log.debug("Created a new session.");
                session.addOutgoingDomainPair(localDomain, remoteDomain);
                sessionManager.outgoingServerSessionCreated((LocalOutgoingServerSession)session);
                log.debug("Authentication successful.");
                return true;
            }
            log.warn("Unable to authenticate: Fail to create new session.");
            return false;
        }
        catch (Exception e) {
            log.error("An exception occurred while authenticating remote domain!", (Throwable)e);
            return false;
        }
    }

    private static LocalOutgoingServerSession createOutgoingSession(String localDomain, String remoteDomain, int port) {
        Logger log;
        block19: {
            log = LoggerFactory.getLogger((String)(Log.getName() + "[Create outgoing session for: " + localDomain + " to " + remoteDomain + "]"));
            log.debug("Creating new session...");
            log.debug("Creating plain socket connection to a host that belongs to the remote XMPP domain.");
            Socket socket = SocketUtil.createSocketToXmppDomain(remoteDomain, port);
            if (socket == null) {
                log.info("Unable to create new session: Cannot create a plain socket connection with any applicable remote host.");
                return null;
            }
            SocketConnection connection = null;
            try {
                connection = new SocketConnection(XMPPServer.getInstance().getPacketDeliverer(), socket, false);
                log.debug("Send the stream header and wait for response...");
                StringBuilder openingStream = new StringBuilder();
                openingStream.append("<stream:stream");
                openingStream.append(" xmlns:db=\"jabber:server:dialback\"");
                openingStream.append(" xmlns:stream=\"http://etherx.jabber.org/streams\"");
                openingStream.append(" xmlns=\"jabber:server\"");
                openingStream.append(" from=\"").append(localDomain).append("\"");
                openingStream.append(" to=\"").append(remoteDomain).append("\"");
                openingStream.append(" version=\"1.0\">");
                connection.deliverRawText(openingStream.toString());
                int soTimeout = socket.getSoTimeout();
                socket.setSoTimeout(5000);
                XMPPPacketReader reader = new XMPPPacketReader();
                reader.getXPPParser().setInput(new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8));
                MXParser xpp = reader.getXPPParser();
                int eventType = xpp.getEventType();
                while (eventType != 2) {
                    eventType = xpp.next();
                }
                String serverVersion = xpp.getAttributeValue("", "version");
                String id = xpp.getAttributeValue("", "id");
                log.debug("Got a response (stream ID: {}, version: {}). Check if the remote server is XMPP 1.0 compliant...", (Object)id, (Object)serverVersion);
                if (serverVersion != null && LocalOutgoingServerSession.decodeVersion(serverVersion)[0] >= 1) {
                    log.debug("The remote server is XMPP 1.0 compliant (or at least reports to be).");
                    socket.setSoTimeout(soTimeout);
                    log.debug("Processing stream features of the remote domain...");
                    Element features = reader.parseDocument().getRootElement();
                    if (features != null) {
                        log.debug("Check if both us as well as the remote server have enabled STARTTLS and/or dialback ...");
                        boolean useTLS = JiveGlobals.getBooleanProperty("xmpp.server.tls.enabled", true);
                        if (useTLS && features.element("starttls") != null) {
                            log.debug("Both us and the remote server support the STARTTLS feature. Secure and authenticate the connection with TLS & SASL...");
                            LocalOutgoingServerSession answer = LocalOutgoingServerSession.secureAndAuthenticate(remoteDomain, connection, reader, openingStream, localDomain);
                            if (answer != null) {
                                log.debug("Successfully secured/authenticated the connection with TLS/SASL)!");
                                log.debug("Successfully created new session!");
                                return answer;
                            }
                            log.debug("Unable to secure and authenticate the connection with TLS & SASL.");
                        } else {
                            if (connection.getTlsPolicy() == Connection.TLSPolicy.required) {
                                log.debug("I have no StartTLS yet I must TLS");
                                connection.close();
                                return null;
                            }
                            if (ServerDialback.isEnabled() && features.element("dialback") != null) {
                                log.debug("Both us and the remote server support the 'dialback' feature. Authenticate the connection with dialback...");
                                ServerDialback method = new ServerDialback(connection, localDomain);
                                OutgoingServerSocketReader newSocketReader = new OutgoingServerSocketReader(reader);
                                if (method.authenticateDomain(newSocketReader, localDomain, remoteDomain, id)) {
                                    log.debug("Successfully authenticated the connection with dialback!");
                                    new BasicStreamIDFactory();
                                    StreamID streamID = BasicStreamIDFactory.createStreamID(id);
                                    LocalOutgoingServerSession session = new LocalOutgoingServerSession(localDomain, (Connection)connection, newSocketReader, streamID);
                                    connection.init(session);
                                    session.setAddress(new JID(null, remoteDomain, null));
                                    log.debug("Successfully created new session!");
                                    return session;
                                }
                                log.debug("Unable to authenticate the connection with dialback.");
                            }
                        }
                    } else {
                        log.debug("Error! No data from the remote server (expected a 'feature' element).");
                    }
                } else {
                    log.debug("The remote server is not XMPP 1.0 compliant.");
                }
                log.debug("Something went wrong so close the connection and try server dialback over a plain connection");
                if (connection.getTlsPolicy() == Connection.TLSPolicy.required) {
                    log.debug("I have no StartTLS yet I must TLS");
                    connection.close();
                    return null;
                }
                connection.close();
            }
            catch (SSLHandshakeException e) {
                log.info("STARTTLS negotiation failed. Closing connection (without sending any data such as <failure/> or </stream>).", (Throwable)e);
                if (connection != null) {
                    connection.forceClose();
                }
            }
            catch (Exception e) {
                log.warn("An exception occurred while creating an encrypted session. Closing connection.", (Throwable)e);
                if (connection == null) break block19;
                connection.close();
            }
        }
        if (ServerDialback.isEnabled()) {
            log.debug("Unable to create a new session. Going to try connecting using server dialback as a fallback.");
            LocalOutgoingServerSession outgoingSession = new ServerDialback().createOutgoingSession(localDomain, remoteDomain, port);
            if (outgoingSession != null) {
                log.debug("Successfully created new session (using dialback as a fallback)!");
                return outgoingSession;
            }
            log.warn("Unable to create a new session: Dialback (as a fallback) failed.");
            return null;
        }
        log.warn("Unable to create a new session: exhausted all options (not trying dialback as a fallback, as server dialback is disabled by configuration.");
        return null;
    }

    private static LocalOutgoingServerSession secureAndAuthenticate(String remoteDomain, SocketConnection connection, XMPPPacketReader reader, StringBuilder openingStream, String localDomain) throws Exception {
        Logger log = LoggerFactory.getLogger((String)(Log.getName() + "[Secure/Authenticate connection for: " + localDomain + " to: " + remoteDomain + "]"));
        log.debug("Securing and authenticating connection ...");
        log.debug("Indicating we want TLS and wait for response.");
        connection.deliverRawText("<starttls xmlns='urn:ietf:params:xml:ns:xmpp-tls'/>");
        MXParser xpp = reader.getXPPParser();
        Element proceed = reader.parseDocument().getRootElement();
        if (proceed != null && proceed.getName().equals("proceed")) {
            log.debug("Received 'proceed' from remote server. Negotiating TLS...");
            try {
                connection.startTLS(true);
            }
            catch (Exception e) {
                log.debug("TLS negotiation failed: " + e.getMessage());
                throw e;
            }
            log.debug("TLS negotiation was successful. Connection secured. Proceeding with authentication...");
            if (!SASLAuthentication.verifyCertificates(connection.getPeerCertificates(), remoteDomain, true)) {
                if (ServerDialback.isEnabled() || ServerDialback.isEnabledForSelfSigned()) {
                    log.debug("SASL authentication failed. Will continue with dialback.");
                } else {
                    log.warn("Unable to authenticated the connection: SASL authentication failed (and dialback is not available).");
                    return null;
                }
            }
            log.debug("TLS negotiation was successful so initiate a new stream.");
            connection.deliverRawText(openingStream.toString());
            xpp.setInput(new InputStreamReader(connection.getTLSStreamHandler().getInputStream(), StandardCharsets.UTF_8));
            int eventType = xpp.getEventType();
            while (eventType != 2) {
                eventType = xpp.next();
            }
            String id = xpp.getAttributeValue("", "id");
            Element features = reader.parseDocument().getRootElement();
            if (features != null) {
                boolean saslEXTERNALoffered = false;
                if (features.element("mechanisms") != null) {
                    Iterator it = features.element("mechanisms").elementIterator();
                    while (it.hasNext()) {
                        Element mechanism = (Element)it.next();
                        if (!"EXTERNAL".equals(mechanism.getTextTrim())) continue;
                        saslEXTERNALoffered = true;
                        break;
                    }
                }
                boolean dialbackOffered = features.element("dialback") != null;
                log.debug("Remote server is offering dialback: {}, EXTERNAL SASL: {}", (Object)dialbackOffered, (Object)saslEXTERNALoffered);
                LocalOutgoingServerSession result = null;
                if (saslEXTERNALoffered) {
                    log.debug("Trying to authenticate with EXTERNAL SASL.");
                    result = LocalOutgoingServerSession.attemptSASLexternal(connection, xpp, reader, localDomain, remoteDomain, id, openingStream);
                    if (result == null) {
                        log.debug("Failed to authenticate with EXTERNAL SASL.");
                    } else {
                        log.debug("Successfully authenticated with EXTERNAL SASL.");
                    }
                }
                if (result == null) {
                    log.debug("Trying to authenticate with dialback.");
                    result = LocalOutgoingServerSession.attemptDialbackOverTLS(connection, reader, localDomain, remoteDomain, id);
                    if (result == null) {
                        log.debug("Failed to authenticate with dialback.");
                    } else {
                        log.debug("Successfully authenticated with dialback.");
                    }
                }
                if (result != null) {
                    log.debug("Successfully secured and authenticated connection!");
                    return result;
                }
                log.warn("Unable to secure and authenticate connection: Exhausted all options.");
                return null;
            }
            log.debug("Failed to secure and authenticate connection: neither SASL mechanisms nor SERVER DIALBACK were offered by the remote host.");
            return null;
        }
        log.debug("Failed to secure and authenticate connection: <proceed> was not received!");
        return null;
    }

    private static LocalOutgoingServerSession attemptDialbackOverTLS(Connection connection, XMPPPacketReader reader, String localDomain, String remoteDomain, String id) {
        Logger log = LoggerFactory.getLogger((String)(Log.getName() + "[Dialback over TLS for: " + localDomain + " to: " + remoteDomain + " (Stream ID: " + id + ")]"));
        if (ServerDialback.isEnabled() || ServerDialback.isEnabledForSelfSigned()) {
            log.debug("Trying to connecting using dialback over TLS.");
            ServerDialback method = new ServerDialback(connection, localDomain);
            OutgoingServerSocketReader newSocketReader = new OutgoingServerSocketReader(reader);
            if (method.authenticateDomain(newSocketReader, localDomain, remoteDomain, id)) {
                log.debug("Dialback over TLS was successful.");
                new BasicStreamIDFactory();
                StreamID streamID = BasicStreamIDFactory.createStreamID(id);
                LocalOutgoingServerSession session = new LocalOutgoingServerSession(localDomain, connection, newSocketReader, streamID);
                connection.init(session);
                session.setAddress(new JID(null, remoteDomain, null));
                return session;
            }
            log.debug("Dialback over TLS failed");
            return null;
        }
        log.debug("Skipping server dialback attempt as it has been disabled by local configuration.");
        return null;
    }

    private static LocalOutgoingServerSession attemptSASLexternal(SocketConnection connection, MXParser xpp, XMPPPacketReader reader, String localDomain, String remoteDomain, String id, StringBuilder openingStream) throws DocumentException, IOException, XmlPullParserException {
        Logger log = LoggerFactory.getLogger((String)(Log.getName() + "[EXTERNAL SASL for: " + localDomain + " to: " + remoteDomain + " (Stream ID: " + id + ")]"));
        log.debug("Starting EXTERNAL SASL.");
        if (LocalOutgoingServerSession.doExternalAuthentication(localDomain, connection, reader)) {
            log.debug("EXTERNAL SASL was successful.");
            connection.deliverRawText(openingStream.toString());
            xpp.setInput(new InputStreamReader(connection.getTLSStreamHandler().getInputStream(), StandardCharsets.UTF_8));
            int eventType = xpp.getEventType();
            while (eventType != 2) {
                eventType = xpp.next();
            }
            id = xpp.getAttributeValue("", "id");
            new BasicStreamIDFactory();
            StreamID streamID = BasicStreamIDFactory.createStreamID(id);
            LocalOutgoingServerSession session = new LocalOutgoingServerSession(localDomain, (Connection)connection, new OutgoingServerSocketReader(reader), streamID);
            connection.init(session);
            session.setAddress(new JID(null, remoteDomain, null));
            session.usingServerDialback = false;
            return session;
        }
        log.debug("EXTERNAL SASL failed.");
        return null;
    }

    private static boolean doExternalAuthentication(String localDomain, SocketConnection connection, XMPPPacketReader reader) throws DocumentException, IOException, XmlPullParserException {
        StringBuilder sb = new StringBuilder();
        sb.append("<auth xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\" mechanism=\"EXTERNAL\">");
        sb.append(StringUtils.encodeBase64(localDomain));
        sb.append("</auth>");
        connection.deliverRawText(sb.toString());
        Element response = reader.parseDocument().getRootElement();
        return response != null && "success".equals(response.getName());
    }

    public LocalOutgoingServerSession(String localDomain, Connection connection, OutgoingServerSocketReader socketReader, StreamID streamID) {
        super(localDomain, connection, streamID);
        this.socketReader = socketReader;
        socketReader.setSession(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean canProcess(Packet packet) {
        String senderDomain = packet.getFrom().getDomain();
        String recipDomain = packet.getTo().getDomain();
        boolean processed = true;
        if (!this.checkOutgoingDomainPair(senderDomain, recipDomain)) {
            String string = ("Auth::" + senderDomain).intern();
            synchronized (string) {
                if (!this.checkOutgoingDomainPair(senderDomain, recipDomain) && !this.authenticateSubdomain(senderDomain, packet.getTo().getDomain())) {
                    processed = false;
                }
            }
        }
        if (!processed) {
            this.returnErrorToSender(packet);
        }
        return processed;
    }

    @Override
    void deliver(Packet packet) throws UnauthorizedException {
        if (!this.conn.isClosed()) {
            this.conn.deliver(packet);
        }
    }

    @Override
    public boolean authenticateSubdomain(String localDomain, String remoteDomain) {
        if (!this.usingServerDialback) {
            return false;
        }
        ServerDialback method = new ServerDialback(this.getConnection(), localDomain);
        if (method.authenticateDomain(this.socketReader, localDomain, remoteDomain, this.getStreamID().getID())) {
            this.addOutgoingDomainPair(localDomain, remoteDomain);
            return true;
        }
        return false;
    }

    private void returnErrorToSender(Packet packet) {
        RoutingTable routingTable = XMPPServer.getInstance().getRoutingTable();
        if (packet.getError() != null) {
            Log.debug("Possible double bounce: " + packet.toXML());
        }
        try {
            if (packet instanceof IQ) {
                if (((IQ)packet).isResponse()) {
                    Log.debug("XMPP specs forbid us to respond with an IQ error to: " + packet.toXML());
                    return;
                }
                IQ reply = new IQ();
                reply.setID(packet.getID());
                reply.setTo(packet.getFrom());
                reply.setFrom(packet.getTo());
                reply.setChildElement(((IQ)packet).getChildElement().createCopy());
                reply.setType(IQ.Type.error);
                reply.setError(PacketError.Condition.remote_server_not_found);
                routingTable.routePacket(reply.getTo(), (Packet)reply, true);
            } else if (packet instanceof Presence) {
                if (((Presence)packet).getType() == Presence.Type.error) {
                    Log.debug("Double-bounce of presence: " + packet.toXML());
                    return;
                }
                Presence reply = new Presence();
                reply.setID(packet.getID());
                reply.setTo(packet.getFrom());
                reply.setFrom(packet.getTo());
                reply.setType(Presence.Type.error);
                reply.setError(PacketError.Condition.remote_server_not_found);
                routingTable.routePacket(reply.getTo(), (Packet)reply, true);
            } else if (packet instanceof Message) {
                if (((Message)packet).getType() == Message.Type.error) {
                    Log.debug("Double-bounce of message: " + packet.toXML());
                    return;
                }
                Message reply = new Message();
                reply.setID(packet.getID());
                reply.setTo(packet.getFrom());
                reply.setFrom(packet.getTo());
                reply.setType(Message.Type.error);
                reply.setThread(((Message)packet).getThread());
                reply.setError(PacketError.Condition.remote_server_not_found);
                routingTable.routePacket(reply.getTo(), (Packet)reply, true);
            }
        }
        catch (Exception e) {
            Log.error("Error returning error to sender. Original packet: " + packet, (Throwable)e);
        }
    }

    @Override
    public String getAvailableStreamFeatures() {
        return null;
    }

    @Override
    public void addOutgoingDomainPair(String localDomain, String remoteDomain) {
        DomainPair domainPair = new DomainPair(localDomain, remoteDomain);
        this.outgoingDomainPairs.add(domainPair);
        XMPPServer.getInstance().getRoutingTable().addServerRoute(domainPair, this);
    }

    @Override
    public boolean checkOutgoingDomainPair(String localDomain, String remoteDomain) {
        return this.outgoingDomainPairs.contains(new DomainPair(localDomain, remoteDomain));
    }

    @Override
    public Collection<DomainPair> getOutgoingDomainPairs() {
        return this.outgoingDomainPairs;
    }
}

