/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.PacketException;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.StreamID;
import org.jivesoftware.openfire.auth.AuthFactory;
import org.jivesoftware.openfire.component.ExternalComponentManager;
import org.jivesoftware.openfire.component.InternalComponentManager;
import org.jivesoftware.openfire.session.ComponentSession;
import org.jivesoftware.openfire.session.LocalSession;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmpp.component.ComponentException;
import org.xmpp.component.ComponentManager;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.StreamError;

public class LocalComponentSession
extends LocalSession
implements ComponentSession {
    private static final Logger Log = LoggerFactory.getLogger(LocalComponentSession.class);
    private LocalExternalComponent component;
    private String defaultSubdomain;

    public static LocalComponentSession createSession(String serverName, XmlPullParser xpp, Connection connection) throws XmlPullParserException {
        String domain = xpp.getAttributeValue("", "to");
        Boolean allowMultiple = xpp.getAttributeValue("", "allowMultiple") != null;
        Log.debug("LocalComponentSession: [ExComp] Starting registration of new external component for domain: " + domain);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version='1.0' encoding='");
        sb.append(CHARSET);
        sb.append("'?>");
        sb.append("<stream:stream ");
        sb.append("xmlns:stream=\"http://etherx.jabber.org/streams\" ");
        sb.append("xmlns=\"jabber:component:accept\" from=\"");
        sb.append(domain);
        sb.append("\">");
        if (domain == null) {
            Log.debug("LocalComponentSession: [ExComp] Domain not specified in stanza: " + xpp.getText());
            StreamError error = new StreamError(StreamError.Condition.bad_format);
            sb.append(error.toXML());
            connection.deliverRawText(sb.toString());
            connection.close();
            return null;
        }
        String subdomain = domain;
        int index = domain.indexOf(serverName);
        if (index > -1) {
            subdomain = domain.substring(0, index - 1);
        }
        domain = subdomain + "." + serverName;
        JID componentJID = new JID(domain);
        if (!ExternalComponentManager.canAccess(subdomain)) {
            Log.debug("LocalComponentSession: [ExComp] Component is not allowed to connect with subdomain: " + subdomain);
            StreamError error = new StreamError(StreamError.Condition.host_unknown);
            sb.append(error.toXML());
            connection.deliverRawText(sb.toString());
            connection.close();
            return null;
        }
        String secretKey = ExternalComponentManager.getSecretForComponent(subdomain);
        if (secretKey == null) {
            Log.debug("LocalComponentSession: [ExComp] A shared secret for the component was not found.");
            StreamError error = new StreamError(StreamError.Condition.internal_server_error);
            sb.append(error.toXML());
            connection.deliverRawText(sb.toString());
            connection.close();
            return null;
        }
        if (!allowMultiple.booleanValue() && InternalComponentManager.getInstance().hasComponent(componentJID)) {
            Log.debug("LocalComponentSession: [ExComp] Another component is already using domain: " + domain);
            StreamError error = new StreamError(StreamError.Condition.conflict);
            sb.append(error.toXML());
            connection.deliverRawText(sb.toString());
            connection.close();
            return null;
        }
        LocalComponentSession session = SessionManager.getInstance().createComponentSession(componentJID, connection);
        session.component = new LocalExternalComponent(session, connection);
        try {
            Log.debug("LocalComponentSession: [ExComp] Send stream header with ID: " + session.getStreamID() + " for component with domain: " + domain);
            sb = new StringBuilder();
            sb.append("<?xml version='1.0' encoding='");
            sb.append(CHARSET);
            sb.append("'?>");
            sb.append("<stream:stream ");
            sb.append("xmlns:stream=\"http://etherx.jabber.org/streams\" ");
            sb.append("xmlns=\"jabber:component:accept\" from=\"");
            sb.append(domain);
            sb.append("\" id=\"");
            sb.append(session.getStreamID().toString());
            sb.append("\">");
            connection.deliverRawText(sb.toString());
            session.defaultSubdomain = subdomain;
            return session;
        }
        catch (Exception e) {
            Log.error("An error occured while creating a ComponentSession", (Throwable)e);
            connection.close();
            return null;
        }
    }

    public LocalComponentSession(String serverName, Connection conn, StreamID id) {
        super(serverName, conn, id, Locale.getDefault());
    }

    @Override
    public String getAvailableStreamFeatures() {
        return null;
    }

    @Override
    boolean canProcess(Packet packet) {
        return true;
    }

    @Override
    void deliver(Packet packet) throws PacketException {
        this.component.deliver(packet);
    }

    @Override
    public ComponentSession.ExternalComponent getExternalComponent() {
        return this.component;
    }

    public boolean authenticate(String digest) {
        String secretKey = ExternalComponentManager.getSecretForComponent(this.defaultSubdomain);
        String anticipatedDigest = AuthFactory.createDigest(this.getStreamID().getID(), secretKey);
        if (!anticipatedDigest.equalsIgnoreCase(digest)) {
            Log.debug("LocalComponentSession: [ExComp] Incorrect handshake for component with domain: " + this.defaultSubdomain);
            this.conn.deliverRawText(new StreamError(StreamError.Condition.not_authorized).toXML());
            this.conn.close();
            return false;
        }
        this.setStatus(3);
        this.conn.deliverRawText("<handshake></handshake>");
        ComponentSession.ExternalComponent component = this.getExternalComponent();
        try {
            InternalComponentManager.getInstance().addComponent(this.defaultSubdomain, component);
            Log.debug("LocalComponentSession: [ExComp] External component was registered SUCCESSFULLY with domain: " + this.defaultSubdomain);
            return true;
        }
        catch (ComponentException e) {
            Log.debug("LocalComponentSession: [ExComp] Another component is already using domain: " + this.defaultSubdomain);
            this.conn.deliverRawText(new StreamError(StreamError.Condition.conflict).toXML());
            this.conn.close();
            return false;
        }
    }

    public static class LocalExternalComponent
    implements ComponentSession.ExternalComponent {
        private static final Map<String, LocalExternalComponent> iqs = new HashMap<String, LocalExternalComponent>();
        private LocalComponentSession session;
        private Connection connection;
        private String name = "";
        private String type = "";
        private String category = "";
        private List<String> subdomains = new ArrayList<String>();

        public LocalExternalComponent(LocalComponentSession session, Connection connection) {
            this.session = session;
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPacket(Packet packet) {
            IQ iq;
            if (packet instanceof IQ && ((iq = (IQ)packet).getType() == IQ.Type.result || iq.getType() == IQ.Type.error)) {
                LocalExternalComponent targetComponent;
                Map<String, LocalExternalComponent> map = iqs;
                synchronized (map) {
                    targetComponent = iqs.remove(packet.getID());
                }
                if (targetComponent != null) {
                    targetComponent.processPacket(packet);
                    return;
                }
            }
            this.session.process(packet);
        }

        void deliver(Packet packet) {
            if (this.connection != null && !this.connection.isClosed()) {
                try {
                    this.connection.deliver(packet);
                }
                catch (Exception e) {
                    Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
                    this.connection.close();
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.category + " - " + this.type;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public void setType(String type) {
            this.type = type;
        }

        @Override
        public String getCategory() {
            return this.category;
        }

        @Override
        public void setCategory(String category) {
            this.category = category;
        }

        @Override
        public String getInitialSubdomain() {
            if (this.subdomains.isEmpty()) {
                return null;
            }
            return this.subdomains.get(0);
        }

        private void addSubdomain(String subdomain) {
            this.subdomains.add(subdomain);
        }

        @Override
        public Collection<String> getSubdomains() {
            return this.subdomains;
        }

        public void initialize(JID jid, ComponentManager componentManager) {
            this.addSubdomain(jid.toString());
        }

        public void start() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Map<String, LocalExternalComponent> map = iqs;
            synchronized (map) {
                ArrayList<String> toRemove = new ArrayList<String>();
                for (Map.Entry<String, LocalExternalComponent> entry : iqs.entrySet()) {
                    if (entry.getValue() != this) continue;
                    toRemove.add(entry.getKey());
                }
                for (String key : toRemove) {
                    iqs.remove(key);
                }
            }
        }

        public String toString() {
            return super.toString() + " - subdomains: " + this.subdomains;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void track(IQ iq) {
            Map<String, LocalExternalComponent> map = iqs;
            synchronized (map) {
                iqs.put(iq.getID(), this);
            }
        }
    }
}

