/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.security;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jivesoftware.openfire.security.AuditWriteOnlyException;
import org.jivesoftware.openfire.security.DefaultSecurityAuditProvider;
import org.jivesoftware.openfire.security.EventNotFoundException;
import org.jivesoftware.openfire.security.SecurityAuditEvent;
import org.jivesoftware.openfire.security.SecurityAuditProvider;
import org.jivesoftware.util.ClassUtils;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityAuditManager {
    private static final Logger Log = LoggerFactory.getLogger(SecurityAuditManager.class);
    private SecurityAuditProvider provider;

    public static SecurityAuditProvider getSecurityAuditProvider() {
        return SecurityAuditManagerContainer.instance.provider;
    }

    public static SecurityAuditManager getInstance() {
        return SecurityAuditManagerContainer.instance;
    }

    private SecurityAuditManager() {
        this.initProvider();
        PropertyEventListener propListener = new PropertyEventListener(){

            public void propertySet(String property, Map params) {
                if ("provider.securityAudit.className".equals(property)) {
                    SecurityAuditManager.this.initProvider();
                }
            }

            public void propertyDeleted(String property, Map params) {
            }

            public void xmlPropertySet(String property, Map params) {
            }

            public void xmlPropertyDeleted(String property, Map params) {
            }
        };
        PropertyEventDispatcher.addListener(propListener);
    }

    private void initProvider() {
        JiveGlobals.migrateProperty("provider.securityAudit.className");
        String className = JiveGlobals.getProperty("provider.securityAudit.className", "org.jivesoftware.openfire.security.DefaultSecurityAuditProvider");
        if (this.provider == null || !className.equals(this.provider.getClass().getName())) {
            try {
                Class c = ClassUtils.forName(className);
                this.provider = (SecurityAuditProvider)c.newInstance();
            }
            catch (Exception e) {
                Log.error("Error loading security audit provider: " + className, (Throwable)e);
                this.provider = new DefaultSecurityAuditProvider();
            }
        }
    }

    public void logEvent(String username, String summary, String details) {
        this.provider.logEvent(username, summary, details);
    }

    public List<SecurityAuditEvent> getEvents(String username, Integer skipEvents, Integer numEvents, Date startTime, Date endTime) throws AuditWriteOnlyException {
        if (this.provider.isWriteOnly()) {
            throw new AuditWriteOnlyException();
        }
        return this.provider.getEvents(username, skipEvents, numEvents, startTime, endTime);
    }

    public SecurityAuditEvent getEvent(Integer msgID) throws EventNotFoundException, AuditWriteOnlyException {
        if (this.provider.isWriteOnly()) {
            throw new AuditWriteOnlyException();
        }
        return this.provider.getEvent(msgID);
    }

    private static class SecurityAuditManagerContainer {
        private static SecurityAuditManager instance = new SecurityAuditManager();

        private SecurityAuditManagerContainer() {
        }
    }
}

