/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.sasl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.StringTokenizer;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.jivesoftware.openfire.sasl.VerifyPasswordCallback;

public class SaslServerPlainImpl
implements SaslServer {
    private String principal;
    private String username;
    private String password;
    private CallbackHandler cbh;
    private boolean completed;
    private boolean aborted;
    private int counter;

    public SaslServerPlainImpl(String protocol, String serverFqdn, Map props, CallbackHandler cbh) throws SaslException {
        this.cbh = cbh;
        this.completed = false;
        this.counter = 0;
    }

    @Override
    public String getMechanismName() {
        return "PLAIN";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("PLAIN authentication already completed");
        }
        if (this.aborted) {
            throw new IllegalStateException("PLAIN authentication previously aborted due to error");
        }
        try {
            AuthorizeCallback acb;
            if (response.length != 0) {
                String data = new String(response, StandardCharsets.UTF_8);
                StringTokenizer tokens = new StringTokenizer(data, "\u0000");
                if (tokens.countTokens() > 2) {
                    this.username = tokens.nextToken();
                    this.principal = tokens.nextToken();
                } else {
                    this.principal = this.username = tokens.nextToken();
                }
                this.password = tokens.nextToken();
                NameCallback ncb = new NameCallback("PLAIN authentication ID: ", this.principal);
                VerifyPasswordCallback vpcb = new VerifyPasswordCallback(this.password.toCharArray());
                this.cbh.handle(new Callback[]{ncb, vpcb});
                if (!vpcb.getVerified()) throw new SaslException("PLAIN: user not authorized: " + this.principal);
                vpcb.clearPassword();
                acb = new AuthorizeCallback(this.principal, this.username);
                this.cbh.handle(new Callback[]{acb});
                if (!acb.isAuthorized()) {
                    this.completed = true;
                    this.username = null;
                    throw new SaslException("PLAIN: user not authorized: " + this.principal);
                }
            } else {
                if (this.counter++ <= 1) return null;
                throw new SaslException("PLAIN expects a response");
            }
            this.username = acb.getAuthorizedID();
            this.completed = true;
            return null;
        }
        catch (IOException | UnsupportedCallbackException e) {
            this.aborted = true;
            throw new SaslException("PLAIN authentication failed for: " + this.username, e);
        }
    }

    @Override
    public boolean isComplete() {
        return this.completed;
    }

    @Override
    public String getAuthorizationID() {
        if (this.completed) {
            return this.username;
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("PLAIN does not support integrity or privacy");
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("PLAIN does not support integrity or privacy");
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (this.completed) {
            if (propName.equals("javax.security.sasl.qop")) {
                return "auth";
            }
            return null;
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    @Override
    public void dispose() throws SaslException {
        this.password = null;
        this.username = null;
        this.principal = null;
        this.completed = false;
    }
}

