/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.sasl;

import java.nio.charset.StandardCharsets;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.jivesoftware.openfire.session.LocalIncomingServerSession;

public class ExternalServerSaslServer
implements SaslServer {
    public static final String NAME = "EXTERNAL";
    private boolean complete = false;
    private String authorizationID = null;
    private LocalIncomingServerSession session;

    public ExternalServerSaslServer(LocalIncomingServerSession session) throws SaslException {
        this.session = session;
    }

    @Override
    public String getMechanismName() {
        return NAME;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        if (this.isComplete()) {
            throw new IllegalStateException("Authentication exchange already completed.");
        }
        if (response == null || response.length == 0) {
            return new byte[0];
        }
        this.complete = true;
        String requestedId = new String(response, StandardCharsets.UTF_8);
        String defaultIdentity = this.session.getDefaultIdentity();
        if (!requestedId.equals(defaultIdentity)) {
            throw new SaslException("From '" + requestedId + "' does not equal authzid '" + defaultIdentity + "'");
        }
        this.authorizationID = requestedId;
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public String getAuthorizationID() {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange not completed.");
        }
        return this.authorizationID;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange not completed.");
        }
        throw new IllegalStateException("SASL Mechanism '" + this.getMechanismName() + " does not support integrity nor privacy.");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange not completed.");
        }
        throw new IllegalStateException("SASL Mechanism '" + this.getMechanismName() + " does not support integrity nor privacy.");
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange not completed.");
        }
        if (propName.equals("javax.security.sasl.qop")) {
            return "auth";
        }
        return null;
    }

    @Override
    public void dispose() throws SaslException {
        this.complete = false;
        this.authorizationID = null;
        this.session = null;
    }
}

