/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.sasl;

import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.auth.AuthorizationManager;
import org.jivesoftware.openfire.keystore.TrustStore;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.util.CertificateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalClientSaslServer
implements SaslServer {
    public static final Logger Log = LoggerFactory.getLogger(ExternalClientSaslServer.class);
    public static final String NAME = "EXTERNAL";
    private boolean complete = false;
    private String authorizationID = null;
    private LocalClientSession session;

    public ExternalClientSaslServer(LocalClientSession session) throws SaslException {
        this.session = session;
    }

    @Override
    public String getMechanismName() {
        return NAME;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        String principal;
        if (this.isComplete()) {
            throw new IllegalStateException("Authentication exchange already completed.");
        }
        this.complete = true;
        Connection connection = this.session.getConnection();
        Certificate[] peerCertificates = connection.getPeerCertificates();
        if (peerCertificates == null || peerCertificates.length < 1) {
            throw new SaslException("No peer certificates.");
        }
        TrustStore trustStore = connection.getConfiguration().getTrustStore();
        X509Certificate trusted = trustStore.getEndEntityCertificate(peerCertificates);
        if (trusted == null) {
            throw new SaslException("Certificate chain of peer is not trusted.");
        }
        ArrayList<String> principals = new ArrayList<String>();
        principals.addAll(CertificateManager.getClientIdentities(trusted));
        switch (principals.size()) {
            case 0: {
                principal = "";
                break;
            }
            default: {
                Log.debug("More than one principal found, using the first one.");
            }
            case 1: {
                principal = (String)principals.get(0);
            }
        }
        String username = response != null && response.length > 0 ? new String(response, StandardCharsets.UTF_8) : null;
        if (username == null || username.length() == 0) {
            for (String princ : principals) {
                String mappedUsername = AuthorizationManager.map(princ);
                if (mappedUsername.equals(princ)) continue;
                username = mappedUsername;
                principal = princ;
                break;
            }
            if (username == null || username.length() == 0) {
                username = principal;
            }
            Log.debug("No username requested, using: {}", (Object)username);
        }
        if (AuthorizationManager.authorize(username, principal)) {
            Log.debug("Principal {} authorized to username {}", (Object)principal, (Object)username);
            this.authorizationID = username;
            return null;
        }
        throw new SaslException();
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public String getAuthorizationID() {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange not completed.");
        }
        return this.authorizationID;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange not completed.");
        }
        throw new IllegalStateException("SASL Mechanism '" + this.getMechanismName() + " does not support integrity nor privacy.");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange not completed.");
        }
        throw new IllegalStateException("SASL Mechanism '" + this.getMechanismName() + " does not support integrity nor privacy.");
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange not completed.");
        }
        if (propName.equals("javax.security.sasl.qop")) {
            return "auth";
        }
        return null;
    }

    @Override
    public void dispose() throws SaslException {
        this.complete = false;
        this.authorizationID = null;
        this.session = null;
    }
}

