/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.sasl;

import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.openfire.session.LocalSession;
import org.jivesoftware.util.JiveGlobals;

public class AnonymousSaslServer
implements SaslServer {
    public static final String NAME = "ANONYMOUS";
    private boolean complete = false;
    private LocalSession session;

    public AnonymousSaslServer(LocalSession session) {
        this.session = session;
    }

    @Override
    public String getMechanismName() {
        return NAME;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        boolean forbidAccess;
        if (this.isComplete()) {
            throw new IllegalStateException("Authentication exchange already completed.");
        }
        this.complete = true;
        if (!JiveGlobals.getBooleanProperty("xmpp.auth.anonymous")) {
            throw new SaslException("Authentication failed");
        }
        boolean bl = forbidAccess = !LocalClientSession.isAllowedAnonymous(this.session.getConnection());
        if (forbidAccess) {
            throw new SaslException("Authentication failed");
        }
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public String getAuthorizationID() {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange not completed.");
        }
        return null;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange not completed.");
        }
        throw new IllegalStateException("SASL Mechanism '" + this.getMechanismName() + " does not support integrity nor privacy.");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange not completed.");
        }
        throw new IllegalStateException("SASL Mechanism '" + this.getMechanismName() + " does not support integrity nor privacy.");
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange not completed.");
        }
        if (propName.equals("javax.security.sasl.qop")) {
            return "auth";
        }
        return null;
    }

    @Override
    public void dispose() throws SaslException {
        this.complete = false;
        this.session = null;
    }
}

