/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.roster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.SharedGroupException;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.event.GroupEventDispatcher;
import org.jivesoftware.openfire.event.GroupEventListener;
import org.jivesoftware.openfire.event.UserEventDispatcher;
import org.jivesoftware.openfire.event.UserEventListener;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.roster.DefaultRosterItemProvider;
import org.jivesoftware.openfire.roster.Roster;
import org.jivesoftware.openfire.roster.RosterEventDispatcher;
import org.jivesoftware.openfire.roster.RosterEventListener;
import org.jivesoftware.openfire.roster.RosterItem;
import org.jivesoftware.openfire.roster.RosterItemProvider;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.ClassUtils;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;

public class RosterManager
extends BasicModule
implements GroupEventListener,
UserEventListener {
    private static final Logger Log = LoggerFactory.getLogger(RosterManager.class);
    private Cache<String, Roster> rosterCache = CacheFactory.createCache("Roster");
    private XMPPServer server;
    private RoutingTable routingTable;
    private RosterItemProvider provider;

    public static boolean isRosterServiceEnabled() {
        return JiveGlobals.getBooleanProperty("xmpp.client.roster.active", true);
    }

    public static boolean isRosterVersioningEnabled() {
        return JiveGlobals.getBooleanProperty("xmpp.client.roster.versioning.active", true);
    }

    public RosterManager() {
        super("Roster Manager");
        this.initProvider();
        PropertyEventDispatcher.addListener(new PropertyEventListener(){

            public void propertySet(String property, Map params) {
                if (property.equals("provider.roster.className")) {
                    RosterManager.this.initProvider();
                }
            }

            public void propertyDeleted(String property, Map params) {
            }

            public void xmlPropertySet(String property, Map params) {
            }

            public void xmlPropertyDeleted(String property, Map params) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Roster getRoster(String username) throws UserNotFoundException {
        Roster roster = (Roster)this.rosterCache.get(username);
        if (roster == null) {
            String string = (username + " ro").intern();
            synchronized (string) {
                roster = (Roster)this.rosterCache.get(username);
                if (roster == null) {
                    roster = new Roster(username);
                    this.rosterCache.put(username, roster);
                }
            }
        }
        return roster;
    }

    public void deleteRoster(JID user) {
        if (!this.server.isLocal(user)) {
            return;
        }
        try {
            String username = user.getNode();
            Roster roster = this.getRoster(username);
            for (RosterItem item : roster.getRosterItems()) {
                try {
                    roster.deleteRosterItem(item.getJid(), false);
                }
                catch (SharedGroupException e) {
                    Log.warn("Unexpected exception while deleting roster of user '{}' .", (Object)user, (Object)e);
                }
            }
            this.rosterCache.remove(username);
            Iterator<String> usernames = this.provider.getUsernames(user.toBareJID());
            while (usernames.hasNext()) {
                username = usernames.next();
                try {
                    roster = this.getRoster(username);
                    roster.deleteRosterItem(user, false);
                }
                catch (SharedGroupException e) {
                    Log.warn("Unexpected exception while deleting roster of user '{}' .", (Object)user, (Object)e);
                }
                catch (UserNotFoundException userNotFoundException) {}
            }
        }
        catch (UnsupportedOperationException | UserNotFoundException exception) {
            // empty catch block
        }
    }

    public Collection<Group> getSharedGroups(String username) {
        HashSet<Group> answer = new HashSet<Group>();
        Collection<Group> groups = GroupManager.getInstance().getSharedGroups(username);
        for (Group group : groups) {
            String showInRoster = (String)group.getProperties().get("sharedRoster.showInRoster");
            if ("onlyGroup".equals(showInRoster)) {
                if (group.isUser(username)) {
                    answer.add(group);
                    continue;
                }
                Collection<Group> groupList = this.parseGroups((String)group.getProperties().get("sharedRoster.groupList"));
                for (Group groupInList : groupList) {
                    if (!groupInList.isUser(username)) continue;
                    answer.add(group);
                }
                continue;
            }
            if (!"everybody".equals(showInRoster)) continue;
            answer.add(group);
        }
        return answer;
    }

    public Collection<Group> getPublicSharedGroups() {
        return GroupManager.getInstance().getPublicSharedGroups();
    }

    private Collection<Group> parseGroups(String groupNames) {
        HashSet<Group> answer = new HashSet<Group>();
        for (String groupName : RosterManager.parseGroupNames(groupNames)) {
            try {
                answer.add(GroupManager.getInstance().getGroup(groupName));
            }
            catch (GroupNotFoundException groupNotFoundException) {}
        }
        return answer;
    }

    private static Collection<String> parseGroupNames(String groupNames) {
        HashSet<String> answer = new HashSet<String>();
        if (groupNames != null) {
            StringTokenizer tokenizer = new StringTokenizer(groupNames, ",");
            while (tokenizer.hasMoreTokens()) {
                answer.add(tokenizer.nextToken());
            }
        }
        return answer;
    }

    @Override
    public void groupCreated(Group group, Map params) {
    }

    @Override
    public void groupDeleting(Group group, Map params) {
        HashSet<JID> users = new HashSet<JID>(group.getMembers());
        users.addAll(group.getAdmins());
        Collection<JID> affectedUsers = this.getAffectedUsers(group);
        for (JID deletedUser : users) {
            this.groupUserDeleted(group, affectedUsers, deletedUser);
        }
    }

    @Override
    public void groupModified(Group group, Map params) {
        block13: {
            String originalValue;
            String keyChanged;
            block14: {
                block12: {
                    if ("propertyDeleted".equals(params.get("type"))) {
                        return;
                    }
                    keyChanged = (String)params.get("propertyKey");
                    originalValue = (String)params.get("originalValue");
                    if (!"sharedRoster.showInRoster".equals(keyChanged)) break block12;
                    String currentValue = (String)group.getProperties().get("sharedRoster.showInRoster");
                    if (currentValue.equals(originalValue)) {
                        return;
                    }
                    HashSet<JID> users = new HashSet<JID>(group.getMembers());
                    users.addAll(group.getAdmins());
                    Collection<JID> affectedUsers = this.getAffectedUsers(group, originalValue, (String)group.getProperties().get("sharedRoster.groupList"));
                    for (JID deletedUser : users) {
                        this.groupUserDeleted(group, affectedUsers, deletedUser);
                    }
                    for (JID user : users) {
                        this.groupUserAdded(group, user);
                    }
                    break block13;
                }
                if (!"sharedRoster.groupList".equals(keyChanged)) break block14;
                String currentValue = (String)group.getProperties().get("sharedRoster.groupList");
                if (currentValue.equals(originalValue)) {
                    return;
                }
                HashSet<JID> users = new HashSet<JID>(group.getMembers());
                users.addAll(group.getAdmins());
                Collection<JID> affectedUsers = this.getAffectedUsers(group, (String)group.getProperties().get("sharedRoster.showInRoster"), originalValue);
                for (JID deletedUser : users) {
                    this.groupUserDeleted(group, affectedUsers, deletedUser);
                }
                for (JID user : users) {
                    this.groupUserAdded(group, user);
                }
                break block13;
            }
            if (!"sharedRoster.displayName".equals(keyChanged)) break block13;
            String currentValue = (String)group.getProperties().get("sharedRoster.displayName");
            if (currentValue.equals(originalValue)) {
                return;
            }
            if (!RosterManager.isSharedGroup(group)) {
                return;
            }
            Collection<JID> users = this.getAffectedUsers(group);
            for (JID updatedUser : users) {
                if (!this.server.isLocal(updatedUser)) continue;
                try {
                    Roster roster = this.getRoster(updatedUser.getNode());
                    roster.shareGroupRenamed(users);
                }
                catch (UserNotFoundException e) {
                    Log.debug("Unexpected exception while applying group modification for user '{}' .", (Object)updatedUser.getNode(), (Object)e);
                }
            }
        }
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.server = server;
        this.routingTable = server.getRoutingTable();
        RosterEventDispatcher.addListener(new RosterEventListener(){

            @Override
            public void rosterLoaded(Roster roster) {
            }

            @Override
            public boolean addingContact(Roster roster, RosterItem item, boolean persistent) {
                return true;
            }

            @Override
            public void contactAdded(Roster roster, RosterItem item) {
                RosterManager.this.rosterCache.put(roster.getUsername(), roster);
            }

            @Override
            public void contactUpdated(Roster roster, RosterItem item) {
                RosterManager.this.rosterCache.put(roster.getUsername(), roster);
            }

            @Override
            public void contactDeleted(Roster roster, RosterItem item) {
                RosterManager.this.rosterCache.put(roster.getUsername(), roster);
            }
        });
    }

    public static boolean isSharedGroup(Group group) {
        String showInRoster = (String)group.getProperties().get("sharedRoster.showInRoster");
        return "onlyGroup".equals(showInRoster) || "everybody".equals(showInRoster);
    }

    public static boolean isPublicSharedGroup(Group group) {
        String showInRoster = (String)group.getProperties().get("sharedRoster.showInRoster");
        return "everybody".equals(showInRoster);
    }

    @Override
    public void memberAdded(Group group, Map params) {
        JID addedUser = new JID((String)params.get("member"));
        if (group.getAdmins().contains(addedUser)) {
            return;
        }
        if (!RosterManager.isSharedGroup(group)) {
            for (Group visibleGroup : this.getVisibleGroups(group)) {
                HashSet<JID> users = new HashSet<JID>(visibleGroup.getMembers());
                users.addAll(visibleGroup.getAdmins());
                this.groupUserAdded(visibleGroup, users, addedUser);
            }
        } else {
            this.groupUserAdded(group, addedUser);
        }
    }

    @Override
    public void memberRemoved(Group group, Map params) {
        String member = (String)params.get("member");
        if (member == null) {
            return;
        }
        JID deletedUser = new JID(member);
        if (group.getAdmins().contains(deletedUser)) {
            return;
        }
        if (!RosterManager.isSharedGroup(group)) {
            for (Group visibleGroup : this.getVisibleGroups(group)) {
                HashSet<JID> users = new HashSet<JID>(visibleGroup.getMembers());
                users.addAll(visibleGroup.getAdmins());
                this.groupUserDeleted(visibleGroup, users, deletedUser);
            }
        } else {
            this.groupUserDeleted(group, deletedUser);
        }
    }

    @Override
    public void adminAdded(Group group, Map params) {
        JID addedUser = new JID((String)params.get("admin"));
        if (group.getMembers().contains(addedUser)) {
            return;
        }
        if (!RosterManager.isSharedGroup(group)) {
            for (Group visibleGroup : this.getVisibleGroups(group)) {
                HashSet<JID> users = new HashSet<JID>(visibleGroup.getMembers());
                users.addAll(visibleGroup.getAdmins());
                this.groupUserAdded(visibleGroup, users, addedUser);
            }
        } else {
            this.groupUserAdded(group, addedUser);
        }
    }

    @Override
    public void adminRemoved(Group group, Map params) {
        JID deletedUser = new JID((String)params.get("admin"));
        if (group.getMembers().contains(deletedUser)) {
            return;
        }
        if (!RosterManager.isSharedGroup(group)) {
            for (Group visibleGroup : this.getVisibleGroups(group)) {
                HashSet<JID> users = new HashSet<JID>(visibleGroup.getMembers());
                users.addAll(visibleGroup.getAdmins());
                this.groupUserDeleted(visibleGroup, users, deletedUser);
            }
        } else {
            this.groupUserDeleted(group, deletedUser);
        }
    }

    @Override
    public void userCreated(User newUser, Map<String, Object> params) {
        JID newUserJID = this.server.createJID(newUser.getUsername(), null);
        for (Group group : this.getPublicSharedGroups()) {
            HashSet<JID> users = new HashSet<JID>(group.getMembers());
            users.addAll(group.getAdmins());
            for (JID userToUpdate : users) {
                Roster roster = null;
                if (this.server.isLocal(userToUpdate)) {
                    try {
                        roster = this.getRoster(userToUpdate.getNode());
                    }
                    catch (UserNotFoundException e) {
                        continue;
                    }
                }
                roster.addSharedUser(group, newUserJID);
                if (this.server.isLocal(userToUpdate)) continue;
                this.sendSubscribeRequest(newUserJID, userToUpdate, true);
            }
        }
    }

    @Override
    public void userDeleting(User user, Map<String, Object> params) {
        JID userJID = this.server.createJID(user.getUsername(), null);
        for (Group group : this.getPublicSharedGroups()) {
            HashSet<JID> users = new HashSet<JID>(group.getMembers());
            users.addAll(group.getAdmins());
            for (JID userToUpdate : users) {
                Roster roster = null;
                if (this.server.isLocal(userToUpdate)) {
                    try {
                        roster = this.getRoster(userToUpdate.getNode());
                    }
                    catch (UserNotFoundException e) {
                        continue;
                    }
                }
                roster.deleteSharedUser(group, userJID);
                if (this.server.isLocal(userToUpdate)) continue;
                this.sendSubscribeRequest(userJID, userToUpdate, false);
            }
        }
        this.deleteRoster(userJID);
    }

    @Override
    public void userModified(User user, Map<String, Object> params) {
        if ("nameModified".equals(params.get("type"))) {
            for (Group group : this.getSharedGroups(user.getUsername())) {
                ArrayList<JID> groupUsers = new ArrayList<JID>();
                groupUsers.addAll(group.getAdmins());
                groupUsers.addAll(group.getMembers());
                for (JID groupUser : groupUsers) {
                    this.rosterCache.remove(groupUser.getNode());
                }
            }
        }
    }

    private void groupUserAdded(Group group, JID addedUser) {
        this.groupUserAdded(group, this.getAffectedUsers(group), addedUser);
    }

    private void groupUserAdded(Group group, Collection<JID> users, JID addedUser) {
        Roster addedUserRoster = null;
        if (this.server.isLocal(addedUser)) {
            try {
                addedUserRoster = this.getRoster(addedUser.getNode());
            }
            catch (UserNotFoundException e) {
                Log.warn("Unexpected exception while adding user '{}' to group '{}'.", new Object[]{addedUser, group, e});
            }
        }
        for (JID userToUpdate : users) {
            if (addedUser.equals((Object)userToUpdate)) continue;
            Roster roster = null;
            if (this.server.isLocal(userToUpdate)) {
                try {
                    roster = this.getRoster(userToUpdate.getNode());
                }
                catch (UserNotFoundException e) {
                    continue;
                }
            }
            roster.addSharedUser(group, addedUser);
            if (addedUserRoster == null && this.server.isLocal(addedUser)) {
                try {
                    addedUserRoster = this.getRoster(addedUser.getNode());
                }
                catch (UserNotFoundException e) {
                    Log.warn("Unexpected exception while adding user '{}' to group '{}'.", new Object[]{addedUser, group, e});
                }
            }
            if (addedUserRoster != null) {
                Collection<Group> groups = GroupManager.getInstance().getGroups(userToUpdate);
                addedUserRoster.addSharedUser(userToUpdate, groups, group);
            }
            if (!this.server.isLocal(addedUser)) {
                this.sendSubscribeRequest(userToUpdate, addedUser, true);
            }
            if (this.server.isLocal(userToUpdate)) continue;
            this.sendSubscribeRequest(addedUser, userToUpdate, true);
        }
    }

    private void groupUserDeleted(Group group, JID deletedUser) {
        this.groupUserDeleted(group, this.getAffectedUsers(group), deletedUser);
    }

    private void groupUserDeleted(Group group, Collection<JID> users, JID deletedUser) {
        Roster deletedUserRoster = null;
        if (this.server.isLocal(deletedUser)) {
            try {
                deletedUserRoster = this.getRoster(deletedUser.getNode());
            }
            catch (UserNotFoundException e) {
                Log.warn("Unexpected exception while deleting user '{}' from group '{}'.", new Object[]{deletedUser, group, e});
            }
        }
        for (JID userToUpdate : users) {
            Roster roster = null;
            if (this.server.isLocal(userToUpdate)) {
                try {
                    roster = this.getRoster(userToUpdate.getNode());
                }
                catch (UserNotFoundException e) {
                    continue;
                }
            }
            roster.deleteSharedUser(group, deletedUser);
            if (deletedUserRoster != null) {
                deletedUserRoster.deleteSharedUser(userToUpdate, group);
            }
            if (!this.server.isLocal(deletedUser)) {
                this.sendSubscribeRequest(userToUpdate, deletedUser, false);
            }
            if (this.server.isLocal(userToUpdate)) continue;
            this.sendSubscribeRequest(deletedUser, userToUpdate, false);
        }
    }

    private void sendSubscribeRequest(JID sender, JID recipient, boolean isSubscribe) {
        Presence presence = new Presence();
        presence.setFrom(sender);
        presence.setTo(recipient);
        if (isSubscribe) {
            presence.setType(Presence.Type.subscribe);
        } else {
            presence.setType(Presence.Type.unsubscribe);
        }
        this.routingTable.routePacket(recipient, (Packet)presence, false);
    }

    private Collection<Group> getVisibleGroups(Group groupToCheck) {
        return GroupManager.getInstance().getVisibleGroups(groupToCheck);
    }

    public boolean isGroupVisible(Group group, JID user) {
        String showInRoster = (String)group.getProperties().get("sharedRoster.showInRoster");
        if ("everybody".equals(showInRoster)) {
            return true;
        }
        if ("onlyGroup".equals(showInRoster)) {
            if (group.isUser(user)) {
                return true;
            }
            Collection<Group> groupList = this.parseGroups((String)group.getProperties().get("sharedRoster.groupList"));
            for (Group groupInList : groupList) {
                if (!groupInList.isUser(user)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<JID> getAffectedUsers(Group group) {
        return this.getAffectedUsers(group, (String)group.getProperties().get("sharedRoster.showInRoster"), (String)group.getProperties().get("sharedRoster.groupList"));
    }

    private Collection<JID> getAffectedUsers(Group group, String showInRoster, String groupNames) {
        if (!"onlyGroup".equals(showInRoster) && !"everybody".equals(showInRoster)) {
            return new ArrayList<JID>();
        }
        HashSet<JID> users = new HashSet<JID>(group.getMembers());
        users.addAll(group.getAdmins());
        if ("everybody".equals(showInRoster)) {
            for (String username : UserManager.getInstance().getUsernames()) {
                users.add(this.server.createJID(username, null, true));
            }
        } else {
            Collection<Group> groupList = this.parseGroups(groupNames);
            for (Group groupInList : groupList) {
                users.addAll(groupInList.getMembers());
                users.addAll(groupInList.getAdmins());
            }
        }
        return users;
    }

    Collection<JID> getSharedUsersForRoster(Group group, Roster roster) {
        HashSet<JID> users;
        block5: {
            String showInRoster = (String)group.getProperties().get("sharedRoster.showInRoster");
            String groupNames = (String)group.getProperties().get("sharedRoster.groupList");
            if (!"onlyGroup".equals(showInRoster) && !"everybody".equals(showInRoster)) {
                return new ArrayList<JID>();
            }
            users = new HashSet<JID>(group.getMembers());
            users.addAll(group.getAdmins());
            if (!group.isUser(roster.getUsername())) break block5;
            if ("everybody".equals(showInRoster)) {
                for (String username : UserManager.getInstance().getUsernames()) {
                    users.add(this.server.createJID(username, null, true));
                }
            } else {
                Collection<Group> groupList = this.parseGroups(groupNames);
                for (Group groupInList : groupList) {
                    users.addAll(groupInList.getMembers());
                    users.addAll(groupInList.getAdmins());
                }
            }
        }
        return users;
    }

    boolean hasMutualVisibility(String user, Collection<Group> groups, JID otherUser, Collection<Group> otherGroups) {
        for (Group group : groups) {
            for (Group otherGroup : otherGroups) {
                String otherGroupNames;
                String groupNames;
                if (!group.isUser(user) || !otherGroup.isUser(otherUser)) continue;
                if (group.equals(otherGroup)) {
                    return true;
                }
                String showInRoster = (String)group.getProperties().get("sharedRoster.showInRoster");
                String otherShowInRoster = (String)otherGroup.getProperties().get("sharedRoster.showInRoster");
                if ("everybody".equals(showInRoster) && "everybody".equals(otherShowInRoster)) {
                    return true;
                }
                if ("onlyGroup".equals(showInRoster) && "onlyGroup".equals(otherShowInRoster)) {
                    groupNames = (String)group.getProperties().get("sharedRoster.groupList");
                    String otherGroupNames2 = (String)otherGroup.getProperties().get("sharedRoster.groupList");
                    if (groupNames == null || otherGroupNames2 == null) continue;
                    if (groupNames.contains(otherGroup.getName()) && otherGroupNames2.contains(group.getName())) {
                        return true;
                    }
                    Collection<Group> groupList = this.parseGroups(groupNames);
                    Collection<Group> otherGroupList = this.parseGroups(otherGroupNames2);
                    for (Group groupName : groupList) {
                        if (!groupName.isUser(otherUser)) continue;
                        for (Group otherGroupName : otherGroupList) {
                            if (!otherGroupName.isUser(user)) continue;
                            return true;
                        }
                    }
                    continue;
                }
                if (!("everybody".equals(showInRoster) && "onlyGroup".equals(otherShowInRoster) ? (otherGroupNames = (String)otherGroup.getProperties().get("sharedRoster.groupList")) != null && otherGroupNames.contains(group.getName()) : "onlyGroup".equals(showInRoster) && "everybody".equals(otherShowInRoster) && (groupNames = (String)group.getProperties().get("sharedRoster.groupList")) != null && groupNames.contains(otherGroup.getName()))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void start() throws IllegalStateException {
        super.start();
        UserEventDispatcher.addListener(this);
        GroupEventDispatcher.addListener(this);
    }

    @Override
    public void stop() {
        super.stop();
        UserEventDispatcher.removeListener(this);
        GroupEventDispatcher.removeListener(this);
    }

    public static RosterItemProvider getRosterItemProvider() {
        return XMPPServer.getInstance().getRosterManager().provider;
    }

    private void initProvider() {
        JiveGlobals.migrateProperty("provider.roster.className");
        String className = JiveGlobals.getProperty("provider.roster.className", "org.jivesoftware.openfire.roster.DefaultRosterItemProvider");
        if (this.provider == null || !className.equals(this.provider.getClass().getName())) {
            try {
                Class c = ClassUtils.forName(className);
                this.provider = (RosterItemProvider)c.newInstance();
            }
            catch (Exception e) {
                Log.error("Error loading roster provider: " + className, (Throwable)e);
                this.provider = new DefaultRosterItemProvider();
            }
        }
    }
}

