/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.roster;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jivesoftware.database.JiveID;
import org.jivesoftware.openfire.PresenceManager;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.SharedGroupException;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.privacy.PrivacyList;
import org.jivesoftware.openfire.privacy.PrivacyListManager;
import org.jivesoftware.openfire.roster.RosterEventDispatcher;
import org.jivesoftware.openfire.roster.RosterItem;
import org.jivesoftware.openfire.roster.RosterManager;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserNameManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.cache.CacheSizes;
import org.jivesoftware.util.cache.Cacheable;
import org.jivesoftware.util.cache.CannotCalculateSizeException;
import org.jivesoftware.util.cache.ExternalizableUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;
import org.xmpp.packet.Roster;

@JiveID(value=18)
public class Roster
implements Cacheable,
Externalizable {
    private static final Logger Log = LoggerFactory.getLogger(Roster.class);
    protected ConcurrentMap<String, RosterItem> rosterItems = new ConcurrentHashMap<String, RosterItem>();
    protected ConcurrentMap<String, Set<String>> implicitFrom = new ConcurrentHashMap<String, Set<String>>();
    private String username;

    public Roster() {
    }

    Roster(String username) {
        RosterManager rosterManager = XMPPServer.getInstance().getRosterManager();
        this.username = username;
        Collection<Group> sharedGroups = rosterManager.getSharedGroups(username);
        Iterator<RosterItem> items = RosterManager.getRosterItemProvider().getItems(username);
        while (items.hasNext()) {
            RosterItem item = items.next();
            for (Group group : sharedGroups) {
                if (!group.isUser(item.getJid())) continue;
                item.addSharedGroup(group);
                item.setSubStatus(RosterItem.SUB_BOTH);
            }
            this.rosterItems.put(item.getJid().toBareJID(), item);
        }
        Map<JID, List<Group>> sharedUsers = this.getSharedUsers(sharedGroups);
        for (Map.Entry entry : sharedUsers.entrySet()) {
            JID jid = (JID)entry.getKey();
            List groups = (List)entry.getValue();
            try {
                ArrayList<Group> itemGroups = new ArrayList<Group>();
                String nickname = "";
                RosterItem item = new RosterItem(jid, RosterItem.SUB_TO, RosterItem.ASK_NONE, RosterItem.RECV_NONE, nickname, null);
                for (Group group : groups) {
                    if (group.isUser(jid)) {
                        item.addSharedGroup(group);
                        itemGroups.add(group);
                        continue;
                    }
                    item.addInvisibleSharedGroup(group);
                }
                if (rosterManager.hasMutualVisibility(username, sharedGroups, jid, itemGroups)) {
                    item.setSubStatus(RosterItem.SUB_BOTH);
                } else {
                    boolean belongsToGroup = false;
                    for (Group group : groups) {
                        if (!group.isUser(jid)) continue;
                        belongsToGroup = true;
                    }
                    if (!belongsToGroup) {
                        item.setSubStatus(RosterItem.SUB_FROM);
                    }
                }
                if (item.getSubStatus() != RosterItem.SUB_FROM) {
                    item.setNickname(UserNameManager.getUserName(jid));
                    this.rosterItems.put(item.getJid().toBareJID(), item);
                    continue;
                }
                this.implicitFrom.put(item.getJid().toBareJID(), item.getInvisibleSharedGroupsNames());
            }
            catch (UserNotFoundException e) {
                Log.error("Groups (" + groups + ") include non-existent username (" + jid.getNode() + ")");
            }
        }
        RosterEventDispatcher.rosterLoaded(this);
    }

    public boolean isRosterItem(JID user) {
        return this.rosterItems.containsKey(user.toBareJID()) || this.getImplicitRosterItem(user) != null;
    }

    public Collection<RosterItem> getRosterItems() {
        return Collections.unmodifiableCollection(this.rosterItems.values());
    }

    public RosterItem getRosterItem(JID user) throws UserNotFoundException {
        RosterItem item = (RosterItem)this.rosterItems.get(user.toBareJID());
        if (item == null && (item = this.getImplicitRosterItem(user)) == null) {
            throw new UserNotFoundException(user.toBareJID());
        }
        return item;
    }

    private RosterItem getImplicitRosterItem(JID user) {
        Set invisibleSharedGroups = (Set)this.implicitFrom.get(user.toBareJID());
        if (invisibleSharedGroups != null) {
            RosterItem rosterItem = new RosterItem(user, RosterItem.SUB_FROM, RosterItem.ASK_NONE, RosterItem.RECV_NONE, "", null);
            rosterItem.setInvisibleSharedGroupsNames(invisibleSharedGroups);
            return rosterItem;
        }
        return null;
    }

    public RosterItem createRosterItem(JID user, boolean push, boolean persistent) throws UserAlreadyExistsException, SharedGroupException {
        return this.createRosterItem(user, null, null, push, persistent);
    }

    public RosterItem createRosterItem(JID user, String nickname, List<String> groups, boolean push, boolean persistent) throws UserAlreadyExistsException, SharedGroupException {
        return this.provideRosterItem(user, nickname, groups, push, persistent);
    }

    public void createRosterItem(Roster.Item item) throws UserAlreadyExistsException, SharedGroupException {
        this.provideRosterItem(item.getJID(), item.getName(), new ArrayList<String>(item.getGroups()), true, true);
    }

    protected RosterItem provideRosterItem(JID user, String nickname, List<String> groups, boolean push, boolean persistent) throws UserAlreadyExistsException, SharedGroupException {
        if (groups != null && !groups.isEmpty()) {
            for (String groupDisplayName : groups) {
                Collection<Group> groupsWithProp = GroupManager.getInstance().search("sharedRoster.displayName", groupDisplayName);
                for (Group group : groupsWithProp) {
                    String showInRoster = (String)group.getProperties().get("sharedRoster.showInRoster");
                    if (showInRoster == null || showInRoster.equals("nobody")) continue;
                    throw new SharedGroupException("Cannot add an item to a shared group");
                }
            }
        }
        org.xmpp.packet.Roster roster = new org.xmpp.packet.Roster();
        roster.setType(IQ.Type.set);
        Roster.Item item = roster.addItem(user, nickname, null, Roster.Subscription.none, groups);
        RosterItem rosterItem = new RosterItem(item);
        persistent = RosterEventDispatcher.addingContact(this, rosterItem, persistent);
        if (persistent) {
            rosterItem = RosterManager.getRosterItemProvider().createItem(this.username, rosterItem);
        }
        if (push) {
            this.broadcast(roster);
        }
        this.rosterItems.put(user.toBareJID(), rosterItem);
        RosterEventDispatcher.contactAdded(this, rosterItem);
        return rosterItem;
    }

    public void updateRosterItem(RosterItem item) throws UserNotFoundException {
        if (this.implicitFrom.remove(item.getJid().toBareJID()) != null) {
            this.rosterItems.put(item.getJid().toBareJID(), item);
            RosterEventDispatcher.contactUpdated(this, item);
        }
        if (this.rosterItems.putIfAbsent(item.getJid().toBareJID(), item) == null) {
            this.rosterItems.remove(item.getJid().toBareJID());
            if (item.getSubStatus() != RosterItem.SUB_NONE) {
                throw new UserNotFoundException(item.getJid().toBareJID());
            }
            return;
        }
        if (item.getID() == 0L) {
            if (item.isShared()) {
                if (item.isOnlyShared()) {
                    String defaultContactName;
                    try {
                        defaultContactName = UserNameManager.getUserName(item.getJid());
                    }
                    catch (UserNotFoundException e) {
                        defaultContactName = item.getNickname();
                    }
                    if (defaultContactName.equals(item.getNickname())) {
                        return;
                    }
                }
                try {
                    RosterManager.getRosterItemProvider().createItem(this.username, item);
                }
                catch (UserAlreadyExistsException e) {
                    Log.warn("Unexpected error while updating roster item for user '{}'!", (Object)this.username, (Object)e);
                }
            }
        } else {
            RosterManager.getRosterItemProvider().updateItem(this.username, item);
        }
        if (item.getSubStatus() != RosterItem.SUB_NONE || item.getRecvStatus() != RosterItem.RECV_SUBSCRIBE && !Roster.isSubscriptionRejected(item)) {
            this.broadcast(item, true);
        }
        RosterEventDispatcher.contactUpdated(this, item);
    }

    private static boolean isSubscriptionRejected(RosterItem item) {
        return item.getSubStatus() == RosterItem.SUB_NONE && item.getRecvStatus() == RosterItem.RECV_NONE && item.getAskStatus() == RosterItem.AskType.NONE;
    }

    public RosterItem deleteRosterItem(JID user, boolean doChecking) throws SharedGroupException {
        RosterItem itemToRemove = (RosterItem)this.rosterItems.get(user.toBareJID());
        if (doChecking && itemToRemove != null && !itemToRemove.getSharedGroups().isEmpty()) {
            throw new SharedGroupException("Cannot remove contact that belongs to a shared group");
        }
        if (itemToRemove != null) {
            RosterItem item;
            Presence presence;
            RosterItem.SubType subType = itemToRemove.getSubStatus();
            if (subType == RosterItem.SUB_TO || subType == RosterItem.SUB_BOTH) {
                presence = new Presence();
                presence.setFrom(XMPPServer.getInstance().createJID(this.username, null));
                presence.setTo(itemToRemove.getJid());
                presence.setType(Presence.Type.unsubscribe);
                XMPPServer.getInstance().getPacketRouter().route(presence);
            }
            if (subType == RosterItem.SUB_FROM || subType == RosterItem.SUB_BOTH) {
                presence = new Presence();
                presence.setFrom(XMPPServer.getInstance().createJID(this.username, null));
                presence.setTo(itemToRemove.getJid());
                presence.setType(Presence.Type.unsubscribed);
                XMPPServer.getInstance().getPacketRouter().route(presence);
            }
            if ((item = (RosterItem)this.rosterItems.remove(user.toBareJID())) != null) {
                if (item.getID() > 0L) {
                    RosterManager.getRosterItemProvider().deleteItem(this.username, item.getID());
                }
                org.xmpp.packet.Roster roster = new org.xmpp.packet.Roster();
                roster.setType(IQ.Type.set);
                roster.addItem(user, Roster.Subscription.remove);
                this.broadcast(roster);
                RosterEventDispatcher.contactDeleted(this, item);
            }
            return item;
        }
        RosterItem item = this.getImplicitRosterItem(user);
        if (item != null) {
            this.implicitFrom.remove(user.toBareJID());
            if (!XMPPServer.getInstance().isLocal(user)) {
                Presence presence = new Presence();
                presence.setFrom(XMPPServer.getInstance().createJID(this.username, null));
                presence.setTo(user);
                presence.setType(Presence.Type.unsubscribed);
                XMPPServer.getInstance().getPacketRouter().route(presence);
            }
            RosterEventDispatcher.contactDeleted(this, item);
        }
        return null;
    }

    public String getUsername() {
        return this.username;
    }

    public org.xmpp.packet.Roster getReset() {
        org.xmpp.packet.Roster roster = new org.xmpp.packet.Roster();
        for (RosterItem item : this.rosterItems.values()) {
            if (item.isOnlyShared() && item.getSubStatus() == RosterItem.SUB_FROM) continue;
            Roster.Ask ask = this.getAskStatus(item.getAskStatus());
            Roster.Subscription sub = Roster.Subscription.valueOf((String)item.getSubStatus().getName());
            ArrayList<String> groups = new ArrayList<String>(item.getGroups());
            if (groups.contains(null)) {
                Log.warn("A group is null in roster item: " + item.getJid() + " of user: " + this.getUsername());
            }
            for (Group sharedGroup : item.getSharedGroups()) {
                String displayName = (String)sharedGroup.getProperties().get("sharedRoster.displayName");
                if (displayName != null) {
                    groups.add(displayName);
                    continue;
                }
                Log.warn("Found shared group: " + sharedGroup.getName() + " with no displayName");
            }
            if (item.getSubStatus() == RosterItem.SUB_NONE && (item.getRecvStatus() == RosterItem.RECV_SUBSCRIBE || Roster.isSubscriptionRejected(item))) continue;
            roster.addItem(item.getJid(), item.getNickname(), ask, sub, groups);
        }
        return roster;
    }

    private Roster.Ask getAskStatus(RosterItem.AskType askType) {
        if (askType == null || askType == RosterItem.AskType.NONE) {
            return null;
        }
        return Roster.Ask.valueOf((String)askType.name().toLowerCase());
    }

    public void broadcastPresence(Presence packet) {
        ClientSession session;
        RoutingTable routingTable = XMPPServer.getInstance().getRoutingTable();
        if (routingTable == null) {
            return;
        }
        PrivacyList list = null;
        JID from = packet.getFrom();
        if (from != null && (session = SessionManager.getInstance().getSession(from)) != null) {
            list = session.getActiveList();
            PrivacyList privacyList = list = list == null ? session.getDefaultList() : list;
        }
        if (list == null) {
            list = PrivacyListManager.getInstance().getDefaultPrivacyList(this.username);
        }
        for (RosterItem item : this.rosterItems.values()) {
            if (item.getSubStatus() != RosterItem.SUB_BOTH && item.getSubStatus() != RosterItem.SUB_FROM) continue;
            packet.setTo(item.getJid());
            if (list != null && list.shouldBlockPacket((Packet)packet)) continue;
            JID searchNode = new JID(item.getJid().getNode(), item.getJid().getDomain(), null, true);
            for (JID jid : routingTable.getRoutes(searchNode, null)) {
                try {
                    routingTable.routePacket(jid, (Packet)packet, false);
                }
                catch (Exception e) {
                    Log.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        for (String contact : this.implicitFrom.keySet()) {
            if (contact.contains("@")) {
                String node = contact.substring(0, contact.lastIndexOf("@"));
                String domain = contact.substring(contact.lastIndexOf("@") + 1);
                node = JID.escapeNode((String)node);
                contact = new JID(node, domain, null).toBareJID();
            }
            packet.setTo(contact);
            if (list != null && list.shouldBlockPacket((Packet)packet)) continue;
            for (JID jid : routingTable.getRoutes(new JID(contact), null)) {
                try {
                    routingTable.routePacket(jid, (Packet)packet, false);
                }
                catch (Exception e) {
                    Log.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (from != null) {
            SessionManager.getInstance().broadcastPresenceToOtherResources(from, packet);
        }
    }

    private Map<JID, List<Group>> getSharedUsers(Collection<Group> sharedGroups) {
        RosterManager rosterManager = XMPPServer.getInstance().getRosterManager();
        HashMap<JID, List<Group>> sharedGroupUsers = new HashMap<JID, List<Group>>();
        for (Group group : sharedGroups) {
            Collection<JID> users = rosterManager.getSharedUsersForRoster(group, this);
            JID userJID = this.getUserJID();
            for (JID jid : users) {
                boolean isRosterItem = this.rosterItems.containsKey(jid.toBareJID());
                if (isRosterItem || userJID.equals((Object)jid)) continue;
                ArrayList<Group> groups = (ArrayList<Group>)sharedGroupUsers.get(jid);
                if (groups == null) {
                    groups = new ArrayList<Group>();
                    sharedGroupUsers.put(jid, groups);
                }
                groups.add(group);
            }
        }
        return sharedGroupUsers;
    }

    private void broadcast(org.xmpp.packet.Roster roster) {
        JID recipient = XMPPServer.getInstance().createJID(this.username, null, true);
        roster.setTo(recipient);
        if (RosterManager.isRosterVersioningEnabled()) {
            roster.getChildElement().addAttribute("ver", String.valueOf(roster.hashCode()));
        }
        SessionManager.getInstance().userBroadcast(this.username, (Packet)roster);
    }

    public void broadcast(RosterItem item, boolean optimize) {
        if (optimize && item.isOnlyShared() && item.getSubStatus() == RosterItem.SUB_FROM) {
            return;
        }
        ArrayList<String> groups = new ArrayList<String>(item.getGroups());
        for (Group sharedGroup : item.getSharedGroups()) {
            String displayName = (String)sharedGroup.getProperties().get("sharedRoster.displayName");
            if (displayName == null) continue;
            groups.add(displayName);
        }
        org.xmpp.packet.Roster roster = new org.xmpp.packet.Roster();
        roster.setType(IQ.Type.set);
        roster.addItem(item.getJid(), item.getNickname(), this.getAskStatus(item.getAskStatus()), Roster.Subscription.valueOf((String)item.getSubStatus().getName()), groups);
        this.broadcast(roster);
    }

    private void probePresence(JID probee) {
        PresenceManager presenceManager = XMPPServer.getInstance().getPresenceManager();
        for (ClientSession session : SessionManager.getInstance().getSessions(this.username)) {
            presenceManager.probePresence(session.getAddress(), probee);
        }
    }

    @Override
    public int getCachedSize() throws CannotCalculateSizeException {
        int size = 0;
        size += CacheSizes.sizeOfObject();
        size += CacheSizes.sizeOfCollection(this.rosterItems.values());
        size += CacheSizes.sizeOfString(this.username);
        for (Map.Entry entry : this.implicitFrom.entrySet()) {
            size += CacheSizes.sizeOfString((String)entry.getKey());
            size += CacheSizes.sizeOfCollection((Collection)entry.getValue());
        }
        return size;
    }

    void addSharedUser(Group group, JID addedUser) {
        boolean newItem;
        RosterItem item;
        try {
            item = this.getRosterItem(addedUser);
            if (item.getSharedGroups().contains(group)) {
                return;
            }
            newItem = false;
        }
        catch (UserNotFoundException e) {
            try {
                String nickname = UserNameManager.getUserName(addedUser);
                item = new RosterItem(addedUser, RosterItem.SUB_BOTH, RosterItem.ASK_NONE, RosterItem.RECV_NONE, nickname, null);
                this.rosterItems.put(item.getJid().toBareJID(), item);
                newItem = true;
            }
            catch (UserNotFoundException ex) {
                Log.error("Group (" + group.getName() + ") includes non-existent username (" + addedUser + ")");
                return;
            }
        }
        RosterItem.SubType prevSubscription = null;
        if (!newItem) {
            prevSubscription = item.getSubStatus();
        }
        Collection<Group> userGroups = GroupManager.getInstance().getGroups(this.getUserJID());
        ArrayList<Group> sharedGroups = new ArrayList<Group>();
        sharedGroups.addAll(item.getSharedGroups());
        sharedGroups.add(group);
        RosterManager rosterManager = XMPPServer.getInstance().getRosterManager();
        if (rosterManager.hasMutualVisibility(this.getUsername(), userGroups, addedUser, sharedGroups)) {
            item.setSubStatus(RosterItem.SUB_BOTH);
        } else if (group.isUser(addedUser) && !group.isUser(this.getUsername())) {
            item.setSubStatus(RosterItem.SUB_TO);
        } else if (!group.isUser(addedUser) && group.isUser(this.getUsername())) {
            item.setSubStatus(RosterItem.SUB_FROM);
        }
        if (item.getSubStatus() != RosterItem.SUB_FROM) {
            item.addSharedGroup(group);
        } else {
            item.addInvisibleSharedGroup(group);
        }
        if (prevSubscription != null) {
            if (prevSubscription == RosterItem.SUB_TO && item.getSubStatus() == RosterItem.SUB_FROM) {
                item.setSubStatus(RosterItem.SUB_BOTH);
            } else if (prevSubscription == RosterItem.SUB_FROM && item.getSubStatus() == RosterItem.SUB_TO) {
                item.setSubStatus(RosterItem.SUB_BOTH);
            }
        }
        if (item.isOnlyShared() && item.getSubStatus() == RosterItem.SUB_FROM) {
            this.rosterItems.remove(item.getJid().toBareJID());
            this.implicitFrom.put(item.getJid().toBareJID(), item.getInvisibleSharedGroupsNames());
        } else {
            this.implicitFrom.remove(item.getJid().toBareJID());
            this.rosterItems.put(item.getJid().toBareJID(), item);
            this.broadcast(item, true);
            if (item.getSubStatus() == RosterItem.SUB_BOTH || item.getSubStatus() == RosterItem.SUB_TO) {
                this.probePresence(item.getJid());
            }
        }
        if (newItem) {
            RosterEventDispatcher.contactAdded(this, item);
        } else {
            RosterEventDispatcher.contactUpdated(this, item);
        }
    }

    void addSharedUser(JID addedUser, Collection<Group> groups, Group addedGroup) {
        boolean newItem;
        RosterItem item;
        try {
            item = this.getRosterItem(addedUser);
            newItem = false;
        }
        catch (UserNotFoundException e) {
            try {
                String nickname = UserNameManager.getUserName(addedUser);
                item = new RosterItem(addedUser, RosterItem.SUB_BOTH, RosterItem.ASK_NONE, RosterItem.RECV_NONE, nickname, null);
                this.rosterItems.put(item.getJid().toBareJID(), item);
                newItem = true;
            }
            catch (UserNotFoundException ex) {
                Log.error("Couldn't find a user with username (" + addedUser + ")");
                return;
            }
        }
        Collection<Group> userGroups = GroupManager.getInstance().getGroups(this.getUserJID());
        RosterManager rosterManager = XMPPServer.getInstance().getRosterManager();
        if (rosterManager.hasMutualVisibility(this.getUsername(), userGroups, addedUser, groups)) {
            item.setSubStatus(RosterItem.SUB_BOTH);
            for (Group group : groups) {
                if (!rosterManager.isGroupVisible(group, this.getUserJID())) continue;
                item.addSharedGroup(group);
            }
            for (Group group : userGroups) {
                if (group.isUser(addedUser) || !rosterManager.isGroupVisible(group, addedUser)) continue;
                item.addInvisibleSharedGroup(group);
            }
        } else {
            RosterItem.SubType prevSubscription = null;
            if (!newItem) {
                prevSubscription = item.getSubStatus();
            }
            item.setSubStatus(RosterItem.SUB_FROM);
            for (Group group : groups) {
                if (!rosterManager.isGroupVisible(group, this.getUserJID())) continue;
                item.addSharedGroup(group);
                item.setSubStatus(RosterItem.SUB_TO);
            }
            if (item.getSubStatus() == RosterItem.SUB_FROM) {
                item.addInvisibleSharedGroup(addedGroup);
            }
            if (prevSubscription != null) {
                if (prevSubscription == RosterItem.SUB_TO && item.getSubStatus() == RosterItem.SUB_FROM) {
                    item.setSubStatus(RosterItem.SUB_BOTH);
                } else if (prevSubscription == RosterItem.SUB_FROM && item.getSubStatus() == RosterItem.SUB_TO) {
                    item.setSubStatus(RosterItem.SUB_BOTH);
                }
            }
        }
        if (item.isOnlyShared() && item.getSubStatus() == RosterItem.SUB_FROM) {
            this.rosterItems.remove(item.getJid().toBareJID());
            this.implicitFrom.put(item.getJid().toBareJID(), item.getInvisibleSharedGroupsNames());
        } else {
            this.implicitFrom.remove(item.getJid().toBareJID());
            this.rosterItems.put(item.getJid().toBareJID(), item);
            this.broadcast(item, true);
            if (item.getSubStatus() == RosterItem.SUB_BOTH || item.getSubStatus() == RosterItem.SUB_TO) {
                this.probePresence(item.getJid());
            }
        }
        if (newItem) {
            RosterEventDispatcher.contactAdded(this, item);
        } else {
            RosterEventDispatcher.contactUpdated(this, item);
        }
    }

    void deleteSharedUser(Group sharedGroup, JID deletedUser) {
        try {
            RosterItem item = this.getRosterItem(deletedUser);
            int groupSize = item.getSharedGroups().size() + item.getInvisibleSharedGroups().size();
            if (item.isOnlyShared() && groupSize == 1) {
                if (!item.getSharedGroups().contains(sharedGroup) && !item.getInvisibleSharedGroups().contains(sharedGroup)) {
                    return;
                }
                this.deleteRosterItem(deletedUser, false);
            } else {
                item.removeSharedGroup(sharedGroup);
                if (item.isOnlyShared()) {
                    Collection<Group> userGroups = GroupManager.getInstance().getGroups(this.getUserJID());
                    ArrayList<Group> sharedGroups = new ArrayList<Group>();
                    sharedGroups.addAll(item.getSharedGroups());
                    RosterManager rosterManager = XMPPServer.getInstance().getRosterManager();
                    if (rosterManager.hasMutualVisibility(this.getUsername(), userGroups, deletedUser, sharedGroups)) {
                        item.setSubStatus(RosterItem.SUB_BOTH);
                    } else if (item.getSharedGroups().isEmpty() && !item.getInvisibleSharedGroups().isEmpty()) {
                        item.setSubStatus(RosterItem.SUB_FROM);
                    } else {
                        item.setSubStatus(RosterItem.SUB_TO);
                    }
                    RosterEventDispatcher.contactUpdated(this, item);
                } else {
                    RosterEventDispatcher.contactDeleted(this, item);
                }
                this.broadcast(item, false);
            }
        }
        catch (SharedGroupException e) {
            Log.error("Unexpected error while deleting user '{}' from shared group '{}'!", new Object[]{deletedUser, sharedGroup, e});
        }
        catch (UserNotFoundException e) {
            Log.warn("Unexpected error while deleting user '{}' from shared group '{}'!", new Object[]{deletedUser, sharedGroup, e});
        }
    }

    void deleteSharedUser(JID deletedUser, Group deletedGroup) {
        try {
            RosterManager rosterManager = XMPPServer.getInstance().getRosterManager();
            RosterItem item = this.getRosterItem(deletedUser);
            int groupSize = item.getSharedGroups().size() + item.getInvisibleSharedGroups().size();
            if (!(!item.isOnlyShared() || groupSize != 1 || deletedGroup.isUser(deletedUser) && RosterManager.isPublicSharedGroup(deletedGroup))) {
                this.deleteRosterItem(deletedUser, false);
            } else {
                if (!deletedGroup.isUser(deletedUser) || !RosterManager.isPublicSharedGroup(deletedGroup)) {
                    item.removeSharedGroup(deletedGroup);
                }
                Collection<Group> groups = GroupManager.getInstance().getGroups(deletedUser);
                for (Group group : groups) {
                    if (rosterManager.isGroupVisible(group, this.getUserJID())) continue;
                    item.removeSharedGroup(group);
                }
                if (item.isOnlyShared()) {
                    Collection<Group> userGroups = GroupManager.getInstance().getGroups(this.getUserJID());
                    if (rosterManager.hasMutualVisibility(this.getUsername(), userGroups, deletedUser, groups)) {
                        item.setSubStatus(RosterItem.SUB_BOTH);
                    } else {
                        item.setSubStatus(RosterItem.SUB_FROM);
                        for (Group group : groups) {
                            if (!rosterManager.isGroupVisible(group, this.getUserJID())) continue;
                            item.setSubStatus(RosterItem.SUB_TO);
                        }
                    }
                    RosterEventDispatcher.contactUpdated(this, item);
                } else {
                    RosterEventDispatcher.contactDeleted(this, item);
                }
                this.broadcast(item, false);
            }
        }
        catch (SharedGroupException e) {
            Log.error("Unexpected error while deleting user '{}' from shared group '{}'!", new Object[]{deletedUser, deletedGroup, e});
        }
        catch (UserNotFoundException e) {
            Log.warn("Unexpected error while deleting user '{}' from shared group '{}'!", new Object[]{deletedUser, deletedGroup, e});
        }
    }

    void shareGroupRenamed(Collection<JID> users) {
        JID userJID = this.getUserJID();
        for (JID user : users) {
            if (userJID.equals((Object)user)) continue;
            try {
                RosterItem item = this.getRosterItem(user);
                this.broadcast(item, true);
            }
            catch (UserNotFoundException e) {
                Log.warn("Unexpected error while broadcasting shared group rename for user '{}'!", (Object)user, (Object)e);
            }
        }
    }

    private JID getUserJID() {
        return XMPPServer.getInstance().createJID(this.getUsername(), null, true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Roster roster = (Roster)o;
        if (!this.rosterItems.equals(roster.rosterItems)) {
            return false;
        }
        if (!this.implicitFrom.equals(roster.implicitFrom)) {
            return false;
        }
        return this.username.equals(roster.username);
    }

    public int hashCode() {
        int result = this.rosterItems.hashCode();
        result = 31 * result + this.implicitFrom.hashCode();
        result = 31 * result + this.username.hashCode();
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.username);
        ExternalizableUtil.getInstance().writeExternalizableMap(out, this.rosterItems);
        ExternalizableUtil.getInstance().writeStringsMap(out, this.implicitFrom);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.username = ExternalizableUtil.getInstance().readSafeUTF(in);
        ExternalizableUtil.getInstance().readExternalizableMap(in, this.rosterItems, this.getClass().getClassLoader());
        ExternalizableUtil.getInstance().readStringsMap(in, this.implicitFrom);
    }
}

