/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.pubsub.models;

import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.openfire.pubsub.Node;
import org.jivesoftware.openfire.pubsub.NodeAffiliate;
import org.jivesoftware.openfire.pubsub.NodeSubscription;
import org.jivesoftware.openfire.pubsub.models.AccessModel;
import org.xmpp.packet.JID;
import org.xmpp.packet.PacketError;

public class AuthorizeAccess
extends AccessModel {
    AuthorizeAccess() {
    }

    @Override
    public boolean canSubscribe(Node node, JID owner, JID subscriber) {
        return true;
    }

    @Override
    public boolean canAccessItems(Node node, JID owner, JID subscriber) {
        if (node.isAdmin(owner)) {
            return true;
        }
        NodeAffiliate nodeAffiliate = node.getAffiliate(owner);
        if (nodeAffiliate == null) {
            return false;
        }
        for (NodeSubscription subscription : nodeAffiliate.getSubscriptions()) {
            if (!subscription.isActive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "authorize";
    }

    @Override
    public PacketError.Condition getSubsriptionError() {
        return PacketError.Condition.not_authorized;
    }

    @Override
    public Element getSubsriptionErrorDetail() {
        return DocumentHelper.createElement((QName)QName.get((String)"not-subscribed", (String)"http://jabber.org/protocol/pubsub#errors"));
    }

    @Override
    public boolean isAuthorizationRequired() {
        return true;
    }
}

