/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.pubsub.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.pep.PEPServiceManager;
import org.jivesoftware.openfire.pubsub.Node;
import org.jivesoftware.openfire.pubsub.PubSubService;
import org.jivesoftware.util.cache.ClusterTask;
import org.jivesoftware.util.cache.ExternalizableUtil;
import org.xmpp.packet.JID;

public abstract class NodeTask
implements ClusterTask<Void> {
    protected String nodeId;
    protected String serviceId;

    protected NodeTask() {
    }

    protected NodeTask(Node node) {
        this.nodeId = node.getNodeID();
        this.serviceId = node.getService().getServiceID();
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public Node getNode() {
        PubSubService svc = this.getService();
        return svc != null ? svc.getNode(this.nodeId) : null;
    }

    public PubSubService getService() {
        if (XMPPServer.getInstance().getPubSubModule().getServiceID().equals(this.serviceId)) {
            return XMPPServer.getInstance().getPubSubModule();
        }
        PEPServiceManager serviceMgr = XMPPServer.getInstance().getIQPEPHandler().getServiceManager();
        return serviceMgr.hasCachedService(new JID(this.serviceId)) ? serviceMgr.getPEPService(this.serviceId) : null;
    }

    @Override
    public Void getResult() {
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.nodeId);
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.serviceId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.nodeId = ExternalizableUtil.getInstance().readSafeUTF(in);
        this.serviceId = ExternalizableUtil.getInstance().readSafeUTF(in);
    }
}

