/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.pubsub;

import java.util.Collections;
import java.util.List;
import org.dom4j.Element;
import org.jivesoftware.openfire.commands.AdHocCommand;
import org.jivesoftware.openfire.commands.SessionData;
import org.jivesoftware.openfire.pubsub.Node;
import org.jivesoftware.openfire.pubsub.NodeSubscription;
import org.jivesoftware.openfire.pubsub.PubSubService;
import org.jivesoftware.util.LocaleUtils;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.JID;

public class PendingSubscriptionsCommand
extends AdHocCommand {
    private PubSubService service;

    public PendingSubscriptionsCommand(PubSubService service) {
        this.service = service;
    }

    @Override
    protected void addStageInformation(SessionData data, Element command) {
        DataForm form = new DataForm(DataForm.Type.form);
        form.setTitle(LocaleUtils.getLocalizedString("pubsub.command.pending-subscriptions.title"));
        form.addInstruction(LocaleUtils.getLocalizedString("pubsub.command.pending-subscriptions.instruction"));
        FormField formField = form.addField();
        formField.setVariable("pubsub#node");
        formField.setType(FormField.Type.list_single);
        formField.setLabel(LocaleUtils.getLocalizedString("pubsub.command.pending-subscriptions.node"));
        for (Node node : this.service.getNodes()) {
            if (node.isCollectionNode() || !node.isAdmin(data.getOwner())) continue;
            formField.addOption(null, node.getNodeID());
        }
        command.add(form.getElement());
    }

    @Override
    public void execute(SessionData data, Element command) {
        Element note = command.addElement("note");
        List<String> nodeIDs = data.getData().get("pubsub#node");
        if (nodeIDs.isEmpty()) {
            note.addAttribute("type", "error");
            note.setText(LocaleUtils.getLocalizedString("pubsub.command.pending-subscriptions.error.idrequired"));
        } else if (nodeIDs.size() > 1) {
            note.addAttribute("type", "error");
            note.setText(LocaleUtils.getLocalizedString("pubsub.command.pending-subscriptions.error.manyIDs"));
        } else {
            Node node = this.service.getNode(nodeIDs.get(0));
            if (node != null) {
                if (node.isAdmin(data.getOwner())) {
                    note.addAttribute("type", "info");
                    note.setText(LocaleUtils.getLocalizedString("pubsub.command.pending-subscriptions.success"));
                    for (NodeSubscription subscription : node.getPendingSubscriptions()) {
                        subscription.sendAuthorizationRequest(data.getOwner());
                    }
                } else {
                    note.addAttribute("type", "error");
                    note.setText(LocaleUtils.getLocalizedString("pubsub.command.pending-subscriptions.error.forbidden"));
                }
            } else {
                note.addAttribute("type", "error");
                note.setText(LocaleUtils.getLocalizedString("pubsub.command.pending-subscriptions.error.badid"));
            }
        }
    }

    @Override
    public String getCode() {
        return "http://jabber.org/protocol/pubsub#get-pending";
    }

    @Override
    public String getDefaultLabel() {
        return LocaleUtils.getLocalizedString("pubsub.command.pending-subscriptions.label");
    }

    @Override
    protected List<AdHocCommand.Action> getActions(SessionData data) {
        return Collections.singletonList(AdHocCommand.Action.complete);
    }

    @Override
    protected AdHocCommand.Action getExecuteAction(SessionData data) {
        return AdHocCommand.Action.complete;
    }

    @Override
    public int getMaxStages(SessionData data) {
        return 1;
    }

    @Override
    public boolean hasPermission(JID requester) {
        for (Node node : this.service.getNodes()) {
            if (node.isCollectionNode() || !node.isAdmin(requester)) continue;
            return true;
        }
        return false;
    }
}

