/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.pubsub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.Element;
import org.jivesoftware.openfire.pubsub.DefaultNodeConfiguration;
import org.jivesoftware.openfire.pubsub.Node;
import org.jivesoftware.openfire.pubsub.NodeSubscription;
import org.jivesoftware.openfire.pubsub.NotAcceptableException;
import org.jivesoftware.openfire.pubsub.PubSubService;
import org.jivesoftware.util.LocaleUtils;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class CollectionNode
extends Node {
    private Map<String, Node> nodes = new ConcurrentHashMap<String, Node>();
    private LeafNodeAssociationPolicy associationPolicy = LeafNodeAssociationPolicy.all;
    private Collection<JID> associationTrusted = new ArrayList<JID>();
    private int maxLeafNodes = -1;

    public CollectionNode(PubSubService service, CollectionNode parentNode, String nodeID, JID creator) {
        super(service, parentNode, nodeID, creator);
        DefaultNodeConfiguration defaultConfiguration = service.getDefaultNodeConfiguration(false);
        this.associationPolicy = defaultConfiguration.getAssociationPolicy();
        this.maxLeafNodes = defaultConfiguration.getMaxLeafNodes();
    }

    @Override
    protected void configure(FormField field) throws NotAcceptableException {
        block13: {
            block12: {
                if (!"pubsub#leaf_node_association_policy".equals(field.getVariable()) && !"pubsub#children_association_policy".equals(field.getVariable())) break block12;
                List values = field.getValues();
                if (values.size() <= 0) break block13;
                this.associationPolicy = LeafNodeAssociationPolicy.valueOf((String)values.get(0));
                break block13;
            }
            if ("pubsub#leaf_node_association_whitelist".equals(field.getVariable()) || "pubsub#children_association_whitelist".equals(field.getVariable())) {
                this.associationTrusted = new ArrayList<JID>();
                for (String value : field.getValues()) {
                    try {
                        this.addAssociationTrusted(new JID(value));
                    }
                    catch (Exception exception) {}
                }
            } else if ("pubsub#leaf_nodes_max".equals(field.getVariable()) || "pubsub#children_max".equals(field.getVariable())) {
                List values = field.getValues();
                this.maxLeafNodes = values.size() > 0 ? Integer.parseInt((String)values.get(0)) : -1;
            } else if ("pubsub#children".endsWith(field.getVariable())) {
                List values = field.getValues();
                ArrayList<Node> childrenNodes = new ArrayList<Node>(values.size());
                for (String nodeId : values) {
                    Node childNode = this.service.getNode(nodeId);
                    if (childNode == null) {
                        throw new NotAcceptableException("Child node does not exist");
                    }
                    childrenNodes.add(childNode);
                }
                ArrayList<Node> toRemove = new ArrayList<Node>(this.nodes.values());
                toRemove.removeAll(childrenNodes);
                for (Node node : toRemove) {
                    this.removeChildNode(node);
                }
                for (Node node : childrenNodes) {
                    node.changeParent(this);
                }
            }
        }
    }

    @Override
    void postConfigure(DataForm completedForm) {
    }

    @Override
    protected void addFormFields(DataForm form, boolean isEditing) {
        super.addFormFields(form, isEditing);
        FormField typeField = form.getField("pubsub#node_type");
        typeField.addValue((Object)"collection");
        FormField formField = form.addField();
        formField.setVariable("pubsub#leaf_node_association_policy");
        if (isEditing) {
            formField.setType(FormField.Type.list_single);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.children_association_policy"));
            formField.addOption(LocaleUtils.getLocalizedString("pubsub.form.conf.children_association_policy.all"), LeafNodeAssociationPolicy.all.name());
            formField.addOption(LocaleUtils.getLocalizedString("pubsub.form.conf.children_association_policy.owners"), LeafNodeAssociationPolicy.owners.name());
            formField.addOption(LocaleUtils.getLocalizedString("pubsub.form.conf.children_association_policy.whitelist"), LeafNodeAssociationPolicy.whitelist.name());
        }
        formField.addValue((Object)this.associationPolicy.name());
        formField = form.addField();
        formField.setVariable("pubsub#children_association_policy");
        if (isEditing) {
            formField.setType(FormField.Type.list_single);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.children_association_policy"));
            formField.addOption(LocaleUtils.getLocalizedString("pubsub.form.conf.children_association_policy.all"), LeafNodeAssociationPolicy.all.name());
            formField.addOption(LocaleUtils.getLocalizedString("pubsub.form.conf.children_association_policy.owners"), LeafNodeAssociationPolicy.owners.name());
            formField.addOption(LocaleUtils.getLocalizedString("pubsub.form.conf.children_association_policy.whitelist"), LeafNodeAssociationPolicy.whitelist.name());
        }
        formField.addValue((Object)this.associationPolicy.name());
        formField = form.addField();
        formField.setVariable("pubsub#leaf_node_association_whitelist");
        if (isEditing) {
            formField.setType(FormField.Type.jid_multi);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.children_association_whitelist"));
        }
        for (JID contact : this.associationTrusted) {
            formField.addValue((Object)contact.toString());
        }
        formField = form.addField();
        formField.setVariable("pubsub#children_association_whitelist");
        if (isEditing) {
            formField.setType(FormField.Type.jid_multi);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.children_association_whitelist"));
        }
        for (JID contact : this.associationTrusted) {
            formField.addValue((Object)contact.toString());
        }
        formField = form.addField();
        formField.setVariable("pubsub#leaf_nodes_max");
        if (isEditing) {
            formField.setType(FormField.Type.text_single);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.children_max"));
        }
        formField.addValue((Object)this.maxLeafNodes);
        formField = form.addField();
        formField.setVariable("pubsub#chilren_max");
        if (isEditing) {
            formField.setType(FormField.Type.text_single);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.children_max"));
        }
        formField.addValue((Object)this.maxLeafNodes);
        formField = form.addField();
        formField.setVariable("pubsub#children");
        if (isEditing) {
            formField.setType(FormField.Type.text_multi);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.children"));
        }
        for (String nodeId : this.nodes.keySet()) {
            formField.addValue((Object)nodeId);
        }
    }

    void addChildNode(Node child) {
        this.nodes.put(child.getNodeID(), child);
    }

    void removeChildNode(Node child) {
        this.nodes.remove(child.getNodeID());
    }

    void childNodeAdded(Node child) {
        Message message = new Message();
        Element event = message.addChildElement("event", "http://jabber.org/protocol/pubsub#event");
        Element item = event.addElement("items").addElement("item");
        item.addAttribute("id", child.getNodeID());
        if (this.deliverPayloads) {
            item.add(child.getMetadataForm().getElement());
        }
        this.broadcastCollectionNodeEvent(child, message);
    }

    void childNodeDeleted(Node child) {
        Message message = new Message();
        Element event = message.addChildElement("event", "http://jabber.org/protocol/pubsub#event");
        event.addElement("delete").addAttribute("node", child.getNodeID());
        this.broadcastCollectionNodeEvent(child, message);
    }

    @Override
    protected void deletingNode() {
        for (Node node : this.getNodes()) {
            node.changeParent(this.parent);
        }
    }

    private void broadcastCollectionNodeEvent(Node child, Message notification) {
        ArrayList<NodeSubscription> subscriptions = new ArrayList<NodeSubscription>();
        subscriptions.addAll(this.getSubscriptions(child));
        for (CollectionNode parentNode : this.getParents()) {
            subscriptions.addAll(parentNode.getSubscriptions(child));
        }
        for (NodeSubscription subscription : subscriptions) {
            this.service.sendNotification(subscription.getNode(), notification, subscription.getJID());
        }
    }

    private Collection<NodeSubscription> getSubscriptions(Node child) {
        ArrayList<NodeSubscription> subscriptions = new ArrayList<NodeSubscription>();
        for (NodeSubscription subscription : this.getSubscriptions()) {
            if (!subscription.canSendChildNodeEvent(child)) continue;
            subscriptions.add(subscription);
        }
        return subscriptions;
    }

    @Override
    public boolean isCollectionNode() {
        return true;
    }

    @Override
    public boolean isChildNode(Node child) {
        return this.nodes.containsKey(child.getNodeID());
    }

    @Override
    public boolean isDescendantNode(Node child) {
        if (this.isChildNode(child)) {
            return true;
        }
        for (Node node : this.getNodes()) {
            if (!node.isDescendantNode(child)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<Node> getNodes() {
        return this.nodes.values();
    }

    public LeafNodeAssociationPolicy getAssociationPolicy() {
        return this.associationPolicy;
    }

    public Collection<JID> getAssociationTrusted() {
        return Collections.unmodifiableCollection(this.associationTrusted);
    }

    void addAssociationTrusted(JID user) {
        this.associationTrusted.add(user);
    }

    public int getMaxLeafNodes() {
        return this.maxLeafNodes;
    }

    void setAssociationPolicy(LeafNodeAssociationPolicy associationPolicy) {
        this.associationPolicy = associationPolicy;
    }

    void setAssociationTrusted(Collection<JID> associationTrusted) {
        this.associationTrusted = associationTrusted;
    }

    void setMaxLeafNodes(int maxLeafNodes) {
        this.maxLeafNodes = maxLeafNodes;
    }

    public boolean isAssociationAllowed(JID user) {
        if (this.associationPolicy == LeafNodeAssociationPolicy.all) {
            return true;
        }
        if (this.associationPolicy == LeafNodeAssociationPolicy.owners) {
            return this.isAdmin(user);
        }
        return this.isAdmin(user) || this.associationTrusted.contains(user);
    }

    public boolean isMaxLeafNodeReached() {
        if (this.maxLeafNodes < 0) {
            return false;
        }
        int counter = 0;
        for (Node node : this.getNodes()) {
            if (node.isCollectionNode()) continue;
            ++counter;
        }
        return counter >= this.maxLeafNodes;
    }

    public static enum LeafNodeAssociationPolicy {
        all,
        owners,
        whitelist;

    }
}

