/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.privacy;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.dom4j.Element;
import org.jivesoftware.openfire.privacy.PrivacyList;
import org.jivesoftware.openfire.privacy.PrivacyListEventListener;
import org.jivesoftware.openfire.privacy.PrivacyListProvider;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;

public class PrivacyListManager {
    private static final PrivacyListManager instance = new PrivacyListManager();
    private static Cache<String, PrivacyList> listsCache;
    private PrivacyListProvider provider = PrivacyListProvider.getInstance();
    private List<PrivacyListEventListener> listeners = new CopyOnWriteArrayList<PrivacyListEventListener>();

    public static PrivacyListManager getInstance() {
        return instance;
    }

    private PrivacyListManager() {
        String cacheName = "Privacy Lists";
        listsCache = CacheFactory.createCache(cacheName);
    }

    public PrivacyList createPrivacyList(String username, String listName, Element listElement) {
        PrivacyList list = new PrivacyList(username, listName, false, listElement);
        listsCache.put(PrivacyListManager.getCacheKey(username, listName), list);
        this.provider.createPrivacyList(username, list);
        for (PrivacyListEventListener listener : this.listeners) {
            listener.privacyListCreated(list);
        }
        return list;
    }

    public void deletePrivacyList(String username, String listName) {
        for (PrivacyListEventListener listener : this.listeners) {
            listener.privacyListDeleting(listName);
        }
        listsCache.remove(PrivacyListManager.getCacheKey(username, listName));
        this.provider.deletePrivacyList(username, listName);
        PrivacyList defaultList = (PrivacyList)listsCache.get(PrivacyListManager.getDefaultCacheKey(username));
        if (defaultList != null && listName.equals(defaultList.getName())) {
            listsCache.remove(PrivacyListManager.getDefaultCacheKey(username));
        }
    }

    public void deletePrivacyLists(String username) {
        for (String listName : this.provider.getPrivacyLists(username).keySet()) {
            listsCache.remove(PrivacyListManager.getCacheKey(username, listName));
            for (PrivacyListEventListener listener : this.listeners) {
                listener.privacyListDeleting(listName);
            }
        }
        this.provider.deletePrivacyLists(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivacyList getDefaultPrivacyList(String username) {
        String cacheKey = PrivacyListManager.getDefaultCacheKey(username);
        PrivacyList list = (PrivacyList)listsCache.get(cacheKey);
        if (list == null) {
            String string = username.intern();
            synchronized (string) {
                list = (PrivacyList)listsCache.get(cacheKey);
                if (list == null && (list = this.provider.loadDefaultPrivacyList(username)) != null) {
                    listsCache.put(cacheKey, list);
                }
            }
        }
        return list;
    }

    public PrivacyList getPrivacyList(String username, String listName) {
        String cacheKey = PrivacyListManager.getCacheKey(username, listName);
        PrivacyList list = (PrivacyList)listsCache.get(cacheKey);
        if (list == null && (list = this.provider.loadPrivacyList(username, listName)) != null) {
            listsCache.put(cacheKey, list);
        }
        return list;
    }

    public void changeDefaultList(String username, PrivacyList newDefault, PrivacyList oldDefault) {
        if (oldDefault != null) {
            oldDefault.setDefaultList(false);
            this.provider.updatePrivacyList(username, oldDefault);
        }
        newDefault.setDefaultList(true);
        listsCache.put(PrivacyListManager.getDefaultCacheKey(username), newDefault);
        this.provider.updatePrivacyList(username, newDefault);
    }

    public void addListener(PrivacyListEventListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.add(listener);
    }

    public void removeListener(PrivacyListEventListener listener) {
        this.listeners.remove(listener);
    }

    private static String getCacheKey(String username, String listName) {
        return username + listName;
    }

    private static String getDefaultCacheKey(String username) {
        return PrivacyListManager.getCacheKey(username, "__d_e_f_a_u_l_t__");
    }

    void dispatchModifiedEvent(PrivacyList privacyList) {
        for (PrivacyListEventListener listener : this.listeners) {
            listener.privacyListModified(privacyList);
        }
    }

    static {
        PrivacyListEventListener eventListener = new PrivacyListEventListener(){

            @Override
            public void privacyListCreated(PrivacyList list) {
            }

            @Override
            public void privacyListDeleting(String listName) {
            }

            @Override
            public void privacyListModified(PrivacyList list) {
                listsCache.put(PrivacyListManager.getCacheKey(list.getUserJID().getNode(), list.getName()), list);
            }
        };
        instance.addListener(eventListener);
    }
}

