/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.nio;

import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.net.ClientStanzaHandler;
import org.jivesoftware.openfire.net.StanzaHandler;
import org.jivesoftware.openfire.nio.ConnectionHandler;
import org.jivesoftware.openfire.nio.NIOConnection;
import org.jivesoftware.openfire.nio.OfflinePacketDeliverer;
import org.jivesoftware.openfire.spi.ConnectionConfiguration;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;

public class ClientConnectionHandler
extends ConnectionHandler {
    private static final Logger Log = LoggerFactory.getLogger(ClientConnectionHandler.class);

    public ClientConnectionHandler(ConnectionConfiguration configuration) {
        super(configuration);
    }

    @Override
    NIOConnection createNIOConnection(IoSession session) {
        return new NIOConnection(session, new OfflinePacketDeliverer(), this.configuration);
    }

    @Override
    StanzaHandler createStanzaHandler(NIOConnection connection) {
        return new ClientStanzaHandler(XMPPServer.getInstance().getPacketRouter(), connection);
    }

    @Override
    int getMaxIdleTime() {
        return JiveGlobals.getIntProperty("xmpp.client.idle", 360000) / 1000;
    }

    @Override
    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        ClientStanzaHandler handler;
        JID entity;
        super.sessionIdle(session, status);
        boolean doPing = JiveGlobals.getBooleanProperty("xmpp.client.idle.ping", true);
        if (doPing && session.getIdleCount(status) == 1 && (entity = (handler = (ClientStanzaHandler)session.getAttribute((Object)"HANDLER")).getAddress()) != null) {
            IQ pingRequest = new IQ(IQ.Type.get);
            pingRequest.setChildElement("ping", "urn:xmpp:ping");
            pingRequest.setFrom(XMPPServer.getInstance().getServerInfo().getXMPPDomain());
            pingRequest.setTo(entity);
            Connection connection = (Connection)session.getAttribute((Object)"CONNECTION");
            if (Log.isDebugEnabled()) {
                Log.debug("ConnectionHandler: Pinging connection that has been idle: " + connection);
            }
            connection.deliver((Packet)pingRequest);
        }
    }
}

