/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.ConnectionCloseListener;
import org.jivesoftware.openfire.PacketDeliverer;
import org.jivesoftware.openfire.session.LocalSession;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VirtualConnection
implements Connection {
    private static final Logger Log = LoggerFactory.getLogger(VirtualConnection.class);
    protected LocalSession session;
    private final Map<ConnectionCloseListener, Object> listeners = new HashMap<ConnectionCloseListener, Object>();
    private AtomicReference<Connection.State> state = new AtomicReference<Connection.State>(Connection.State.OPEN);

    @Override
    public int getMajorXMPPVersion() {
        return 0;
    }

    @Override
    public int getMinorXMPPVersion() {
        return 0;
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return new Certificate[0];
    }

    @Override
    public Certificate[] getPeerCertificates() {
        return new Certificate[0];
    }

    @Override
    public void setUsingSelfSignedCertificate(boolean isSelfSigned) {
    }

    @Override
    public boolean isUsingSelfSignedCertificate() {
        return false;
    }

    @Override
    public boolean isClosed() {
        return this.state.get() == Connection.State.CLOSED;
    }

    @Override
    public Connection.CompressionPolicy getCompressionPolicy() {
        return null;
    }

    @Override
    public Connection.TLSPolicy getTlsPolicy() {
        return null;
    }

    @Override
    public boolean isCompressed() {
        return false;
    }

    @Override
    public boolean isFlashClient() {
        return false;
    }

    @Override
    public void setFlashClient(boolean flashClient) {
    }

    @Override
    public void setXMPPVersion(int majorVersion, int minorVersion) {
    }

    @Override
    public void setCompressionPolicy(Connection.CompressionPolicy compressionPolicy) {
    }

    @Override
    public void setTlsPolicy(Connection.TLSPolicy tlsPolicy) {
    }

    @Override
    public PacketDeliverer getPacketDeliverer() {
        return null;
    }

    @Override
    @Deprecated
    public void startTLS(boolean clientMode, String remoteServer, Connection.ClientAuth authentication) throws Exception {
    }

    @Override
    public void startTLS(boolean clientMode) throws Exception {
    }

    @Override
    public void addCompression() {
    }

    @Override
    public void startCompression() {
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public void init(LocalSession session) {
        this.session = session;
    }

    @Override
    public void reinit(LocalSession session) {
        this.session = session;
    }

    @Override
    public void close() {
        if (this.state.compareAndSet(Connection.State.OPEN, Connection.State.CLOSED)) {
            if (this.session != null) {
                this.session.setStatus(-1);
            }
            try {
                this.closeVirtualConnection();
            }
            catch (Exception e) {
                Log.error(LocaleUtils.getLocalizedString("admin.error.close") + "\n" + this.toString(), (Throwable)e);
            }
            this.notifyCloseListeners();
        }
    }

    @Override
    public void registerCloseListener(ConnectionCloseListener listener, Object handbackMessage) {
        if (this.isClosed()) {
            listener.onConnectionClose(handbackMessage);
        } else {
            this.listeners.put(listener, handbackMessage);
        }
    }

    @Override
    public void removeCloseListener(ConnectionCloseListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCloseListeners() {
        Map<ConnectionCloseListener, Object> map = this.listeners;
        synchronized (map) {
            for (ConnectionCloseListener listener : this.listeners.keySet()) {
                try {
                    listener.onConnectionClose(this.listeners.get(listener));
                }
                catch (Exception e) {
                    Log.error("Error notifying listener: " + listener, (Throwable)e);
                }
            }
        }
    }

    public abstract void closeVirtualConnection();
}

