/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.WritableByteChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.net.TLSStreamReader;
import org.jivesoftware.openfire.net.TLSStreamWriter;
import org.jivesoftware.openfire.net.TLSWrapper;
import org.jivesoftware.openfire.spi.ConnectionConfiguration;
import org.jivesoftware.util.JiveGlobals;

public class TLSStreamHandler {
    private TLSStreamWriter writer;
    private TLSStreamReader reader;
    private TLSWrapper wrapper;
    private ReadableByteChannel rbc;
    private WritableByteChannel wbc;
    private SSLEngine tlsEngine;
    private SSLEngineResult.HandshakeStatus initialHSStatus;
    private boolean initialHSComplete;
    private int appBBSize;
    private int netBBSize;
    private ByteBuffer incomingNetBB;
    private ByteBuffer outgoingNetBB;
    private ByteBuffer appBB;
    private static ByteBuffer hsBB = ByteBuffer.allocate(0);

    @Deprecated
    public TLSStreamHandler(Connection connection, Socket socket, boolean clientMode, String remoteServer, boolean needClientAuth) throws IOException {
        this(socket, connection.getConfiguration(), clientMode);
    }

    public TLSStreamHandler(Socket socket, ConnectionConfiguration configuration, boolean clientMode) throws IOException {
        this.wrapper = new TLSWrapper(configuration, clientMode);
        this.tlsEngine = this.wrapper.getTlsEngine();
        this.reader = new TLSStreamReader(this.wrapper, socket);
        this.writer = new TLSStreamWriter(this.wrapper, socket);
        if (socket.getChannel() != null) {
            this.rbc = socket.getChannel();
            this.wbc = socket.getChannel();
        } else {
            this.rbc = Channels.newChannel(socket.getInputStream());
            this.wbc = Channels.newChannel(socket.getOutputStream());
        }
        this.initialHSStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        this.initialHSComplete = false;
        this.netBBSize = this.tlsEngine.getSession().getPacketBufferSize();
        this.appBBSize = this.tlsEngine.getSession().getApplicationBufferSize();
        this.incomingNetBB = ByteBuffer.allocate(this.netBBSize);
        this.outgoingNetBB = ByteBuffer.allocate(this.netBBSize);
        this.outgoingNetBB.position(0);
        this.outgoingNetBB.limit(0);
        this.appBB = ByteBuffer.allocate(this.appBBSize);
        if (clientMode) {
            socket.setSoTimeout(0);
            socket.setKeepAlive(true);
            this.initialHSStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
            this.tlsEngine.beginHandshake();
        } else if (configuration.getClientAuth() == Connection.ClientAuth.needed) {
            if (JiveGlobals.getBooleanProperty("xmpp.server.certificate.verify", true) && JiveGlobals.getBooleanProperty("xmpp.server.certificate.verify.chain", true) && !JiveGlobals.getBooleanProperty("xmpp.server.certificate.accept-selfsigned", false)) {
                this.tlsEngine.setNeedClientAuth(true);
            } else {
                this.tlsEngine.setWantClientAuth(true);
            }
        }
    }

    public InputStream getInputStream() {
        return this.reader.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.writer.getOutputStream();
    }

    public void start() throws IOException {
        while (!this.initialHSComplete) {
            this.initialHSComplete = this.doHandshake(null);
        }
    }

    private boolean doHandshake(SelectionKey sk) throws IOException {
        if (this.initialHSComplete) {
            return this.initialHSComplete;
        }
        if (this.outgoingNetBB.hasRemaining()) {
            if (!this.flush(this.outgoingNetBB)) {
                return false;
            }
            switch (this.initialHSStatus) {
                case FINISHED: {
                    this.initialHSComplete = true;
                }
                case NEED_UNWRAP: {
                    if (sk == null) break;
                    sk.interestOps(1);
                }
            }
            return this.initialHSComplete;
        }
        block5 : switch (this.initialHSStatus) {
            case NEED_UNWRAP: {
                SSLEngineResult result;
                if (this.rbc.read(this.incomingNetBB) == -1) {
                    try {
                        this.tlsEngine.closeInbound();
                    }
                    catch (SSLException ex) {
                        if ("Inbound closed before receiving peer's close_notify: possible truncation attack?".equals(ex.getMessage())) {
                            throw new SSLHandshakeException("The peer closed the connection while performing a TLS handshake.");
                        }
                        throw ex;
                    }
                    return this.initialHSComplete;
                }
                block22: while (this.initialHSStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    this.incomingNetBB.flip();
                    result = this.tlsEngine.unwrap(this.incomingNetBB, this.appBB);
                    this.incomingNetBB.compact();
                    this.initialHSStatus = result.getHandshakeStatus();
                    switch (result.getStatus()) {
                        case OK: {
                            switch (this.initialHSStatus) {
                                case NOT_HANDSHAKING: {
                                    throw new IOException("Not handshaking during initial handshake");
                                }
                                case NEED_TASK: {
                                    this.initialHSStatus = this.doTasks();
                                    break;
                                }
                                case FINISHED: {
                                    this.initialHSComplete = true;
                                    break block22;
                                }
                            }
                            continue block22;
                        }
                        case BUFFER_UNDERFLOW: {
                            if (sk == null) break block22;
                            sk.interestOps(1);
                            break block22;
                        }
                        default: {
                            throw new IOException("Received" + (Object)((Object)result.getStatus()) + "during initial handshaking");
                        }
                    }
                }
                if (this.initialHSStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP) break;
            }
            case NEED_WRAP: {
                this.outgoingNetBB.clear();
                SSLEngineResult result = this.tlsEngine.wrap(hsBB, this.outgoingNetBB);
                this.outgoingNetBB.flip();
                this.initialHSStatus = result.getHandshakeStatus();
                switch (result.getStatus()) {
                    case OK: {
                        if (this.initialHSStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                            this.initialHSStatus = this.doTasks();
                        }
                        if (sk == null) break block5;
                        sk.interestOps(4);
                        break block5;
                    }
                    default: {
                        throw new IOException("Received" + (Object)((Object)result.getStatus()) + "during initial handshaking");
                    }
                }
            }
            default: {
                throw new RuntimeException("Invalid Handshaking State" + (Object)((Object)this.initialHSStatus));
            }
        }
        return this.initialHSComplete;
    }

    private boolean flush(ByteBuffer bb) throws IOException {
        this.wbc.write(bb);
        return !bb.hasRemaining();
    }

    private SSLEngineResult.HandshakeStatus doTasks() {
        Runnable runnable;
        while ((runnable = this.tlsEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return this.tlsEngine.getHandshakeStatus();
    }

    public void close() throws IOException {
        this.wbc.close();
        this.rbc.close();
    }

    public SSLSession getSSLSession() {
        return this.tlsEngine.getSession();
    }
}

