/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLHandshakeException;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.net.SASLAuthentication;
import org.jivesoftware.openfire.net.SocketReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;
import org.xmpp.packet.StreamError;

abstract class SocketReadingMode {
    private static final Logger Log = LoggerFactory.getLogger(SocketReadingMode.class);
    protected static String CHARSET = "UTF-8";
    protected SocketReader socketReader;
    protected Socket socket;

    protected SocketReadingMode(Socket socket, SocketReader socketReader) {
        this.socket = socket;
        this.socketReader = socketReader;
    }

    abstract void run();

    protected boolean negotiateTLS() {
        if (this.socketReader.connection.getTlsPolicy() == Connection.TLSPolicy.disabled) {
            StreamError error = new StreamError(StreamError.Condition.not_authorized);
            this.socketReader.connection.deliverRawText(error.toXML());
            this.socketReader.connection.close();
            Log.warn("TLS requested by initiator when TLS was never offered by server. Closing connection : " + this.socketReader.connection);
            return false;
        }
        try {
            this.socketReader.connection.startTLS(false);
        }
        catch (SSLHandshakeException e) {
            Log.info("STARTTLS negotiation (with: {}) failed.", (Object)this.socketReader.connection, (Object)e);
            this.socketReader.connection.forceClose();
            return false;
        }
        catch (IOException | RuntimeException e) {
            Log.warn("An exception occurred while performing STARTTLS negotiation (with: {})", (Object)this.socketReader.connection, (Object)e);
            this.socketReader.connection.deliverRawText("<failure xmlns=\"urn:ietf:params:xml:ns:xmpp-tls\"/>");
            this.socketReader.connection.close();
            return false;
        }
        return true;
    }

    protected void tlsNegotiated() throws XmlPullParserException, IOException {
        StringBuilder sb = new StringBuilder(620);
        sb.append(this.geStreamHeader());
        sb.append("<stream:features>");
        sb.append(SASLAuthentication.getSASLMechanisms(this.socketReader.session));
        String specificFeatures = this.socketReader.session.getAvailableStreamFeatures();
        if (specificFeatures != null) {
            sb.append(specificFeatures);
        }
        sb.append("</stream:features>");
        this.socketReader.connection.deliverRawText(sb.toString());
    }

    protected boolean authenticateClient(Element doc) throws DocumentException, IOException, XmlPullParserException {
        if (this.socketReader.connection.getTlsPolicy() == Connection.TLSPolicy.required && !this.socketReader.connection.isSecure()) {
            this.socketReader.closeNeverSecuredConnection();
            return false;
        }
        boolean isComplete = false;
        boolean success = false;
        while (!isComplete) {
            SASLAuthentication.Status status = SASLAuthentication.handle(this.socketReader.session, doc);
            if (status == SASLAuthentication.Status.needResponse) {
                doc = this.socketReader.reader.parseDocument().getRootElement();
                if (doc != null) continue;
                isComplete = true;
                continue;
            }
            isComplete = true;
            success = status == SASLAuthentication.Status.authenticated;
        }
        return success;
    }

    protected void saslSuccessful() throws XmlPullParserException, IOException {
        StringBuilder sb = new StringBuilder(420);
        sb.append(this.geStreamHeader());
        sb.append("<stream:features>");
        String specificFeatures = this.socketReader.session.getAvailableStreamFeatures();
        if (specificFeatures != null) {
            sb.append(specificFeatures);
        }
        sb.append("</stream:features>");
        this.socketReader.connection.deliverRawText(sb.toString());
    }

    protected boolean compressClient(Element doc) throws IOException, XmlPullParserException {
        String error = null;
        if (this.socketReader.connection.getCompressionPolicy() == Connection.CompressionPolicy.disabled) {
            error = "<failure xmlns='http://jabber.org/protocol/compress'><setup-failed/></failure>";
            Log.warn("Client requested compression while compression is disabled. Closing connection : " + this.socketReader.connection);
        } else if (this.socketReader.connection.isCompressed()) {
            error = "<failure xmlns='http://jabber.org/protocol/compress'><setup-failed/></failure>";
            Log.warn("Client requested compression and connection is already compressed. Closing connection : " + this.socketReader.connection);
        } else {
            String method = doc.elementText("method");
            if (!"zlib".equals(method)) {
                error = "<failure xmlns='http://jabber.org/protocol/compress'><unsupported-method/></failure>";
                Log.warn("Requested compression method is not supported: " + method + ". Closing connection : " + this.socketReader.connection);
            }
        }
        if (error != null) {
            this.socketReader.connection.deliverRawText(error);
            return false;
        }
        this.socketReader.connection.addCompression();
        this.socketReader.connection.deliverRawText("<compressed xmlns='http://jabber.org/protocol/compress'/>");
        this.socketReader.connection.startCompression();
        return true;
    }

    protected void compressionSuccessful() throws XmlPullParserException, IOException {
        String specificFeatures;
        StringBuilder sb = new StringBuilder(340);
        sb.append(this.geStreamHeader());
        sb.append("<stream:features>");
        if (this.socketReader.session.getStatus() != 3) {
            sb.append(SASLAuthentication.getSASLMechanisms(this.socketReader.session));
        }
        if ((specificFeatures = this.socketReader.session.getAvailableStreamFeatures()) != null) {
            sb.append(specificFeatures);
        }
        sb.append("</stream:features>");
        this.socketReader.connection.deliverRawText(sb.toString());
    }

    private String geStreamHeader() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("<?xml version='1.0' encoding='");
        sb.append(CHARSET);
        sb.append("'?>");
        if (this.socketReader.connection.isFlashClient()) {
            sb.append("<flash:stream xmlns:flash=\"http://www.jabber.com/streams/flash\" ");
        } else {
            sb.append("<stream:stream ");
        }
        sb.append("xmlns:stream=\"http://etherx.jabber.org/streams\" xmlns=\"");
        sb.append(this.socketReader.getNamespace()).append('\"');
        if (this.socketReader.getExtraNamespaces() != null) {
            sb.append(' ');
            sb.append(this.socketReader.getExtraNamespaces());
        }
        sb.append(" from=\"");
        sb.append(this.socketReader.session.getServerName());
        sb.append("\" id=\"");
        sb.append(this.socketReader.session.getStreamID().toString());
        sb.append("\" xml:lang=\"");
        sb.append(this.socketReader.session.getLanguage().toLanguageTag());
        sb.append("\" version=\"");
        sb.append(1).append('.').append(0);
        sb.append("\">");
        return sb.toString();
    }
}

