/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import java.io.IOException;
import java.net.Socket;
import org.dom4j.Element;
import org.dom4j.io.XMPPPacketReader;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.StreamIDFactory;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.net.BlockingReadingMode;
import org.jivesoftware.openfire.net.MXParser;
import org.jivesoftware.openfire.net.SocketConnection;
import org.jivesoftware.openfire.net.SocketReadingMode;
import org.jivesoftware.openfire.session.LocalSession;
import org.jivesoftware.openfire.spi.BasicStreamIDFactory;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;
import org.xmpp.packet.Roster;
import org.xmpp.packet.StreamError;

public abstract class SocketReader
implements Runnable {
    private static final Logger Log = LoggerFactory.getLogger(SocketReader.class);
    private static String CHARSET = "UTF-8";
    private static final StreamIDFactory STREAM_ID_FACTORY = new BasicStreamIDFactory();
    private static XmlPullParserFactory factory = null;
    protected LocalSession session;
    protected SocketConnection connection;
    protected String serverName;
    private PacketRouter router;
    private RoutingTable routingTable;
    private SocketReadingMode readingMode;
    XMPPPacketReader reader = null;
    protected boolean open;

    public SocketReader(PacketRouter router, RoutingTable routingTable, String serverName, Socket socket, SocketConnection connection, boolean useBlockingMode) {
        this.serverName = serverName;
        this.router = router;
        this.routingTable = routingTable;
        this.connection = connection;
        connection.setSocketReader(this);
        this.reader = new XMPPPacketReader();
        this.reader.setXPPFactory(factory);
        this.readingMode = new BlockingReadingMode(socket, this);
    }

    @Override
    public void run() {
        this.readingMode.run();
    }

    protected void process(Element doc) throws Exception {
        if (doc == null) {
            return;
        }
        String tag = doc.getName();
        if ("message".equals(tag)) {
            Message packet;
            try {
                packet = new Message(doc);
            }
            catch (IllegalArgumentException e) {
                Log.debug("SocketReader: Rejecting packet. JID malformed", (Throwable)e);
                Message reply = new Message();
                reply.setID(doc.attributeValue("id"));
                reply.setTo(this.session.getAddress());
                reply.getElement().addAttribute("from", doc.attributeValue("to"));
                reply.setError(PacketError.Condition.jid_malformed);
                this.session.process((Packet)reply);
                return;
            }
            this.processMessage(packet);
        } else if ("presence".equals(tag)) {
            Presence packet;
            try {
                packet = new Presence(doc);
            }
            catch (IllegalArgumentException e) {
                Log.debug("SocketReader: Rejecting packet. JID malformed", (Throwable)e);
                Presence reply = new Presence();
                reply.setID(doc.attributeValue("id"));
                reply.setTo(this.session.getAddress());
                reply.getElement().addAttribute("from", doc.attributeValue("to"));
                reply.setError(PacketError.Condition.jid_malformed);
                this.session.process((Packet)reply);
                return;
            }
            try {
                packet.getType();
            }
            catch (IllegalArgumentException e) {
                Log.debug("Invalid presence (type): " + packet);
                packet.setType(null);
            }
            try {
                packet.getShow();
            }
            catch (IllegalArgumentException e) {
                Log.debug("Invalid presence (show): " + packet);
                packet.setShow(null);
            }
            if (this.session.getStatus() == -1 && packet.isAvailable()) {
                Log.warn("Ignoring available presence packet of closed session: " + packet);
                return;
            }
            this.processPresence(packet);
        } else if ("iq".equals(tag)) {
            IQ packet;
            try {
                packet = this.getIQ(doc);
            }
            catch (IllegalArgumentException e) {
                Log.debug("SocketReader: Rejecting packet. JID malformed", (Throwable)e);
                IQ reply = new IQ();
                if (!doc.elements().isEmpty()) {
                    reply.setChildElement(((Element)doc.elements().get(0)).createCopy());
                }
                reply.setID(doc.attributeValue("id"));
                reply.setTo(this.session.getAddress());
                if (doc.attributeValue("to") != null) {
                    reply.getElement().addAttribute("from", doc.attributeValue("to"));
                }
                reply.setError(PacketError.Condition.jid_malformed);
                this.session.process((Packet)reply);
                return;
            }
            this.processIQ(packet);
        } else if (!this.processUnknowPacket(doc)) {
            Log.warn(LocaleUtils.getLocalizedString("admin.error.packet.tag") + doc.asXML());
            this.open = false;
        }
    }

    protected void processIQ(IQ packet) throws UnauthorizedException {
        if (this.connection.getTlsPolicy() == Connection.TLSPolicy.required && !this.connection.isSecure()) {
            this.closeNeverSecuredConnection();
            return;
        }
        this.router.route(packet);
        this.session.incrementClientPacketCount();
    }

    protected void processPresence(Presence packet) throws UnauthorizedException {
        if (this.connection.getTlsPolicy() == Connection.TLSPolicy.required && !this.connection.isSecure()) {
            this.closeNeverSecuredConnection();
            return;
        }
        this.router.route(packet);
        this.session.incrementClientPacketCount();
    }

    protected void processMessage(Message packet) throws UnauthorizedException {
        if (this.connection.getTlsPolicy() == Connection.TLSPolicy.required && !this.connection.isSecure()) {
            this.closeNeverSecuredConnection();
            return;
        }
        this.router.route(packet);
        this.session.incrementClientPacketCount();
    }

    abstract boolean processUnknowPacket(Element var1);

    long getLastActive() {
        return this.reader.getLastActive();
    }

    abstract String getName();

    void closeNeverSecuredConnection() {
        StreamError error = new StreamError(StreamError.Condition.not_authorized);
        this.connection.deliverRawText(error.toXML());
        this.connection.close();
        Log.warn("TLS was required by the server and connection was never secured. Closing connection : " + this.connection);
    }

    private IQ getIQ(Element doc) {
        Element query = doc.element("query");
        if (query != null && "jabber:iq:roster".equals(query.getNamespaceURI())) {
            return new Roster(doc);
        }
        return new IQ(doc);
    }

    protected void createSession() throws UnauthorizedException, XmlPullParserException, IOException {
        MXParser xpp = this.reader.getXPPParser();
        int eventType = xpp.getEventType();
        while (eventType != 2) {
            eventType = xpp.next();
        }
        String host = this.reader.getXPPParser().getAttributeValue("", "to");
        if (this.validateHost() && this.isHostUnknown(host)) {
            StringBuilder sb = new StringBuilder(250);
            sb.append("<?xml version='1.0' encoding='");
            sb.append(CHARSET);
            sb.append("'?>");
            sb.append("<stream:stream ");
            sb.append("from=\"").append(host).append("\" ");
            sb.append("id=\"").append(STREAM_ID_FACTORY.createStreamID()).append("\" ");
            sb.append("xmlns=\"").append(xpp.getNamespace(null)).append("\" ");
            sb.append("xmlns:stream=\"").append(xpp.getNamespace("stream")).append("\" ");
            sb.append("version=\"1.0\">");
            StreamError error = new StreamError(StreamError.Condition.host_unknown);
            sb.append(error.toXML());
            this.connection.deliverRawText(sb.toString());
            this.connection.close();
            Log.warn("Closing session due to incorrect hostname in stream header. Host: " + host + ". Connection: " + this.connection);
        } else if (!this.createSession(xpp.getNamespace(null))) {
            StringBuilder sb = new StringBuilder(250);
            sb.append("<?xml version='1.0' encoding='");
            sb.append(CHARSET);
            sb.append("'?>");
            sb.append("<stream:stream ");
            sb.append("from=\"").append(host).append("\" ");
            sb.append("id=\"").append(STREAM_ID_FACTORY.createStreamID()).append("\" ");
            sb.append("xmlns=\"").append(xpp.getNamespace(null)).append("\" ");
            sb.append("xmlns:stream=\"").append(xpp.getNamespace("stream")).append("\" ");
            sb.append("version=\"1.0\">");
            StreamError error = new StreamError(StreamError.Condition.bad_namespace_prefix);
            sb.append(error.toXML());
            this.connection.deliverRawText(sb.toString());
            this.connection.close();
            Log.warn("Closing session due to bad_namespace_prefix in stream header. Prefix: " + xpp.getNamespace(null) + ". Connection: " + this.connection);
        }
    }

    private boolean isHostUnknown(String host) {
        if (host == null) {
            return false;
        }
        if (this.serverName.equals(host)) {
            return false;
        }
        return !this.routingTable.hasComponentRoute(new JID(host));
    }

    abstract String getNamespace();

    abstract boolean validateHost();

    protected void shutdown() {
    }

    abstract boolean createSession(String var1) throws UnauthorizedException, XmlPullParserException, IOException;

    public String getExtraNamespaces() {
        return null;
    }

    static {
        try {
            factory = XmlPullParserFactory.newInstance((String)MXParser.class.getName(), null);
        }
        catch (XmlPullParserException e) {
            Log.error("Error creating a parser factory", (Throwable)e);
        }
    }
}

