/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import org.jivesoftware.openfire.ChannelHandler;
import org.jivesoftware.openfire.PacketException;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;

public class SocketPacketWriteHandler
implements ChannelHandler {
    private static final Logger Log = LoggerFactory.getLogger(SocketPacketWriteHandler.class);
    private XMPPServer server;
    private RoutingTable routingTable;

    public SocketPacketWriteHandler(RoutingTable routingTable) {
        this.routingTable = routingTable;
        this.server = XMPPServer.getInstance();
    }

    public void process(Packet packet) throws UnauthorizedException, PacketException {
        try {
            JID recipient = packet.getTo();
            if (this.server.matchesComponent(recipient) || this.server.isRemote(recipient)) {
                this.routingTable.routePacket(recipient, packet, false);
            } else if (recipient == null || recipient.getNode() == null && recipient.getResource() == null) {
                this.routingTable.routePacket(packet.getFrom(), packet, false);
            } else if (recipient.getResource() != null || !(packet instanceof Presence)) {
                this.routingTable.routePacket(recipient, packet, false);
            } else {
                for (JID route : this.routingTable.getRoutes(recipient, null)) {
                    this.routingTable.routePacket(route, packet, false);
                }
            }
        }
        catch (Exception e) {
            Log.error(LocaleUtils.getLocalizedString("admin.error.deliver") + "\n" + packet.toString(), (Throwable)e);
        }
    }
}

