/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import java.io.IOException;
import java.util.Map;
import java.util.TimerTask;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import org.jivesoftware.openfire.ConnectionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.jivesoftware.util.TaskEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulticastDNSService
extends BasicModule {
    private static final Logger Log = LoggerFactory.getLogger(MulticastDNSService.class);
    private JmDNS jmdns;

    public MulticastDNSService() {
        super("Multicast DNS Service");
        PropertyEventDispatcher.addListener(new PropertyEventListener(){

            public void propertySet(String property, Map params) {
                if (property.equals("xmpp.component.socket.active") || property.equals(" xmpp.component.socket.port")) {
                    MulticastDNSService.this.stop();
                    MulticastDNSService.this.start();
                }
            }

            public void propertyDeleted(String property, Map params) {
                if (property.equals("xmpp.component.socket.active") || property.equals(" xmpp.component.socket.port")) {
                    MulticastDNSService.this.stop();
                    MulticastDNSService.this.start();
                }
            }

            public void xmlPropertySet(String property, Map params) {
            }

            public void xmlPropertyDeleted(String property, Map params) {
            }
        });
    }

    @Override
    public void initialize(XMPPServer server) {
    }

    @Override
    public void start() throws IllegalStateException {
        if (!JiveGlobals.getBooleanProperty("multicastDNS.enabled", false)) {
            return;
        }
        TimerTask startService = new TimerTask(){

            @Override
            public void run() {
                int clientPortNum = -1;
                int componentPortNum = -1;
                ConnectionManager connectionManager = XMPPServer.getInstance().getConnectionManager();
                if (connectionManager != null) {
                    clientPortNum = connectionManager.getClientListenerPort();
                    componentPortNum = connectionManager.getComponentListenerPort();
                }
                try {
                    if (MulticastDNSService.this.jmdns == null) {
                        MulticastDNSService.this.jmdns = new JmDNS();
                    }
                    String serverName = XMPPServer.getInstance().getServerInfo().getXMPPDomain();
                    if (clientPortNum != -1) {
                        ServiceInfo clientService = new ServiceInfo("_xmpp-client._tcp.local.", serverName + "._xmpp-client._tcp.local.", clientPortNum, "XMPP Server");
                        MulticastDNSService.this.jmdns.registerService(clientService);
                    }
                    if (componentPortNum != -1) {
                        ServiceInfo componentService = new ServiceInfo("_xmpp-component._tcp.local.", serverName + "._xmpp-component._tcp.local.", componentPortNum, "XMPP Component Server");
                        MulticastDNSService.this.jmdns.registerService(componentService);
                    }
                }
                catch (IOException ioe) {
                    Log.error(ioe.getMessage(), (Throwable)ioe);
                }
            }
        };
        TaskEngine.getInstance().schedule(startService, 5000L);
    }

    @Override
    public void stop() {
        if (this.jmdns != null) {
            try {
                this.jmdns.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void destroy() {
        if (this.jmdns != null) {
            this.jmdns = null;
        }
    }
}

