/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.multiplex;

import org.dom4j.Element;
import org.jivesoftware.openfire.OfflineMessageStrategy;
import org.jivesoftware.openfire.PacketDeliverer;
import org.jivesoftware.openfire.PacketException;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.multiplex.ConnectionMultiplexerManager;
import org.jivesoftware.openfire.session.ConnectionMultiplexerSession;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;

public class MultiplexerPacketDeliverer
implements PacketDeliverer {
    private static final Logger Log = LoggerFactory.getLogger(MultiplexerPacketDeliverer.class);
    private OfflineMessageStrategy messageStrategy = XMPPServer.getInstance().getOfflineMessageStrategy();
    private String connectionManagerDomain;
    private ConnectionMultiplexerManager multiplexerManager = ConnectionMultiplexerManager.getInstance();

    public void setConnectionManagerDomain(String connectionManagerDomain) {
        this.connectionManagerDomain = connectionManagerDomain;
    }

    @Override
    public void deliver(Packet packet) throws UnauthorizedException, PacketException {
        if (this.connectionManagerDomain == null) {
            this.handleUnprocessedPacket(packet);
        } else {
            ConnectionMultiplexerSession session = this.multiplexerManager.getMultiplexerSession(this.connectionManagerDomain);
            if (session == null || session.isClosed()) {
                this.handleUnprocessedPacket(packet);
            } else {
                session.process(packet);
            }
        }
    }

    private void handleUnprocessedPacket(Packet packet) {
        if (packet instanceof Message) {
            this.messageStrategy.storeOffline((Message)packet);
        } else if (!(packet instanceof Presence) && packet instanceof IQ) {
            IQ iq = (IQ)packet;
            Element child = iq.getChildElement();
            if (child != null && "session".equals(child.getName()) && "http://jabber.org/protocol/connectionmanager".equals(child.getNamespacePrefix())) {
                Element wrappedElement;
                Element send = child.element("send");
                if (send != null && "message".equals((wrappedElement = (Element)send.elements().get(0)).getName())) {
                    this.handleUnprocessedPacket((Packet)new Message(wrappedElement));
                }
            } else {
                Log.warn(LocaleUtils.getLocalizedString("admin.error.routing") + "\n" + packet.toString());
            }
        }
    }
}

