/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.multiplex;

import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.StreamID;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.event.SessionEventDispatcher;
import org.jivesoftware.openfire.event.SessionEventListener;
import org.jivesoftware.openfire.multiplex.ClientSessionConnection;
import org.jivesoftware.openfire.session.ConnectionMultiplexerSession;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.openfire.session.Session;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.TaskEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionMultiplexerManager
implements SessionEventListener {
    private static final Logger Log = LoggerFactory.getLogger(ConnectionMultiplexerManager.class);
    private static final ConnectionMultiplexerManager instance = new ConnectionMultiplexerManager();
    private static Random randGen = new Random();
    private Map<StreamID, String> streamIDs = new ConcurrentHashMap<StreamID, String>();
    private Map<String, Map<StreamID, LocalClientSession>> sessionsByManager = new ConcurrentHashMap<String, Map<StreamID, LocalClientSession>>();
    private SessionManager sessionManager = XMPPServer.getInstance().getSessionManager();

    public static ConnectionMultiplexerManager getInstance() {
        return instance;
    }

    public static String getDefaultSecret() {
        return JiveGlobals.getProperty("xmpp.multiplex.defaultSecret");
    }

    public static void setDefaultSecret(String defaultSecret) {
        JiveGlobals.setProperty("xmpp.multiplex.defaultSecret", defaultSecret);
    }

    private ConnectionMultiplexerManager() {
        TimerTask heartbeatTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    for (ConnectionMultiplexerSession session : ConnectionMultiplexerManager.this.sessionManager.getConnectionMultiplexerSessions()) {
                        session.deliverRawText(" ");
                    }
                }
                catch (Exception e) {
                    Log.error(e.getMessage(), (Throwable)e);
                }
            }
        };
        TaskEngine.getInstance().schedule(heartbeatTask, 30000L, 30000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createClientSession(String connectionManagerDomain, StreamID streamID, String hostName, String hostAddress) {
        ClientSessionConnection connection = new ClientSessionConnection(connectionManagerDomain, hostName, hostAddress);
        byte[] address = null;
        try {
            address = connection.getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (address == null || LocalClientSession.isAllowed(connection)) {
            LocalClientSession session = SessionManager.getInstance().createClientSession((Connection)connection, streamID);
            this.streamIDs.put(streamID, connectionManagerDomain);
            Map<StreamID, LocalClientSession> sessions = this.sessionsByManager.get(connectionManagerDomain);
            if (sessions == null) {
                String string = connectionManagerDomain.intern();
                synchronized (string) {
                    sessions = this.sessionsByManager.get(connectionManagerDomain);
                    if (sessions == null) {
                        sessions = new ConcurrentHashMap<StreamID, LocalClientSession>();
                        this.sessionsByManager.put(connectionManagerDomain, sessions);
                    }
                }
            }
            sessions.put(streamID, session);
            return true;
        }
        return false;
    }

    public void closeClientSession(String connectionManagerDomain, StreamID streamID) {
        Session session;
        Map<StreamID, LocalClientSession> sessions = this.sessionsByManager.get(connectionManagerDomain);
        if (sessions != null && (session = (Session)sessions.remove(streamID)) != null) {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void multiplexerAvailable(String connectionManagerName) {
        Map<StreamID, LocalClientSession> sessions = this.sessionsByManager.get(connectionManagerName);
        if (sessions == null) {
            String string = connectionManagerName.intern();
            synchronized (string) {
                sessions = this.sessionsByManager.get(connectionManagerName);
                if (sessions == null) {
                    sessions = new ConcurrentHashMap<StreamID, LocalClientSession>();
                    this.sessionsByManager.put(connectionManagerName, sessions);
                }
            }
        }
    }

    public void multiplexerUnavailable(String connectionManagerName) {
        Map<StreamID, LocalClientSession> sessions = this.sessionsByManager.remove(connectionManagerName);
        if (sessions != null) {
            for (StreamID streamID : sessions.keySet()) {
                this.streamIDs.remove(streamID);
                sessions.get(streamID).close();
            }
        }
    }

    public LocalClientSession getClientSession(String connectionManagerDomain, StreamID streamID) {
        Map<StreamID, LocalClientSession> sessions = this.sessionsByManager.get(connectionManagerDomain);
        if (sessions != null) {
            return sessions.get(streamID);
        }
        return null;
    }

    public ConnectionMultiplexerSession getMultiplexerSession(String connectionManagerDomain, StreamID streamID) {
        List<ConnectionMultiplexerSession> sessions = this.sessionManager.getConnectionMultiplexerSessions(connectionManagerDomain);
        if (sessions.isEmpty()) {
            return null;
        }
        if (sessions.size() == 1) {
            return sessions.get(0);
        }
        if (streamID != null) {
            int connectionIndex = Math.abs(streamID.hashCode()) % sessions.size();
            return sessions.get(connectionIndex);
        }
        return sessions.get(randGen.nextInt(sessions.size()));
    }

    public ConnectionMultiplexerSession getMultiplexerSession(String connectionManagerDomain) {
        return this.getMultiplexerSession(connectionManagerDomain, null);
    }

    public Collection<String> getMultiplexers() {
        return this.sessionsByManager.keySet();
    }

    public int getNumConnectedClients(String managerName) {
        Map<StreamID, LocalClientSession> clients = this.sessionsByManager.get(managerName);
        if (clients == null) {
            return 0;
        }
        return clients.size();
    }

    @Override
    public void anonymousSessionCreated(Session session) {
    }

    @Override
    public void anonymousSessionDestroyed(Session session) {
        this.removeSession(session);
    }

    @Override
    public void sessionCreated(Session session) {
    }

    @Override
    public void sessionDestroyed(Session session) {
        this.removeSession(session);
    }

    @Override
    public void resourceBound(Session session) {
    }

    private void removeSession(Session session) {
        Map<StreamID, LocalClientSession> sessions;
        StreamID streamID = session.getStreamID();
        String connectionManagerDomain = this.streamIDs.remove(streamID);
        if (connectionManagerDomain != null && (sessions = this.sessionsByManager.get(connectionManagerDomain)) != null) {
            sessions.remove(streamID);
        }
    }

    static {
        SessionEventDispatcher.addListener(instance);
    }
}

