/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.spi;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.cluster.NodeID;
import org.jivesoftware.openfire.muc.MUCRole;
import org.jivesoftware.openfire.muc.MUCRoom;
import org.jivesoftware.openfire.muc.MultiUserChatService;
import org.jivesoftware.openfire.muc.cluster.OccupantAddedEvent;
import org.jivesoftware.util.cache.ExternalizableUtil;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;

public class RemoteMUCRole
implements MUCRole,
Externalizable {
    private String serviceDomain;
    private Presence presence;
    private MUCRole.Role role;
    private MUCRole.Affiliation affiliation;
    private String nickname;
    private boolean voiceOnly;
    private JID roleAddress;
    private JID userAddress;
    private MUCRoom room;
    private NodeID nodeID;

    public RemoteMUCRole() {
    }

    public RemoteMUCRole(MultiUserChatService server, OccupantAddedEvent event) {
        this.serviceDomain = server.getServiceDomain();
        this.presence = event.getPresence();
        this.role = event.getRole();
        this.affiliation = event.getAffiliation();
        this.nickname = event.getNickname();
        this.voiceOnly = event.isVoiceOnly();
        this.roleAddress = event.getRoleAddress();
        this.userAddress = event.getUserAddress();
        this.room = event.getRoom();
        this.nodeID = event.getNodeID();
    }

    @Override
    public Presence getPresence() {
        return this.presence;
    }

    @Override
    public void setPresence(Presence presence) {
        this.presence = presence;
    }

    @Override
    public void setRole(MUCRole.Role newRole) {
        this.role = newRole;
    }

    @Override
    public MUCRole.Role getRole() {
        return this.role;
    }

    @Override
    public void setAffiliation(MUCRole.Affiliation newAffiliation) {
        this.affiliation = newAffiliation;
    }

    @Override
    public MUCRole.Affiliation getAffiliation() {
        return this.affiliation;
    }

    @Override
    public void changeNickname(String nickname) {
        this.nickname = nickname;
        this.setRoleAddress(new JID(this.room.getName(), this.serviceDomain, nickname, true));
    }

    private void setRoleAddress(JID jid) {
        this.roleAddress = jid;
        this.presence.setFrom(jid);
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public void destroy() {
    }

    @Override
    public boolean isVoiceOnly() {
        return this.voiceOnly;
    }

    @Override
    public MUCRoom getChatRoom() {
        return this.room;
    }

    @Override
    public JID getRoleAddress() {
        return this.roleAddress;
    }

    @Override
    public JID getUserAddress() {
        return this.userAddress;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public NodeID getNodeID() {
        return this.nodeID;
    }

    @Override
    public void send(Packet packet) {
        XMPPServer.getInstance().getRoutingTable().routePacket(this.userAddress, packet, false);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.serviceDomain);
        ExternalizableUtil.getInstance().writeSerializable(out, (Serializable)((DefaultElement)this.presence.getElement()));
        ExternalizableUtil.getInstance().writeInt(out, this.role.ordinal());
        ExternalizableUtil.getInstance().writeInt(out, this.affiliation.ordinal());
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.nickname);
        ExternalizableUtil.getInstance().writeBoolean(out, this.voiceOnly);
        ExternalizableUtil.getInstance().writeSerializable(out, (Serializable)this.roleAddress);
        ExternalizableUtil.getInstance().writeSerializable(out, (Serializable)this.userAddress);
        ExternalizableUtil.getInstance().writeByteArray(out, this.nodeID.toByteArray());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.serviceDomain = ExternalizableUtil.getInstance().readSafeUTF(in);
        this.presence = new Presence((Element)ExternalizableUtil.getInstance().readSerializable(in), true);
        this.role = MUCRole.Role.values()[ExternalizableUtil.getInstance().readInt(in)];
        this.affiliation = MUCRole.Affiliation.values()[ExternalizableUtil.getInstance().readInt(in)];
        this.nickname = ExternalizableUtil.getInstance().readSafeUTF(in);
        this.voiceOnly = ExternalizableUtil.getInstance().readBoolean(in);
        this.roleAddress = (JID)ExternalizableUtil.getInstance().readSerializable(in);
        this.userAddress = (JID)ExternalizableUtil.getInstance().readSerializable(in);
        this.nodeID = NodeID.getInstance(ExternalizableUtil.getInstance().readByteArray(in));
    }
}

