/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.spi;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.openfire.muc.spi.MUCServicePropertyEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MUCServicePropertyEventDispatcher {
    private static final Logger Log = LoggerFactory.getLogger(MUCServicePropertyEventDispatcher.class);
    private static Set<MUCServicePropertyEventListener> listeners = new CopyOnWriteArraySet<MUCServicePropertyEventListener>();

    private MUCServicePropertyEventDispatcher() {
    }

    public static void addListener(MUCServicePropertyEventListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        listeners.add(listener);
    }

    public static void removeListener(MUCServicePropertyEventListener listener) {
        listeners.remove(listener);
    }

    public static void dispatchEvent(String service, String property, EventType eventType, Map<String, Object> params) {
        for (MUCServicePropertyEventListener listener : listeners) {
            try {
                switch (eventType) {
                    case property_set: {
                        listener.propertySet(service, property, params);
                        break;
                    }
                    case property_deleted: {
                        listener.propertyDeleted(service, property, params);
                        break;
                    }
                }
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static enum EventType {
        property_set,
        property_deleted;

    }
}

