/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.spi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.muc.cluster.MUCServicePropertyClusterEventTask;
import org.jivesoftware.openfire.muc.spi.MUCServicePropertyEventDispatcher;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MUCServiceProperties
implements Map<String, String> {
    private static final Logger Log = LoggerFactory.getLogger(MUCServiceProperties.class);
    private static final String LOAD_PROPERTIES = "SELECT name, propValue FROM ofMucServiceProp WHERE serviceID=?";
    private static final String INSERT_PROPERTY = "INSERT INTO ofMucServiceProp(serviceID, name, propValue) VALUES(?,?,?)";
    private static final String UPDATE_PROPERTY = "UPDATE ofMucServiceProp SET propValue=? WHERE serviceID=? AND name=?";
    private static final String DELETE_PROPERTY = "DELETE FROM ofMucServiceProp WHERE serviceID=? AND name=?";
    private String subdomain;
    private Long serviceID;
    private Map<String, String> properties;

    public MUCServiceProperties(String subdomain) {
        this.subdomain = subdomain;
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<String, String>();
        } else {
            this.properties.clear();
        }
        this.serviceID = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatServiceID(subdomain);
        if (this.serviceID == null) {
            Log.debug("MUCServiceProperties: Unable to find service ID for subdomain " + subdomain);
        } else {
            this.loadProperties();
        }
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    @Override
    public Collection<String> values() {
        return Collections.unmodifiableCollection(this.properties.values());
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> t) {
        for (Map.Entry<? extends String, ? extends String> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return Collections.unmodifiableSet(this.properties.entrySet());
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    @Override
    public String get(Object key) {
        return this.properties.get(key);
    }

    public Collection<String> getChildrenNames(String parentKey) {
        HashSet<String> results = new HashSet<String>();
        for (String key : this.properties.keySet()) {
            if (!key.startsWith(parentKey + ".") || key.equals(parentKey)) continue;
            int dotIndex = key.indexOf(".", parentKey.length() + 1);
            if (dotIndex < 1) {
                if (results.contains(key)) continue;
                results.add(key);
                continue;
            }
            String name = parentKey + key.substring(parentKey.length(), dotIndex);
            results.add(name);
        }
        return results;
    }

    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String remove(Object key) {
        String value;
        MUCServiceProperties mUCServiceProperties = this;
        synchronized (mUCServiceProperties) {
            value = this.properties.remove(key);
            Collection<String> propNames = this.getPropertyNames();
            for (String name : propNames) {
                if (!name.startsWith((String)key)) continue;
                this.properties.remove(name);
            }
            this.deleteProperty((String)key);
        }
        Map<String, Object> params = Collections.emptyMap();
        MUCServicePropertyEventDispatcher.dispatchEvent(this.subdomain, (String)key, MUCServicePropertyEventDispatcher.EventType.property_deleted, params);
        CacheFactory.doClusterTask(MUCServicePropertyClusterEventTask.createDeleteTask(this.subdomain, (String)key));
        return value;
    }

    void localRemove(String key) {
        this.properties.remove(key);
        Collection<String> propNames = this.getPropertyNames();
        for (String name : propNames) {
            if (!name.startsWith(key)) continue;
            this.properties.remove(name);
        }
        Map<String, Object> params = Collections.emptyMap();
        MUCServicePropertyEventDispatcher.dispatchEvent(this.subdomain, key, MUCServicePropertyEventDispatcher.EventType.property_deleted, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String put(String key, String value) {
        String result;
        if (key == null || value == null) {
            throw new NullPointerException("Key or value cannot be null. Key=" + key + ", value=" + value);
        }
        if (key.endsWith(".")) {
            key = key.substring(0, key.length() - 1);
        }
        key = key.trim();
        MUCServiceProperties mUCServiceProperties = this;
        synchronized (mUCServiceProperties) {
            if (this.properties.containsKey(key)) {
                if (!this.properties.get(key).equals(value)) {
                    this.updateProperty(key, value);
                }
            } else {
                this.insertProperty(key, value);
            }
            result = this.properties.put(key, value);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("value", value);
        MUCServicePropertyEventDispatcher.dispatchEvent(this.subdomain, key, MUCServicePropertyEventDispatcher.EventType.property_set, params);
        CacheFactory.doClusterTask(MUCServicePropertyClusterEventTask.createPutTask(this.subdomain, key, value));
        return result;
    }

    void localPut(String key, String value) {
        this.properties.put(key, value);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("value", value);
        MUCServicePropertyEventDispatcher.dispatchEvent(this.subdomain, key, MUCServicePropertyEventDispatcher.EventType.property_set, params);
    }

    public String getProperty(String name, String defaultValue) {
        String value = this.properties.get(name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public boolean getBooleanProperty(String name) {
        return Boolean.valueOf(this.get(name));
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        String value = this.get(name);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertProperty(String name, String value) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(INSERT_PROPERTY);
            pstmt.setLong(1, this.serviceID);
            pstmt.setString(2, name);
            pstmt.setString(3, value);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProperty(String name, String value) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(UPDATE_PROPERTY);
            pstmt.setString(1, value);
            pstmt.setLong(2, this.serviceID);
            pstmt.setString(3, name);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteProperty(String name) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_PROPERTY);
            pstmt.setLong(1, this.serviceID);
            pstmt.setString(2, name);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(LOAD_PROPERTIES);
            pstmt.setLong(1, this.serviceID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                String value = rs.getString(2);
                this.properties.put(name, value);
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
    }
}

