/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.openfire.muc.MUCRoom;
import org.jivesoftware.openfire.muc.MultiUserChatService;
import org.jivesoftware.openfire.muc.spi.MUCPersistenceManager;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.IQ;
import org.xmpp.packet.PacketError;
import org.xmpp.resultsetmanagement.ResultSet;
import org.xmpp.resultsetmanagement.ResultSetImpl;

public class IQMUCSearchHandler {
    private final MultiUserChatService mucService;

    public IQMUCSearchHandler(MultiUserChatService mucService) {
        this.mucService = mucService;
    }

    private static Element getDataElement() {
        DataForm searchForm = new DataForm(DataForm.Type.form);
        searchForm.setTitle("Chat Rooms Search");
        searchForm.addInstruction("Instructions");
        FormField typeFF = searchForm.addField();
        typeFF.setVariable("FORM_TYPE");
        typeFF.setType(FormField.Type.hidden);
        typeFF.addValue((Object)"jabber:iq:search");
        FormField nameFF = searchForm.addField();
        nameFF.setVariable("name");
        nameFF.setType(FormField.Type.text_single);
        nameFF.setLabel("Name");
        nameFF.setRequired(false);
        FormField matchFF = searchForm.addField();
        matchFF.setVariable("name_is_exact_match");
        matchFF.setType(FormField.Type.boolean_type);
        matchFF.setLabel("Name must match exactly");
        matchFF.setRequired(false);
        FormField subjectFF = searchForm.addField();
        subjectFF.setVariable("subject");
        subjectFF.setType(FormField.Type.text_single);
        subjectFF.setLabel("Subject");
        subjectFF.setRequired(false);
        FormField userAmountFF = searchForm.addField();
        userAmountFF.setVariable("num_users");
        userAmountFF.setType(FormField.Type.text_single);
        userAmountFF.setLabel("Number of users");
        userAmountFF.setRequired(false);
        FormField maxUsersFF = searchForm.addField();
        maxUsersFF.setVariable("num_max_users");
        maxUsersFF.setType(FormField.Type.text_single);
        maxUsersFF.setLabel("Max number allowed of users");
        maxUsersFF.setRequired(false);
        FormField includePasswordProtectedFF = searchForm.addField();
        includePasswordProtectedFF.setVariable("include_password_protected");
        includePasswordProtectedFF.setType(FormField.Type.boolean_type);
        includePasswordProtectedFF.setLabel("Include password protected rooms");
        includePasswordProtectedFF.setRequired(false);
        Element probeResult = DocumentHelper.createElement((QName)QName.get((String)"query", (String)"jabber:iq:search"));
        probeResult.add(searchForm.getElement());
        return probeResult;
    }

    public IQ handleIQ(IQ iq) {
        List mucrsm;
        boolean applyRSM;
        String b;
        FormField subjectFF;
        String b2;
        IQ reply = IQ.createResultIQ((IQ)iq);
        Element formElement = iq.getChildElement().element(QName.get((String)"x", (String)"jabber:x:data"));
        if (formElement == null) {
            reply.setChildElement(IQMUCSearchHandler.getDataElement());
            return reply;
        }
        DataForm df = new DataForm(formElement);
        boolean name_is_exact_match = false;
        String subject = null;
        int numusers = -1;
        int numaxusers = -1;
        boolean includePasswordProtectedRooms = true;
        HashSet<String> names = new HashSet<String>();
        for (FormField field : df.getFields()) {
            if (!field.getVariable().equals("name")) continue;
            names.add(field.getFirstValue());
        }
        FormField matchFF = df.getField("name_is_exact_match");
        if (matchFF != null && (b2 = matchFF.getFirstValue()) != null) {
            boolean bl = name_is_exact_match = b2.equals("1") || b2.equalsIgnoreCase("true") || b2.equalsIgnoreCase("yes");
        }
        if ((subjectFF = df.getField("subject")) != null) {
            subject = subjectFF.getFirstValue();
        }
        try {
            Object value;
            FormField maxUsersFF;
            String value2;
            FormField userAmountFF = df.getField("num_users");
            if (userAmountFF != null && (value2 = userAmountFF.getFirstValue()) != null && !"".equals(value2)) {
                numusers = Integer.parseInt(value2);
            }
            if ((maxUsersFF = df.getField("num_max_users")) != null && (value = maxUsersFF.getFirstValue()) != null && !"".equals(value)) {
                numaxusers = Integer.parseInt((String)value);
            }
        }
        catch (NumberFormatException e) {
            reply.setError(PacketError.Condition.bad_request);
            return reply;
        }
        FormField includePasswordProtectedRoomsFF = df.getField("include_password_protected");
        if (includePasswordProtectedRoomsFF != null && (b = includePasswordProtectedRoomsFF.getFirstValue()) != null && (b.equals("0") || b.equalsIgnoreCase("false") || b.equalsIgnoreCase("no"))) {
            includePasswordProtectedRooms = false;
        }
        ArrayList<MUCRoom> mucs = new ArrayList<MUCRoom>();
        for (MUCRoom room : this.mucService.getChatRooms()) {
            boolean find = false;
            if (names.size() > 0) {
                for (String name : names) {
                    if (name_is_exact_match) {
                        if (!name.equalsIgnoreCase(room.getNaturalLanguageName())) continue;
                        find = true;
                        break;
                    }
                    if (room.getNaturalLanguageName().toLowerCase().indexOf(name.toLowerCase()) == -1) continue;
                    find = true;
                    break;
                }
            }
            if (subject != null && room.getSubject().toLowerCase().indexOf(subject.toLowerCase()) != -1) {
                find = true;
            }
            if (numusers > -1 && room.getParticipants().size() < numusers) {
                find = false;
            }
            if (numaxusers > -1 && room.getMaxUsers() < numaxusers) {
                find = false;
            }
            if (!includePasswordProtectedRooms && room.isPasswordProtected()) {
                find = false;
            }
            if (!find || !IQMUCSearchHandler.canBeIncludedInResult(room)) continue;
            mucs.add(room);
        }
        ResultSetImpl searchResults = new ResultSetImpl(IQMUCSearchHandler.sortByUserAmount(mucs));
        Element set = iq.getChildElement().element(QName.get((String)"set", (String)"http://jabber.org/protocol/rsm"));
        boolean bl = applyRSM = set != null && !mucs.isEmpty();
        if (applyRSM) {
            if (!ResultSet.isValidRSMRequest((Element)set)) {
                reply.setError(PacketError.Condition.bad_request);
                return reply;
            }
            try {
                mucrsm = searchResults.applyRSMDirectives(set);
            }
            catch (NullPointerException e) {
                IQ itemNotFound = IQ.createResultIQ((IQ)iq);
                itemNotFound.setError(PacketError.Condition.item_not_found);
                return itemNotFound;
            }
        } else {
            mucrsm = new ArrayList(searchResults);
        }
        Element res = DocumentHelper.createElement((QName)QName.get((String)"query", (String)"jabber:iq:search"));
        DataForm resultform = new DataForm(DataForm.Type.result);
        boolean atLeastoneResult = false;
        for (MUCRoom room : mucrsm) {
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put("name", room.getNaturalLanguageName());
            fields.put("subject", room.getSubject());
            fields.put("num_users", room.getOccupantsCount());
            fields.put("num_max_users", room.getMaxUsers());
            fields.put("is_password_protected", room.isPasswordProtected());
            fields.put("is_member_only", room.isMembersOnly());
            fields.put("jid", room.getRole().getRoleAddress().toString());
            resultform.addItemFields(fields);
            atLeastoneResult = true;
        }
        if (atLeastoneResult) {
            resultform.addReportedField("name", "Name", FormField.Type.text_single);
            resultform.addReportedField("subject", "Subject", FormField.Type.text_single);
            resultform.addReportedField("num_users", "Number of users", FormField.Type.text_single);
            resultform.addReportedField("num_max_users", "Max number allowed of users", FormField.Type.text_single);
            resultform.addReportedField("is_password_protected", "Is a password protected room.", FormField.Type.boolean_type);
            resultform.addReportedField("is_member_only", "Is a member only room.", FormField.Type.boolean_type);
            resultform.addReportedField("jid", "JID", FormField.Type.jid_single);
        }
        res.add(resultform.getElement());
        if (applyRSM) {
            res.add(searchResults.generateSetElementFromResults(mucrsm));
        }
        reply.setChildElement(res);
        return reply;
    }

    private static List<MUCRoom> sortByUserAmount(List<MUCRoom> mucs) {
        Collections.sort(mucs, new Comparator<MUCRoom>(){

            @Override
            public int compare(MUCRoom o1, MUCRoom o2) {
                return o2.getOccupantsCount() - o1.getOccupantsCount();
            }
        });
        return mucs;
    }

    private static boolean canBeIncludedInResult(MUCRoom room) {
        boolean discoverLocked = MUCPersistenceManager.getBooleanProperty(room.getMUCService().getServiceName(), "discover.locked", true);
        if (!discoverLocked && room.isLocked()) {
            return false;
        }
        return room.isPublicRoom();
    }
}

