/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.spi;

import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.openfire.muc.ConflictException;
import org.jivesoftware.openfire.muc.ForbiddenException;
import org.jivesoftware.openfire.muc.MUCRole;
import org.jivesoftware.openfire.muc.MUCRoom;
import org.jivesoftware.openfire.muc.MultiUserChatService;
import org.jivesoftware.util.ElementUtil;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.IQ;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;

class IQMUCRegisterHandler {
    private static final Logger Log = LoggerFactory.getLogger(IQMUCRegisterHandler.class);
    private static final Element probeResult;
    private final MultiUserChatService mucService;

    public IQMUCRegisterHandler(MultiUserChatService mucService) {
        this.mucService = mucService;
    }

    public IQ handleIQ(IQ packet) {
        IQ reply = null;
        MUCRoom room = null;
        String name = packet.getTo().getNode();
        if (name != null) {
            room = this.mucService.getChatRoom(name);
        }
        if (room == null) {
            reply = IQ.createResultIQ((IQ)packet);
            reply.setChildElement(packet.getChildElement().createCopy());
            reply.setError(PacketError.Condition.item_not_found);
            return reply;
        }
        if (!room.isRegistrationEnabled() || packet.getFrom() != null && MUCRole.Affiliation.outcast == room.getAffiliation(packet.getFrom().asBareJID())) {
            reply = IQ.createResultIQ((IQ)packet);
            reply.setChildElement(packet.getChildElement().createCopy());
            reply.setError(PacketError.Condition.not_allowed);
            return reply;
        }
        if (IQ.Type.get == packet.getType()) {
            reply = IQ.createResultIQ((IQ)packet);
            String nickname = room.getReservedNickname(packet.getFrom());
            Element currentRegistration = probeResult.createCopy();
            if (nickname != null) {
                ElementUtil.setProperty(currentRegistration, "query.registered", null);
                currentRegistration.addElement("username").addText(nickname);
                Element form = currentRegistration.element(QName.get((String)"x", (String)"jabber:x:data"));
                currentRegistration.remove(form);
                reply.setChildElement(currentRegistration);
            } else {
                reply.setChildElement(currentRegistration);
            }
        } else if (IQ.Type.set == packet.getType()) {
            try {
                ArrayList<Presence> presences = new ArrayList<Presence>();
                reply = IQ.createResultIQ((IQ)packet);
                Element iq = packet.getChildElement();
                if (ElementUtil.includesProperty(iq, "query.remove")) {
                    presences.addAll(room.addNone(packet.getFrom(), room.getRole()));
                } else {
                    Element formElement = iq.element("x");
                    if (formElement != null) {
                        DataForm registrationForm = new DataForm(formElement);
                        List values = registrationForm.getField("muc#register_roomnick").getValues();
                        String nickname = !values.isEmpty() ? (String)values.get(0) : null;
                        presences.addAll(room.addMember(packet.getFrom(), nickname, room.getRole()));
                    } else {
                        reply.setChildElement(packet.getChildElement().createCopy());
                        reply.setError(PacketError.Condition.bad_request);
                    }
                }
                for (Presence presence : presences) {
                    room.send((Packet)presence);
                }
            }
            catch (ForbiddenException e) {
                reply = IQ.createResultIQ((IQ)packet);
                reply.setChildElement(packet.getChildElement().createCopy());
                reply.setError(PacketError.Condition.forbidden);
            }
            catch (ConflictException e) {
                reply = IQ.createResultIQ((IQ)packet);
                reply.setChildElement(packet.getChildElement().createCopy());
                reply.setError(PacketError.Condition.conflict);
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
        return reply;
    }

    static {
        DataForm registrationForm = new DataForm(DataForm.Type.form);
        registrationForm.setTitle(LocaleUtils.getLocalizedString("muc.form.reg.title"));
        registrationForm.addInstruction(LocaleUtils.getLocalizedString("muc.form.reg.instruction"));
        FormField fieldForm = registrationForm.addField();
        fieldForm.setVariable("FORM_TYPE");
        fieldForm.setType(FormField.Type.hidden);
        fieldForm.addValue((Object)"http://jabber.org/protocol/muc#register");
        FormField fieldReg = registrationForm.addField();
        fieldReg.setVariable("muc#register_first");
        fieldReg.setType(FormField.Type.text_single);
        fieldReg.setLabel(LocaleUtils.getLocalizedString("muc.form.reg.first-name"));
        fieldReg.setRequired(true);
        FormField fieldLast = registrationForm.addField();
        fieldLast.setVariable("muc#register_last");
        fieldLast.setType(FormField.Type.text_single);
        fieldLast.setLabel(LocaleUtils.getLocalizedString("muc.form.reg.last-name"));
        fieldLast.setRequired(true);
        FormField fieldNick = registrationForm.addField();
        fieldNick.setVariable("muc#register_roomnick");
        fieldNick.setType(FormField.Type.text_single);
        fieldNick.setLabel(LocaleUtils.getLocalizedString("muc.form.reg.nickname"));
        fieldNick.setRequired(true);
        FormField fieldUrl = registrationForm.addField();
        fieldUrl.setVariable("muc#register_url");
        fieldUrl.setType(FormField.Type.text_single);
        fieldUrl.setLabel(LocaleUtils.getLocalizedString("muc.form.reg.url"));
        FormField fieldMail = registrationForm.addField();
        fieldMail.setVariable("muc#register_email");
        fieldMail.setType(FormField.Type.text_single);
        fieldMail.setLabel(LocaleUtils.getLocalizedString("muc.form.reg.email"));
        FormField fieldFaq = registrationForm.addField();
        fieldFaq.setVariable("muc#register_faqentry");
        fieldFaq.setType(FormField.Type.text_single);
        fieldFaq.setLabel(LocaleUtils.getLocalizedString("muc.form.reg.faqentry"));
        probeResult = DocumentHelper.createElement((QName)QName.get((String)"query", (String)"jabber:iq:register"));
        probeResult.add(registrationForm.getElement());
    }
}

