/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.cluster;

import java.util.Queue;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jivesoftware.openfire.cluster.ClusterManager;
import org.jivesoftware.openfire.muc.cluster.MUCRoomTask;
import org.jivesoftware.util.TaskEngine;

public class QueuedTasksManager {
    private static QueuedTasksManager instance = new QueuedTasksManager();
    private Queue<MUCRoomTask> taskQueue = new ConcurrentLinkedQueue<MUCRoomTask>();

    public static QueuedTasksManager getInstance() {
        return instance;
    }

    private QueuedTasksManager() {
        TaskEngine.getInstance().scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (!ClusterManager.isClusteringStarting()) {
                    MUCRoomTask mucRoomTask;
                    while ((mucRoomTask = (MUCRoomTask)QueuedTasksManager.this.taskQueue.poll()) != null) {
                        mucRoomTask.run();
                    }
                }
            }
        }, 1000L, 30000L);
    }

    public void addTask(MUCRoomTask task) {
        this.taskQueue.add(task);
    }
}

