/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc;

import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.database.SequenceManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.cluster.ClusterEventListener;
import org.jivesoftware.openfire.cluster.ClusterManager;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.event.UserEventDispatcher;
import org.jivesoftware.openfire.event.UserEventListener;
import org.jivesoftware.openfire.muc.MUCRole;
import org.jivesoftware.openfire.muc.MUCRoom;
import org.jivesoftware.openfire.muc.MultiUserChatService;
import org.jivesoftware.openfire.muc.cluster.GetNewMemberRoomsRequest;
import org.jivesoftware.openfire.muc.cluster.OccupantAddedEvent;
import org.jivesoftware.openfire.muc.cluster.RoomInfo;
import org.jivesoftware.openfire.muc.cluster.SeniorMemberServicesRequest;
import org.jivesoftware.openfire.muc.cluster.ServiceInfo;
import org.jivesoftware.openfire.muc.cluster.ServiceUpdatedEvent;
import org.jivesoftware.openfire.muc.spi.LocalMUCRoom;
import org.jivesoftware.openfire.muc.spi.MUCPersistenceManager;
import org.jivesoftware.openfire.muc.spi.MUCServicePropertyEventListener;
import org.jivesoftware.openfire.muc.spi.MultiUserChatServiceImpl;
import org.jivesoftware.openfire.stats.Statistic;
import org.jivesoftware.openfire.stats.StatisticsManager;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.util.AlreadyExistsException;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.NotFoundException;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.component.Component;
import org.xmpp.component.ComponentException;
import org.xmpp.component.ComponentManagerFactory;
import org.xmpp.packet.JID;

public class MultiUserChatManager
extends BasicModule
implements ClusterEventListener,
MUCServicePropertyEventListener,
UserEventListener {
    private static final Logger Log = LoggerFactory.getLogger(MultiUserChatManager.class);
    private static final String LOAD_SERVICES = "SELECT subdomain,description,isHidden FROM ofMucService";
    private static final String CREATE_SERVICE = "INSERT INTO ofMucService(serviceID,subdomain,description,isHidden) VALUES(?,?,?,?)";
    private static final String UPDATE_SERVICE = "UPDATE ofMucService SET subdomain=?,description=? WHERE serviceID=?";
    private static final String DELETE_SERVICE = "DELETE FROM ofMucService WHERE serviceID=?";
    private static final String LOAD_SERVICE_ID = "SELECT serviceID FROM ofMucService WHERE subdomain=?";
    private static final String LOAD_SUBDOMAIN = "SELECT subdomain FROM ofMucService WHERE serviceID=?";
    private static final String roomsStatKey = "muc_rooms";
    private static final String occupantsStatKey = "muc_occupants";
    private static final String usersStatKey = "muc_users";
    private static final String incomingStatKey = "muc_incoming";
    private static final String outgoingStatKey = "muc_outgoing";
    private static final String trafficStatGroup = "muc_traffic";
    private ConcurrentHashMap<String, MultiUserChatService> mucServices = new ConcurrentHashMap();

    public MultiUserChatManager() {
        super("Multi user chat manager");
    }

    @Override
    public void start() {
        super.start();
        this.loadServices();
        for (MultiUserChatService service : this.mucServices.values()) {
            this.registerMultiUserChatService(service);
        }
        this.addTotalRoomStats();
        this.addTotalOccupantsStats();
        this.addTotalConnectedUsers();
        this.addNumberIncomingMessages();
        this.addNumberOutgoingMessages();
        ClusterManager.addListener(this);
        UserEventDispatcher.addListener(this);
    }

    @Override
    public void stop() {
        super.stop();
        ClusterManager.removeListener(this);
        UserEventDispatcher.removeListener(this);
        StatisticsManager.getInstance().removeStatistic(roomsStatKey);
        StatisticsManager.getInstance().removeStatistic(occupantsStatKey);
        StatisticsManager.getInstance().removeStatistic(usersStatKey);
        StatisticsManager.getInstance().removeStatistic(incomingStatKey);
        StatisticsManager.getInstance().removeStatistic(outgoingStatKey);
        for (MultiUserChatService service : this.mucServices.values()) {
            this.unregisterMultiUserChatService(service.getServiceName());
        }
    }

    public void registerMultiUserChatService(MultiUserChatService service) {
        Log.debug("MultiUserChatManager: Registering MUC service " + service.getServiceName());
        try {
            ComponentManagerFactory.getComponentManager().addComponent(service.getServiceName(), (Component)service);
            this.mucServices.put(service.getServiceName(), service);
        }
        catch (ComponentException e) {
            Log.error("MultiUserChatManager: Unable to add " + service.getServiceName() + " as component.", (Throwable)e);
        }
    }

    public void unregisterMultiUserChatService(String subdomain) {
        Log.debug("MultiUserChatManager: Unregistering MUC service " + subdomain);
        MultiUserChatService service = this.mucServices.get(subdomain);
        if (service != null) {
            service.shutdown();
            try {
                ComponentManagerFactory.getComponentManager().removeComponent(subdomain);
            }
            catch (ComponentException e) {
                Log.error("MultiUserChatManager: Unable to remove " + subdomain + " from component manager.", (Throwable)e);
            }
            this.mucServices.remove(subdomain);
        }
    }

    public Integer getServicesCount(boolean includePrivate) {
        Integer servicesCnt = this.mucServices.size();
        if (!includePrivate) {
            for (MultiUserChatService service : this.mucServices.values()) {
                if (!service.isHidden()) continue;
                Integer n = servicesCnt;
                Integer n2 = servicesCnt = Integer.valueOf(servicesCnt - 1);
            }
        }
        return servicesCnt;
    }

    public MultiUserChatServiceImpl createMultiUserChatService(String subdomain, String description, Boolean isHidden) throws AlreadyExistsException {
        if (this.getMultiUserChatServiceID(subdomain) != null) {
            throw new AlreadyExistsException();
        }
        MultiUserChatServiceImpl muc = new MultiUserChatServiceImpl(subdomain, description, isHidden);
        this.insertService(subdomain, description, isHidden);
        this.registerMultiUserChatService(muc);
        return muc;
    }

    public void updateMultiUserChatService(Long serviceID, String subdomain, String description) throws NotFoundException {
        MultiUserChatServiceImpl muc = (MultiUserChatServiceImpl)this.getMultiUserChatService(serviceID);
        if (muc == null) {
            throw new NotFoundException();
        }
        String oldsubdomain = muc.getServiceName();
        if (!this.mucServices.containsKey(oldsubdomain)) {
            throw new NotFoundException();
        }
        if (oldsubdomain.equals(subdomain)) {
            this.updateService(serviceID, subdomain, description);
            muc.setDescription(description);
        } else {
            this.unregisterMultiUserChatService(subdomain);
            this.updateService(serviceID, subdomain, description);
            muc = new MultiUserChatServiceImpl(subdomain, description, muc.isHidden());
            this.registerMultiUserChatService(muc);
        }
    }

    public void updateMultiUserChatService(String cursubdomain, String newsubdomain, String description) throws NotFoundException {
        Long serviceID = this.getMultiUserChatServiceID(cursubdomain);
        if (serviceID == null) {
            throw new NotFoundException();
        }
        this.updateMultiUserChatService(serviceID, newsubdomain, description);
    }

    public void removeMultiUserChatService(String subdomain) throws NotFoundException {
        Long serviceID = this.getMultiUserChatServiceID(subdomain);
        if (serviceID == null) {
            Log.error("MultiUserChatManager: Unable to find service to remove for " + subdomain);
            throw new NotFoundException();
        }
        this.removeMultiUserChatService(serviceID);
    }

    public void removeMultiUserChatService(Long serviceID) throws NotFoundException {
        MultiUserChatServiceImpl muc = (MultiUserChatServiceImpl)this.getMultiUserChatService(serviceID);
        if (muc == null) {
            Log.error("MultiUserChatManager: Unable to find service to remove for service ID " + serviceID);
            throw new NotFoundException();
        }
        this.unregisterMultiUserChatService(muc.getServiceName());
        this.deleteService(serviceID);
    }

    public MultiUserChatService getMultiUserChatService(Long serviceID) {
        String subdomain = this.getMultiUserChatSubdomain(serviceID);
        if (subdomain == null) {
            return null;
        }
        return this.mucServices.get(subdomain);
    }

    public MultiUserChatService getMultiUserChatService(String subdomain) {
        return this.mucServices.get(subdomain);
    }

    public MultiUserChatService getMultiUserChatService(JID jid) {
        String subdomain = jid.getDomain().replace("." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "");
        return this.getMultiUserChatService(subdomain);
    }

    public List<MultiUserChatService> getMultiUserChatServices() {
        ArrayList<MultiUserChatService> services = new ArrayList<MultiUserChatService>(this.mucServices.values());
        Collections.sort(services, new ServiceComparator());
        return services;
    }

    public Integer getMultiUserChatServicesCount() {
        return this.mucServices.size();
    }

    public boolean isServiceRegistered(String subdomain) {
        if (subdomain == null) {
            return false;
        }
        return this.mucServices.containsKey(subdomain);
    }

    public Long getMultiUserChatServiceID(String subdomain) {
        Long id = this.loadServiceID(subdomain);
        if (id == -1L) {
            return null;
        }
        return id;
    }

    public String getMultiUserChatSubdomain(Long serviceID) {
        return this.loadServiceSubdomain(serviceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadServices() {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(LOAD_SERVICES);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String subdomain = rs.getString(1);
                String description = rs.getString(2);
                Boolean isHidden = Boolean.valueOf(rs.getString(3));
                MultiUserChatServiceImpl muc = new MultiUserChatServiceImpl(subdomain, description, isHidden);
                this.mucServices.put(subdomain, muc);
            }
        }
        catch (Exception e) {
            try {
                Log.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private long loadServiceID(String subdomain) {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Long id = -1L;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(LOAD_SERVICE_ID);
            pstmt.setString(1, subdomain);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new Exception("Unable to locate Service ID for subdomain " + subdomain);
            }
            id = rs.getLong(1);
        }
        catch (Exception exception) {
            DbConnectionManager.closeConnection(rs, pstmt, con);
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, con);
                throw throwable;
            }
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String loadServiceSubdomain(Long serviceID) {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String subdomain = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(LOAD_SUBDOMAIN);
            pstmt.setLong(1, serviceID);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new Exception("Unable to locate subdomain for service ID " + serviceID);
            }
            subdomain = rs.getString(1);
        }
        catch (Exception exception) {
            DbConnectionManager.closeConnection(rs, pstmt, con);
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, con);
                throw throwable;
            }
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return subdomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertService(String subdomain, String description, Boolean isHidden) {
        Connection con = null;
        PreparedStatement pstmt = null;
        Long serviceID = SequenceManager.nextID(26);
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(CREATE_SERVICE);
            pstmt.setLong(1, serviceID);
            pstmt.setString(2, subdomain);
            if (description != null) {
                pstmt.setString(3, description);
            } else {
                pstmt.setNull(3, 12);
            }
            pstmt.setInt(4, isHidden != false ? 1 : 0);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateService(Long serviceID, String subdomain, String description) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(UPDATE_SERVICE);
            pstmt.setString(1, subdomain);
            if (description != null) {
                pstmt.setString(2, description);
            } else {
                pstmt.setNull(2, 12);
            }
            pstmt.setLong(3, serviceID);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteService(Long serviceID) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_SERVICE);
            pstmt.setLong(1, serviceID);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    private void addTotalRoomStats() {
        Statistic statistic = new Statistic(){

            @Override
            public String getName() {
                return LocaleUtils.getLocalizedString("muc.stats.active_group_chats.name");
            }

            @Override
            public Statistic.Type getStatType() {
                return Statistic.Type.count;
            }

            @Override
            public String getDescription() {
                return LocaleUtils.getLocalizedString("muc.stats.active_group_chats.desc");
            }

            @Override
            public String getUnits() {
                return LocaleUtils.getLocalizedString("muc.stats.active_group_chats.units");
            }

            @Override
            public double sample() {
                double rooms = 0.0;
                for (MultiUserChatService service : MultiUserChatManager.this.getMultiUserChatServices()) {
                    rooms += (double)service.getNumberChatRooms();
                }
                return rooms;
            }

            @Override
            public boolean isPartialSample() {
                return false;
            }
        };
        StatisticsManager.getInstance().addStatistic(roomsStatKey, statistic);
    }

    private void addTotalOccupantsStats() {
        Statistic statistic = new Statistic(){

            @Override
            public String getName() {
                return LocaleUtils.getLocalizedString("muc.stats.occupants.name");
            }

            @Override
            public Statistic.Type getStatType() {
                return Statistic.Type.count;
            }

            @Override
            public String getDescription() {
                return LocaleUtils.getLocalizedString("muc.stats.occupants.description");
            }

            @Override
            public String getUnits() {
                return LocaleUtils.getLocalizedString("muc.stats.occupants.label");
            }

            @Override
            public double sample() {
                double occupants = 0.0;
                for (MultiUserChatService service : MultiUserChatManager.this.getMultiUserChatServices()) {
                    occupants += (double)service.getNumberRoomOccupants();
                }
                return occupants;
            }

            @Override
            public boolean isPartialSample() {
                return false;
            }
        };
        StatisticsManager.getInstance().addStatistic(occupantsStatKey, statistic);
    }

    private void addTotalConnectedUsers() {
        Statistic statistic = new Statistic(){

            @Override
            public String getName() {
                return LocaleUtils.getLocalizedString("muc.stats.users.name");
            }

            @Override
            public Statistic.Type getStatType() {
                return Statistic.Type.count;
            }

            @Override
            public String getDescription() {
                return LocaleUtils.getLocalizedString("muc.stats.users.description");
            }

            @Override
            public String getUnits() {
                return LocaleUtils.getLocalizedString("muc.stats.users.label");
            }

            @Override
            public double sample() {
                double users = 0.0;
                for (MultiUserChatService service : MultiUserChatManager.this.getMultiUserChatServices()) {
                    users += (double)service.getNumberConnectedUsers(false);
                }
                return users;
            }

            @Override
            public boolean isPartialSample() {
                return false;
            }
        };
        StatisticsManager.getInstance().addStatistic(usersStatKey, statistic);
    }

    private void addNumberIncomingMessages() {
        Statistic statistic = new Statistic(){

            @Override
            public String getName() {
                return LocaleUtils.getLocalizedString("muc.stats.incoming.name");
            }

            @Override
            public Statistic.Type getStatType() {
                return Statistic.Type.rate;
            }

            @Override
            public String getDescription() {
                return LocaleUtils.getLocalizedString("muc.stats.incoming.description");
            }

            @Override
            public String getUnits() {
                return LocaleUtils.getLocalizedString("muc.stats.incoming.label");
            }

            @Override
            public double sample() {
                double msgcnt = 0.0;
                for (MultiUserChatService service : MultiUserChatManager.this.getMultiUserChatServices()) {
                    msgcnt += (double)service.getIncomingMessageCount(true);
                }
                return msgcnt;
            }

            @Override
            public boolean isPartialSample() {
                return true;
            }
        };
        StatisticsManager.getInstance().addMultiStatistic(incomingStatKey, trafficStatGroup, statistic);
    }

    private void addNumberOutgoingMessages() {
        Statistic statistic = new Statistic(){

            @Override
            public String getName() {
                return LocaleUtils.getLocalizedString("muc.stats.outgoing.name");
            }

            @Override
            public Statistic.Type getStatType() {
                return Statistic.Type.rate;
            }

            @Override
            public String getDescription() {
                return LocaleUtils.getLocalizedString("muc.stats.outgoing.description");
            }

            @Override
            public String getUnits() {
                return LocaleUtils.getLocalizedString("muc.stats.outgoing.label");
            }

            @Override
            public double sample() {
                double msgcnt = 0.0;
                for (MultiUserChatService service : MultiUserChatManager.this.getMultiUserChatServices()) {
                    msgcnt += (double)service.getOutgoingMessageCount(true);
                }
                return msgcnt;
            }

            @Override
            public boolean isPartialSample() {
                return false;
            }
        };
        StatisticsManager.getInstance().addMultiStatistic(outgoingStatKey, trafficStatGroup, statistic);
    }

    @Override
    public void joinedCluster() {
        List result;
        if (!ClusterManager.isSeniorClusterMember() && (result = (List)CacheFactory.doSynchronousClusterTask(new SeniorMemberServicesRequest(), ClusterManager.getSeniorClusterMember().toByteArray())) != null) {
            for (ServiceInfo serviceInfo : result) {
                MultiUserChatService service = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(serviceInfo.getSubdomain());
                if (service == null) {
                    service = new MultiUserChatServiceImpl(serviceInfo.getSubdomain(), serviceInfo.getDescription(), serviceInfo.isHidden());
                    XMPPServer.getInstance().getMultiUserChatManager().registerMultiUserChatService(service);
                }
                MultiUserChatServiceImpl serviceImpl = (MultiUserChatServiceImpl)service;
                for (RoomInfo roomInfo : serviceInfo.getRooms()) {
                    LocalMUCRoom remoteRoom = roomInfo.getRoom();
                    LocalMUCRoom localRoom = serviceImpl.getLocalChatRoom(remoteRoom.getName());
                    if (localRoom == null) {
                        localRoom = remoteRoom;
                        serviceImpl.chatRoomAdded(localRoom);
                    } else {
                        localRoom.updateConfiguration(remoteRoom);
                    }
                    for (OccupantAddedEvent event : roomInfo.getOccupants()) {
                        event.setSendPresence(true);
                        event.run();
                    }
                }
            }
        }
    }

    @Override
    public void joinedCluster(byte[] nodeID) {
        Object result = CacheFactory.doSynchronousClusterTask(new GetNewMemberRoomsRequest(), nodeID);
        if (result instanceof List) {
            List rooms = (List)result;
            for (RoomInfo roomInfo : rooms) {
                LocalMUCRoom remoteRoom = roomInfo.getRoom();
                MultiUserChatServiceImpl service = (MultiUserChatServiceImpl)remoteRoom.getMUCService();
                LocalMUCRoom localRoom = service.getLocalChatRoom(remoteRoom.getName());
                if (localRoom == null) {
                    localRoom = remoteRoom;
                    service.chatRoomAdded(localRoom);
                }
                for (OccupantAddedEvent event : roomInfo.getOccupants()) {
                    event.setSendPresence(true);
                    event.run();
                }
            }
        }
    }

    @Override
    public void leftCluster() {
    }

    @Override
    public void leftCluster(byte[] nodeID) {
        Log.debug("Removing orphaned occupants associated with defunct node: " + new String(nodeID, StandardCharsets.UTF_8));
        for (MultiUserChatService service : this.getMultiUserChatServices()) {
            for (MUCRoom mucRoom : service.getChatRooms()) {
                for (MUCRole mucRole : mucRoom.getOccupants()) {
                    if (!mucRole.getNodeID().equals(nodeID)) continue;
                    mucRoom.leaveRoom(mucRole);
                }
            }
        }
    }

    @Override
    public void markedAsSeniorClusterMember() {
    }

    @Override
    public void propertySet(String service, String property, Map<String, Object> params) {
        CacheFactory.doSynchronousClusterTask(new ServiceUpdatedEvent(service), false);
    }

    @Override
    public void propertyDeleted(String service, String property, Map<String, Object> params) {
        CacheFactory.doSynchronousClusterTask(new ServiceUpdatedEvent(service), false);
    }

    @Override
    public void userCreated(User user, Map<String, Object> params) {
    }

    @Override
    public void userDeleting(User user, Map<String, Object> params) {
        MUCPersistenceManager.removeAffiliationFromDB(XMPPServer.getInstance().createJID(user.getUsername(), null, true));
    }

    @Override
    public void userModified(User user, Map<String, Object> params) {
    }

    private static class ServiceComparator
    implements Comparator<MultiUserChatService> {
        private ServiceComparator() {
        }

        @Override
        public int compare(MultiUserChatService o1, MultiUserChatService o2) {
            return o1.getServiceName().compareTo(o2.getServiceName());
        }
    }
}

