/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jivesoftware.openfire.muc.MUCEventListener;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class MUCEventDispatcher {
    private static Collection<MUCEventListener> listeners = new ConcurrentLinkedQueue<MUCEventListener>();

    public static void addListener(MUCEventListener listener) {
        listeners.add(listener);
    }

    public static void removeListener(MUCEventListener listener) {
        listeners.remove(listener);
    }

    public static void occupantJoined(JID roomJID, JID user, String nickname) {
        for (MUCEventListener listener : listeners) {
            listener.occupantJoined(roomJID, user, nickname);
        }
    }

    public static void occupantLeft(JID roomJID, JID user) {
        for (MUCEventListener listener : listeners) {
            listener.occupantLeft(roomJID, user);
        }
    }

    public static void nicknameChanged(JID roomJID, JID user, String oldNickname, String newNickname) {
        for (MUCEventListener listener : listeners) {
            listener.nicknameChanged(roomJID, user, oldNickname, newNickname);
        }
    }

    public static void messageReceived(JID roomJID, JID user, String nickname, Message message) {
        for (MUCEventListener listener : listeners) {
            listener.messageReceived(roomJID, user, nickname, message);
        }
    }

    public static void privateMessageRecieved(JID toJID, JID fromJID, Message message) {
        for (MUCEventListener listener : listeners) {
            listener.privateMessageRecieved(toJID, fromJID, message);
        }
    }

    public static void roomCreated(JID roomJID) {
        for (MUCEventListener listener : listeners) {
            listener.roomCreated(roomJID);
        }
    }

    public static void roomDestroyed(JID roomJID) {
        for (MUCEventListener listener : listeners) {
            listener.roomDestroyed(roomJID);
        }
    }

    public static void roomSubjectChanged(JID roomJID, JID user, String newSubject) {
        for (MUCEventListener listener : listeners) {
            listener.roomSubjectChanged(roomJID, user, newSubject);
        }
    }
}

