/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.mediaproxy;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.openfire.mediaproxy.MediaProxySession;
import org.jivesoftware.openfire.mediaproxy.ProxyCandidate;
import org.jivesoftware.openfire.mediaproxy.RelaySession;
import org.jivesoftware.openfire.mediaproxy.SessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaProxy
implements SessionListener {
    private static final Logger Log = LoggerFactory.getLogger(MediaProxy.class);
    private final Map<String, MediaProxySession> sessions = new ConcurrentHashMap<String, MediaProxySession>();
    private String ipAddress;
    private int minPort = 10000;
    private int maxPort = 20000;
    private long idleTime = 60000L;
    private long lifetime = 9000L;

    public MediaProxy(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getPublicIP() {
        return this.ipAddress;
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public void setIdleTime(long idleTime) {
        this.idleTime = idleTime;
    }

    public Collection<MediaProxySession> getSessions() {
        return this.sessions.values();
    }

    public int getMinPort() {
        return this.minPort;
    }

    public void setMinPort(int minPort) {
        this.minPort = minPort;
    }

    public int getMaxPort() {
        return this.maxPort;
    }

    public void setMaxPort(int maxPort) {
        this.maxPort = maxPort;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(long lifetime) {
        this.lifetime = lifetime;
    }

    public MediaProxySession getSession(String sid) {
        MediaProxySession proxySession = this.sessions.get(sid);
        if (proxySession != null && Log.isDebugEnabled()) {
            Log.debug("MediaProxy: SID: " + sid + " agentSID: " + proxySession.getSID());
            return proxySession;
        }
        return null;
    }

    @Override
    public void sessionClosed(MediaProxySession session) {
        this.sessions.remove(session.getSID());
        if (Log.isDebugEnabled()) {
            Log.debug("MediaProxy: Session: " + session.getSID() + " removed.");
        }
    }

    public ProxyCandidate addRelayAgent(String id, String creator, String hostA, int portA, String hostB, int portB) {
        RelaySession session = new RelaySession(id, creator, this.ipAddress, hostA, portA, hostB, portB, this.minPort, this.maxPort);
        this.sessions.put(id, session);
        session.addKeepAlive(this.idleTime);
        session.addLifeTime(this.lifetime);
        session.addAgentListener(this);
        return session;
    }

    public ProxyCandidate addRelayAgent(String id, String creator) {
        return this.addRelayAgent(id, creator, this.ipAddress, 40000, this.ipAddress, 40004);
    }

    void stopProxy() {
        for (MediaProxySession session : this.getSessions()) {
            try {
                session.clearAgentListeners();
                session.stopAgent();
            }
            catch (Exception e) {
                Log.error("Error cleaning up media proxy sessions", (Throwable)e);
            }
        }
        this.sessions.clear();
    }
}

